/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.fs.SftpPosixFileAttributes;
import org.apache.sshd.sftp.client.impl.AbstractSftpFileAttributeView;

public class SftpPosixFileAttributeView
extends AbstractSftpFileAttributeView
implements PosixFileAttributeView {
    public SftpPosixFileAttributeView(SftpFileSystemProvider provider, Path path, LinkOption ... options) {
        super(provider, path, options);
    }

    @Override
    public String name() {
        return "posix";
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return new SftpPosixFileAttributes(this.path, this.readRemoteAttributes());
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        if (lastModifiedTime != null) {
            attrs.modifyTime(lastModifiedTime);
        }
        if (lastAccessTime != null) {
            attrs.accessTime(lastAccessTime);
        }
        if (createTime != null) {
            attrs.createTime(createTime);
        }
        if (GenericUtils.isEmpty(attrs.getFlags())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setTimes({}) no changes", (Object)this.path);
            }
        } else {
            this.writeRemoteAttributes(attrs);
        }
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
        this.provider.setAttribute(this.path, "permissions", perms, this.options);
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
        this.provider.setAttribute(this.path, "group", group, this.options);
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.readAttributes().owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.provider.setAttribute(this.path, "owner", owner, this.options);
    }
}

