/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.session.proxyprotocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.session.AbstractServerSession;
import org.apache.sshd.server.session.ServerSession;

public class ProxyProtocolAcceptor
extends AbstractLoggingBean {
    public static final int MAX_PROXY_HEADER_LENGTH = 127;
    public static final String PROX_PROTOCOL_PREFIX = "PROXY";
    private static final byte[] PROXY_HEADER = new byte[]{80, 82, 79, 88, 89, 32};

    public boolean acceptServerProxyMetadata(ServerSession session, Buffer buffer) throws Exception {
        int mark = buffer.rpos();
        int dataLen = buffer.available();
        if (dataLen < PROXY_HEADER.length) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("acceptServerProxyMetadata(session={}) incomplete data - {}/{}", new Object[]{session, dataLen, PROXY_HEADER.length});
            }
            return false;
        }
        byte[] proxyHeader = new byte[PROXY_HEADER.length];
        buffer.getRawBytes(proxyHeader);
        buffer.rpos(mark);
        if (!Arrays.equals(PROXY_HEADER, proxyHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("acceptServerProxyMetadata(session={}) mismatched protocol header: expected={}, actual={}", new Object[]{session, BufferUtils.toHex((char)':', (byte[])PROXY_HEADER), BufferUtils.toHex((char)':', (byte[])proxyHeader)});
            }
            return true;
        }
        StringBuilder proxyPayload = new StringBuilder(127);
        while (proxyPayload.length() < 127 && buffer.available() > 0) {
            char ch = (char)buffer.getUByte();
            if (ch != '\n') {
                proxyPayload.append(ch);
                continue;
            }
            int ppLen = proxyPayload.length();
            if (ppLen > 0 && proxyPayload.charAt(ppLen - 1) == '\r') {
                proxyPayload.setLength(ppLen - 1);
            }
            return this.parseProxyHeader(session, proxyPayload.toString());
        }
        buffer.rpos(mark);
        return false;
    }

    protected boolean parseProxyHeader(ServerSession session, String proxyHeader) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("parseProxyHeader(session={}) parsing header='{}'", (Object)session, (Object)proxyHeader);
        }
        String[] proxyFields = GenericUtils.split((String)proxyHeader, (char)' ');
        for (int index = 0; index < proxyFields.length; ++index) {
            String f = proxyFields[index];
            proxyFields[index] = GenericUtils.trimToEmpty((String)f);
        }
        String proxyProtocolPrefix = proxyFields[0];
        ValidateUtils.checkTrue((boolean)PROX_PROTOCOL_PREFIX.equalsIgnoreCase(proxyProtocolPrefix), (String)"Mismatched protocol prefix: %s", (Object)proxyProtocolPrefix);
        String protocolVersion = proxyFields[1];
        if ("TCP4".equalsIgnoreCase(protocolVersion) || "TCP6".equalsIgnoreCase(protocolVersion)) {
            String layer3SrcAddress = proxyFields[2];
            String layer3DstAddress = proxyFields[3];
            String layer3SrcPort = proxyFields[4];
            String layer3DstPort = proxyFields[5];
            if (debugEnabled) {
                this.log.debug("parseProxyHeader(session={}) using {}:{} -> {}:{} proxy", new Object[]{session, layer3SrcAddress, layer3SrcPort, layer3DstAddress, layer3DstPort});
            }
            if (session instanceof AbstractServerSession) {
                InetSocketAddress clientAddress = new InetSocketAddress(layer3SrcAddress, Integer.parseInt(layer3SrcPort));
                ((AbstractServerSession)session).setClientAddress((SocketAddress)clientAddress);
            }
        } else {
            this.log.warn("parseProxyHeader(session={}) unsuppored sub-protocol - {} - continue as usual", (Object)session, (Object)protocolVersion);
        }
        return true;
    }
}

