/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.ScrollPosition;
import org.apache.myfaces.tobago.model.ScrollPositionState;
import org.apache.myfaces.tobago.model.SelectedState;

public class SheetState
implements Serializable,
ScrollPositionState {
    private static final long serialVersionUID = 2L;
    @Deprecated
    public static final String SEPARATOR = ",";
    private int first;
    private String sortedColumnId;
    private boolean ascending;
    private boolean toBeSorted;
    private List<Integer> columnWidths;
    private List<Integer> selectedRows;
    private ScrollPosition scrollPosition;
    private ExpandedState expandedState;
    private SelectedState selectedState;

    public SheetState() {
        this.reset();
    }

    public void reset() {
        this.first = -1;
        this.sortedColumnId = null;
        this.ascending = true;
        this.toBeSorted = false;
        this.columnWidths = new ArrayList<Integer>();
        this.resetSelected();
        if (this.expandedState != null) {
            this.expandedState.reset();
        }
        if (this.selectedState != null) {
            this.selectedState.clear();
        }
        if (this.scrollPosition != null) {
            this.scrollPosition.clear();
        } else {
            this.scrollPosition = new ScrollPosition();
        }
    }

    public void resetSelected() {
        this.selectedRows = new ArrayList<Integer>();
    }

    public List<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public void setSelectedRows(List<Integer> selectedRows) {
        assert (selectedRows != null);
        this.selectedRows = selectedRows;
    }

    public String getSortedColumnId() {
        return this.sortedColumnId;
    }

    public void setSortedColumnId(String sortedColumnId) {
        if (StringUtils.notEquals(this.sortedColumnId, sortedColumnId)) {
            this.sortedColumnId = sortedColumnId;
            this.toBeSorted = true;
        }
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        if (this.ascending != ascending) {
            this.ascending = ascending;
            this.toBeSorted = true;
        }
    }

    public List<Integer> getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(List<Integer> columnWidths) {
        this.columnWidths = columnWidths;
    }

    public boolean isDefinedColumnWidths() {
        for (Integer columnWidth : this.columnWidths) {
            if (columnWidth >= 0) continue;
            return false;
        }
        return this.columnWidths.size() > 0;
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    @Deprecated
    public void updateSortState(SortActionEvent sortEvent) {
        this.updateSortState(sortEvent.getColumn().getId());
    }

    public void updateSortState(String columnId) {
        if (columnId.equals(this.sortedColumnId)) {
            this.setAscending(!this.isAscending());
        } else {
            this.setAscending(true);
            this.setSortedColumnId(columnId);
        }
    }

    public void resetSortState() {
        this.setAscending(true);
        this.setSortedColumnId(null);
    }

    @Override
    public ScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(ScrollPosition scrollPosition) {
        this.scrollPosition = scrollPosition;
    }

    public ExpandedState getExpandedState() {
        if (this.expandedState == null) {
            this.expandedState = new ExpandedState(2);
        }
        return this.expandedState;
    }

    public void setExpandedState(ExpandedState expandedState) {
        this.expandedState = expandedState;
    }

    public SelectedState getSelectedState() {
        if (this.selectedState == null) {
            this.selectedState = new SelectedState();
        }
        return this.selectedState;
    }

    public void setSelectedState(SelectedState selectedState) {
        this.selectedState = selectedState;
    }

    public boolean isToBeSorted() {
        return this.toBeSorted;
    }

    public void setToBeSorted(boolean toBeSorted) {
        this.toBeSorted = toBeSorted;
    }
}

