/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIMeta;
import org.apache.myfaces.tobago.internal.component.AbstractUIMetaLink;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIScript;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.Secret;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRenderer<T extends AbstractUIPage>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LAST_FOCUS_ID = "lastFocusId";
    private static final String HEAD_TARGET = "head";
    private static final String BODY_TARGET = "body";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String clientId = component.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        String lastFocusId = (String)externalContext.getRequestParameterMap().get(clientId + "::" + LAST_FOCUS_ID);
        if (lastFocusId != null) {
            TobagoContext.getInstance(facesContext).setFocusId(lastFocusId);
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        String language;
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        TobagoContext tobagoContext = TobagoContext.getInstance(facesContext);
        if (tobagoContext.getFocusId() == null && !StringUtils.isBlank(((AbstractUIPage)component).getFocusId())) {
            tobagoContext.setFocusId(((AbstractUIPage)component).getFocusId());
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        facesContext.setResponseWriter((ResponseWriter)writer);
        if (tobagoConfig.isPreventFrameAttacks()) {
            ResponseUtils.ensureXFrameOptionsHeader(facesContext);
        }
        ResponseUtils.ensureNoCacheHeader(facesContext);
        ResponseUtils.ensureContentSecurityPolicyHeader(facesContext, tobagoConfig.getContentSecurityPolicy());
        if (LOG.isDebugEnabled()) {
            Iterator iterator = component.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                LOG.debug("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'");
            }
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        Object request = externalContext.getRequest();
        Object response = externalContext.getResponse();
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String viewId = viewRoot.getViewId();
        String formAction = externalContext.encodeActionURL(viewHandler.getActionURL(facesContext, viewId));
        boolean ajax = facesContext.getPartialViewContext().isAjaxRequest();
        String contentType = writer.getContentTypeWithCharSet();
        ResponseUtils.ensureContentTypeHeader(facesContext, contentType);
        if (tobagoConfig.isSetNosniffHeader()) {
            ResponseUtils.ensureNosniffHeader(facesContext);
        }
        Theme theme = tobagoContext.getTheme();
        String clientId = component.getClientId(facesContext);
        boolean productionMode = facesContext.isProjectStage(ProjectStage.Production);
        Markup markup = component.getMarkup();
        TobagoClass spread = markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null;
        String title = ((AbstractUIPage)component).getLabel();
        Locale locale = viewRoot.getLocale();
        writer.startElement(HtmlElements.HTML);
        if (locale != null && (language = locale.getLanguage()) != null) {
            writer.writeAttribute(HtmlAttributes.LANG, language, false);
        }
        writer.writeClassAttribute(spread);
        writer.startElement(HtmlElements.HEAD);
        HeadResources headResources = new HeadResources(facesContext, viewRoot.getComponentResources(facesContext, HEAD_TARGET), writer.getCharacterEncoding());
        for (UIComponent uIComponent : headResources.getMetas()) {
            uIComponent.encodeAll(facesContext);
        }
        writer.startElement(HtmlElements.TITLE);
        writer.writeText(title != null ? title : "");
        writer.endElement(HtmlElements.TITLE);
        AbstractUIStyle style = null;
        ThemeStyle[] themeStyleArray = theme.getStyleResources(productionMode);
        int n = themeStyleArray.length;
        for (int i = 0; i < n; ++i) {
            ThemeStyle themeStyle = themeStyleArray[i];
            if (style == null) {
                style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
                style.setTransient(true);
            }
            style.setFile(contextPath + themeStyle.getName());
            style.encodeAll(facesContext);
        }
        for (UIComponent styles : headResources.getStyles()) {
            styles.encodeAll(facesContext);
        }
        for (ThemeScript themeScript : theme.getScriptResources(productionMode)) {
            AbstractUIScript script = (AbstractUIScript)facesContext.getApplication().createComponent(facesContext, Tags.script.componentType(), RendererTypes.Script.name());
            script.setTransient(true);
            script.setFile(contextPath + themeScript.getName());
            script.setType(themeScript.getType());
            script.encodeAll(facesContext);
        }
        for (UIComponent scripts : headResources.getScripts()) {
            scripts.encodeAll(facesContext);
        }
        for (UIComponent misc : headResources.getMisc()) {
            misc.encodeAll(facesContext);
        }
        writer.endElement(HtmlElements.HEAD);
        writer.startElement(HtmlElements.BODY);
        writer.writeClassAttribute(spread);
        writer.startElement(HtmlElements.TOBAGO_PAGE);
        writer.writeAttribute(CustomAttributes.LOCALE, locale.toString(), false);
        writer.writeClassAttribute(BootstrapClass.CONTAINER_FLUID, spread, component.getCustomClass());
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute(HtmlAttributes.FOCUS_ON_ERROR, Boolean.toString(tobagoContext.getFocusOnError()), false);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.WAIT_OVERLAY_DELAY_FULL, tobagoContext.getWaitOverlayDelayFull());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.WAIT_OVERLAY_DELAY_AJAX, tobagoContext.getWaitOverlayDelayAjax());
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        writer.startElement(HtmlElements.FORM);
        writer.writeClassAttribute(spread);
        writer.writeAttribute(HtmlAttributes.ACTION, formAction, true);
        writer.writeIdAttribute(((AbstractUIPage)component).getFormId(facesContext));
        writer.writeAttribute(HtmlAttributes.METHOD, this.getMethod((AbstractUIPage)component), false);
        String string = tobagoContext.getEnctype();
        if (string != null) {
            writer.writeAttribute(HtmlAttributes.ENCTYPE, string, false);
        }
        writer.writeAttribute(HtmlAttributes.ACCEPT_CHARSET, AbstractUIPage.FORM_ACCEPT_CHARSET.name(), false);
        writer.writeAttribute(DataAttributes.CONTEXT_PATH, contextPath, true);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute("javax.faces.source");
        writer.writeIdAttribute("javax.faces.source");
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
        writer.endElement(HtmlElements.INPUT);
        String lastFocusId = clientId + "::" + LAST_FOCUS_ID;
        writer.startElement(HtmlElements.TOBAGO_FOCUS);
        writer.writeIdAttribute(lastFocusId);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(lastFocusId);
        writer.writeIdAttribute(lastFocusId + "::" + "field");
        writer.writeAttribute(HtmlAttributes.VALUE, tobagoContext.getFocusId(), true);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.TOBAGO_FOCUS);
        if (tobagoConfig.isCheckSessionSecret()) {
            Secret secret = Secret.getInstance(facesContext);
            if (secret != null) {
                writer.startElement(HtmlElements.INPUT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
                writer.writeAttribute(HtmlAttributes.NAME, Secret.KEY, false);
                writer.writeAttribute(HtmlAttributes.ID, Secret.KEY, false);
                writer.writeAttribute(HtmlAttributes.VALUE, secret.getSecret(), false);
                writer.endElement(HtmlElements.INPUT);
            } else {
                LOG.warn("Missing session secret!");
            }
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__MENU_STORE);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__TOAST_STORE);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(clientId + "::" + "jsf-state-container");
        writer.flush();
        if (!ajax) {
            viewHandler.writeState(facesContext);
        }
        writer.endElement(HtmlElements.SPAN);
        if (component.getFacet("backButtonDetector") != null) {
            UIComponent hidden = component.getFacet("backButtonDetector");
            hidden.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.FORM);
        writer.startElement(HtmlElements.NOSCRIPT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.PAGE__NOSCRIPT);
        writer.writeText(ResourceUtils.getString(facesContext, "page.noscript"));
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.NOSCRIPT);
        writer.endElement(HtmlElements.TOBAGO_PAGE);
        List bodyResources = viewRoot.getComponentResources(facesContext, BODY_TARGET);
        for (UIComponent bodyResource : bodyResources) {
            bodyResource.encodeAll(facesContext);
        }
        writer.endElement(HtmlElements.BODY);
        writer.endElement(HtmlElements.HTML);
        AccessKeyLogger.logStatus(facesContext);
    }

    private String getMethod(AbstractUIPage page) {
        return ComponentUtils.getStringAttribute((UIComponent)page, Attributes.method, "post");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private static class HeadResources {
        private List<UIComponent> metas = new ArrayList<UIComponent>();
        private List<UIComponent> styles = new ArrayList<UIComponent>();
        private List<UIComponent> scripts = new ArrayList<UIComponent>();
        private List<UIComponent> misc = new ArrayList<UIComponent>();

        HeadResources(FacesContext facesContext, Collection<? extends UIComponent> collection, String charset) {
            for (UIComponent uIComponent : collection) {
                Map attributes;
                if (uIComponent instanceof AbstractUIMeta || uIComponent instanceof AbstractUIMetaLink) {
                    this.metas.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof AbstractUIStyle) {
                    this.styles.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof AbstractUIScript) {
                    this.scripts.add(uIComponent);
                    continue;
                }
                if (uIComponent instanceof UIOutput && "javax.faces".equals((attributes = uIComponent.getAttributes()).get("library")) && "jsf.js".equals(attributes.get("name"))) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skip rendering resource jsf.js");
                    continue;
                }
                this.misc.add(uIComponent);
            }
            if (!this.containsNameViewport(this.metas)) {
                AbstractUIMeta viewportMeta = (AbstractUIMeta)facesContext.getApplication().createComponent(facesContext, Tags.meta.componentType(), RendererTypes.Meta.name());
                viewportMeta.setName("viewport");
                viewportMeta.setContent("width=device-width, initial-scale=1.0");
                viewportMeta.setTransient(true);
                this.metas.add(0, (UIComponent)viewportMeta);
            }
            if (!this.containsCharset(this.metas)) {
                AbstractUIMeta charsetMeta = (AbstractUIMeta)facesContext.getApplication().createComponent(facesContext, Tags.meta.componentType(), RendererTypes.Meta.name());
                charsetMeta.setCharset(charset);
                charsetMeta.setTransient(true);
                this.metas.add(0, (UIComponent)charsetMeta);
            }
        }

        public List<UIComponent> getMetas() {
            return this.metas;
        }

        public List<UIComponent> getStyles() {
            return this.styles;
        }

        public List<UIComponent> getScripts() {
            return this.scripts;
        }

        public List<UIComponent> getMisc() {
            return this.misc;
        }

        private boolean containsCharset(List<UIComponent> headComponents) {
            for (UIComponent headComponent : headComponents) {
                if (!(headComponent instanceof AbstractUIMeta) || ((AbstractUIMeta)headComponent).getCharset() == null) continue;
                return true;
            }
            return false;
        }

        private boolean containsNameViewport(List<UIComponent> headComponents) {
            for (UIComponent headComponent : headComponents) {
                if (!(headComponent instanceof AbstractUIMeta) || !"viewport".equals(((AbstractUIMeta)headComponent).getName())) continue;
                return true;
            }
            return false;
        }
    }
}

