/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.internal.component.AbstractUIHidden;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingInputRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class HiddenRenderer<T extends AbstractUIHidden>
extends DecodingInputRendererBase<T> {
    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIHidden)((Object)component)).isDisabled();
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        String clientId = component.getClientId(facesContext);
        String value = this.getCurrentValue(facesContext, component);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.INPUT);
        if (((AbstractUIHidden)((Object)component)).isDisabled()) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
        } else {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        }
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute(HtmlAttributes.VALUE, value != null ? value : "", true);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.INPUT);
    }
}

