/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class Base64InputStream
extends InputStream {
    private static final int _QUANTUM_SIZE = 512;
    private final Reader _in;
    private int _byteBufferIndex;
    private int _maxByteBufferIndex;
    private byte[] _byteBuffer;

    public Base64InputStream(Reader in) {
        this._in = in;
        this._byteBufferIndex = Integer.MAX_VALUE;
        this._maxByteBufferIndex = 0;
        this._byteBuffer = new byte[384];
    }

    public int read() throws IOException {
        int result = -1;
        if (this._byteBufferIndex <= this._maxByteBufferIndex) {
            result = this._byteBuffer[this._byteBufferIndex];
            result &= 0xFF;
            ++this._byteBufferIndex;
        } else {
            int b = this._fillByteBuffer();
            if (b > -1) {
                return this.read();
            }
        }
        return result;
    }

    public void close() throws IOException {
        this._in.close();
    }

    public int available() throws IOException {
        return this._in.ready() ? 1 : 0;
    }

    private int _fillByteBuffer() throws IOException {
        char[] encodedBuffer = new char[512];
        int numValidCharsRead = this._in.read(encodedBuffer, 0, 512);
        this._byteBufferIndex = -1;
        for (int i = 0; i < numValidCharsRead; i += 4) {
            char eb1 = encodedBuffer[i];
            char eb2 = encodedBuffer[i + 1];
            char eb3 = encodedBuffer[i + 2];
            char eb4 = encodedBuffer[i + 3];
            char c1 = Base64InputStream._decode(eb1);
            char c2 = Base64InputStream._decode(eb2);
            char c3 = Base64InputStream._decode(eb3);
            char c4 = Base64InputStream._decode(eb4);
            ++this._byteBufferIndex;
            this._byteBuffer[this._byteBufferIndex] = (byte)(c1 << 2 | c2 >> 4 & 3);
            if (eb3 != '=') {
                ++this._byteBufferIndex;
                this._byteBuffer[this._byteBufferIndex] = (byte)(c2 << 4 | c3 >> 2 & 0xF);
            }
            if (eb4 == '=') continue;
            ++this._byteBufferIndex;
            this._byteBuffer[this._byteBufferIndex] = (byte)(c3 << 6 | c4 & 0x3F);
        }
        this._maxByteBufferIndex = this._byteBufferIndex;
        this._byteBufferIndex = 0;
        return this._maxByteBufferIndex;
    }

    private static char _decode(int c) {
        if (c >= 65 && c <= 90) {
            return (char)(c - 65);
        }
        if (c >= 97 && c <= 122) {
            return (char)(c - 97 + 26);
        }
        if (c >= 48 && c <= 57) {
            return (char)(c - 48 + 52);
        }
        if (c == 43) {
            return '>';
        }
        if (c == 47) {
            return '?';
        }
        if (c == 61) {
            return '=';
        }
        return '\u0000';
    }
}

