/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadRequestManager {
    private boolean _parametersRetrieved = false;
    private Map<String, String[]> _extractedAndDecodedParams;
    private Map<String, String[]> _extractedParams;
    private Map<String, String[]> _params;
    private Map<String, String[]> _requestParams;
    private String _encoding;
    private static final String _WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UploadRequestManager.class);

    public UploadRequestManager(ExternalContext ec, Map<String, String[]> params) {
        this._params = params;
        this.setRequest(ec);
    }

    public UploadRequestManager(HttpServletRequest req, Map<String, String[]> params) {
        this._params = params;
        this.setRequest(req);
    }

    public String getContentType() {
        return _WWW_FORM_URLENCODED_TYPE;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding.equals(this._encoding)) {
            return;
        }
        this._encoding = encoding;
        if (_LOG.isFine()) {
            _LOG.fine("Switching encoding of wrapper to " + encoding);
        }
        Map<String, String[]> extractedParams = this._getExtractedParams();
        HashMap<String, String[]> decodedParams = new HashMap<String, String[]>(extractedParams.size());
        byte[] buffer = new byte[256];
        for (Map.Entry<String, String[]> entry : extractedParams.entrySet()) {
            String key = entry.getKey();
            key = CaboHttpUtils.decodeRequestParameter(key, encoding, buffer);
            String[] oldValue = entry.getValue();
            int length = oldValue.length;
            String[] newValue = new String[length];
            for (int i = 0; i < length; ++i) {
                newValue[i] = CaboHttpUtils.decodeRequestParameter(oldValue[i], encoding, buffer);
                if (!_LOG.isFinest()) continue;
                _LOG.finest("Parameter " + key + ":" + newValue[i]);
            }
            decodedParams.put(key, newValue);
        }
        this._extractedAndDecodedParams = Collections.unmodifiableMap(decodedParams);
    }

    public String getParameter(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return value[0];
    }

    public Map<String, String[]> getParameterMap() {
        this._parametersRetrieved = true;
        if (this._extractedAndDecodedParams != null) {
            return this._extractedAndDecodedParams;
        }
        return this._getExtractedParams();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return (String[])value.clone();
    }

    public boolean isParameterRetrieved() {
        return this._parametersRetrieved;
    }

    public void setRequest(ExternalContext ec) {
        this._clearMap();
        this._requestParams = ec.getRequestParameterValuesMap();
        this._encoding = ec.getRequestCharacterEncoding();
    }

    public void setRequest(HttpServletRequest req) {
        this._clearMap();
        this._requestParams = req.getParameterMap();
        this._encoding = req.getCharacterEncoding();
    }

    private Map<String, String[]> _getExtractedParams() {
        if (this._extractedParams == null) {
            HashMap<String, String[]> m = new HashMap<String, String[]>(this._requestParams);
            m.putAll(this._params);
            this._extractedParams = Collections.unmodifiableMap(m);
        }
        return this._extractedParams;
    }

    private String[] _getParameterValues(String param) {
        return this.getParameterMap().get(param);
    }

    private void _clearMap() {
        this._parametersRetrieved = false;
        this._extractedAndDecodedParams = null;
        this._extractedParams = null;
    }
}

