/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.painter.ImageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceUtils {
    private static final String _PROVIDER_ERROR = "Could not get InputStreamProvider";
    private static final String _INPUT_STREAM_ERROR = "Could not get InputStream";
    private static final String _IMAGE_ERROR = "Could not create image";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SourceUtils.class);

    SourceUtils() {
    }

    public static Image getSourceIcon(ImageContext context, Map<Object, Object> properties) {
        return SourceUtils.getSourceIcon(context, properties, ImageConstants.SOURCE_INPUT_STREAM_PROVIDER_KEY);
    }

    public static Image getSourceIcon(ImageContext context, Map<Object, Object> properties, Object key) {
        InputStreamProvider provider = (InputStreamProvider)properties.get(key);
        if (provider == null) {
            SourceUtils._log(properties, "Could not get InputStreamProvider (" + SourceUtils._getKeyName(key) + ")", null);
            return null;
        }
        InputStream in = null;
        try {
            in = provider.openInputStream();
        }
        catch (IOException e) {
            SourceUtils._log(properties, _INPUT_STREAM_ERROR, e);
            return null;
        }
        if (in == null) {
            SourceUtils._log(properties, _INPUT_STREAM_ERROR, null);
            return null;
        }
        Image source = ImageUtils.getImageFromStream(in);
        if (source == null) {
            SourceUtils._log(properties, _IMAGE_ERROR, null);
        }
        return source;
    }

    private static void _log(Map<Object, Object> properties, String message, Throwable t) {
        if (_LOG.isWarning()) {
            String source = (String)properties.get(ImageConstants.SOURCE_KEY);
            if (source != null) {
                message = message + "for source icon " + source;
            }
            _LOG.warning(message, t);
        }
    }

    private static String _getKeyName(Object key) {
        return key.toString();
    }
}

