/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.distributedlog.AppendOnlyStreamWriter;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsData;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsImpl;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.dlog.DLInputStream;
import org.apache.pulsar.functions.worker.dlog.DLOutputStream;
import org.apache.pulsar.metadata.impl.MetadataStoreFactoryImpl;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerUtils.class);

    private WorkerUtils() {
    }

    public static void uploadFileToBookkeeper(String packagePath, File sourceFile, Namespace dlogNamespace) throws IOException {
        try (FileInputStream uploadedInputStream = new FileInputStream(sourceFile);){
            WorkerUtils.uploadToBookKeeper(dlogNamespace, uploadedInputStream, packagePath);
        }
    }

    public static void uploadToBookKeeper(Namespace dlogNamespace, InputStream uploadedInputStream, String destPkgPath) throws IOException {
        if (dlogNamespace.logExists(destPkgPath)) {
            log.info("Target function file already exists at '{}'. Overwriting it now", (Object)destPkgPath);
            dlogNamespace.deleteLog(destPkgPath);
        }
        log.info("Uploading function package to '{}'", (Object)destPkgPath);
        try (DistributedLogManager dlm = dlogNamespace.openLog(destPkgPath);
             AppendOnlyStreamWriter writer = dlm.getAppendOnlyStreamWriter();
             DLOutputStream out = new DLOutputStream(dlm, writer);){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            ((OutputStream)out).flush();
        }
    }

    public static void downloadFromBookkeeper(Namespace namespace, File outputFile, String packagePath) throws IOException {
        WorkerUtils.downloadFromBookkeeper(namespace, new FileOutputStream(outputFile), packagePath);
    }

    public static void downloadFromBookkeeper(Namespace namespace, OutputStream outputStream, String packagePath) throws IOException {
        log.info("Downloading {} from BK...", (Object)packagePath);
        DistributedLogManager dlm = namespace.openLog(packagePath);
        try (DLInputStream in = new DLInputStream(dlm);){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.flush();
        }
    }

    public static void deleteFromBookkeeper(Namespace namespace, String packagePath) throws IOException {
        log.info("Deleting {} from BK", (Object)packagePath);
        namespace.deleteLog(packagePath);
    }

    public static DistributedLogConfiguration getDlogConf(WorkerConfig workerConfig) {
        int numReplicas = workerConfig.getNumFunctionPackageReplicas();
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setWriteLockEnabled(false).setOutputBufferSize(262144).setPeriodicFlushFrequencyMilliSeconds(0).setImmediateFlushEnabled(false).setLogSegmentRollingIntervalMinutes(0).setMaxLogSegmentBytes(Long.MAX_VALUE).setExplicitTruncationByApplication(true).setRetentionPeriodHours(Integer.MAX_VALUE).setEnsembleSize(numReplicas).setWriteQuorumSize(numReplicas).setAckQuorumSize(numReplicas).setUseDaemonThread(true);
        conf.setProperty("bkc.allowShadedLedgerManagerFactoryClass", (Object)true);
        conf.setProperty("bkc.shadedLedgerManagerFactoryClassPrefix", (Object)"dlshade.");
        if (StringUtils.isNotBlank((CharSequence)workerConfig.getBookkeeperClientAuthenticationPlugin())) {
            conf.setProperty("bkc.clientAuthProviderFactoryClass", (Object)workerConfig.getBookkeeperClientAuthenticationPlugin());
            if (StringUtils.isNotBlank((CharSequence)workerConfig.getBookkeeperClientAuthenticationParametersName())) {
                conf.setProperty("bkc." + workerConfig.getBookkeeperClientAuthenticationParametersName(), (Object)workerConfig.getBookkeeperClientAuthenticationParameters());
            }
        }
        PropertiesUtils.filterAndMapProperties((Properties)workerConfig.getProperties(), (String)"bookkeeper_", (String)"bkc.").forEach((key, value) -> {
            log.info("Applying DLog BookKeeper client configuration setting {}={}", key, value);
            conf.setProperty(key, value);
        });
        return conf;
    }

    public static URI newDlogNamespaceURI(String zookeeperServers) {
        return URI.create(String.format("distributedlog://%s/pulsar/functions", zookeeperServers));
    }

    public static URI initializeDlogNamespace(InternalConfigurationData internalConf) throws IOException {
        String chrootPath;
        String ledgersStoreServers;
        String ledgersRootPath;
        if (internalConf.getBookkeeperMetadataServiceUri() == null) {
            ledgersRootPath = internalConf.getLedgersRootPath();
            ledgersStoreServers = MetadataStoreFactoryImpl.removeIdentifierFromMetadataURL((String)internalConf.getMetadataStoreUrl());
            chrootPath = "";
        } else {
            URI metadataServiceUri = URI.create(internalConf.getBookkeeperMetadataServiceUri());
            ledgersStoreServers = metadataServiceUri.getAuthority().replace(";", ",");
            String fullPath = metadataServiceUri.getPath();
            if (StringUtils.isBlank((CharSequence)fullPath)) {
                chrootPath = "";
                ledgersRootPath = "/";
            } else {
                if (!fullPath.startsWith("/")) {
                    throw new IllegalStateException("Found invalid path: " + fullPath + " for metadataServiceUri: " + String.valueOf(metadataServiceUri));
                }
                ledgersRootPath = fullPath;
                int lastSlash = fullPath.lastIndexOf("/");
                chrootPath = lastSlash == 0 ? "" : fullPath.substring(0, lastSlash);
            }
        }
        BKDLConfig dlConfig = new BKDLConfig(ledgersStoreServers, ledgersRootPath);
        DLMetadata dlMetadata = DLMetadata.create((BKDLConfig)dlConfig);
        URI dlogUri = WorkerUtils.newDlogNamespaceURI(ledgersStoreServers + chrootPath);
        log.info("initialize DistributedLog Namespace with ledgersStoreServers: {} ledgersRootPath: {} uri: {}", new Object[]{ledgersStoreServers, ledgersRootPath, dlogUri});
        try {
            dlMetadata.create(dlogUri);
        }
        catch (ZKException e) {
            if (e.getKeeperExceptionCode() == KeeperException.Code.NODEEXISTS) {
                return dlogUri;
            }
            throw e;
        }
        return dlogUri;
    }

    public static PulsarAdmin getPulsarAdminClient(String pulsarWebServiceUrl, String authPlugin, String authParams, String tlsTrustCertsFilePath, Boolean allowTlsInsecureConnection, Boolean enableTlsHostnameVerification, WorkerConfig workerConfig) {
        log.info("Create Pulsar Admin to service url {}: authPlugin = {}, authParams = {}, tlsTrustCerts = {}, allowTlsInsecureConnection = {}, enableTlsHostnameVerification = {}", new Object[]{pulsarWebServiceUrl, authPlugin, authParams, tlsTrustCertsFilePath, allowTlsInsecureConnection, enableTlsHostnameVerification});
        try {
            PulsarAdminBuilder adminBuilder = PulsarAdmin.builder().serviceHttpUrl(pulsarWebServiceUrl);
            if (workerConfig != null) {
                adminBuilder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)workerConfig.getProperties(), (String)"brokerClient_"));
            }
            if (StringUtils.isNotBlank((CharSequence)authPlugin) && StringUtils.isNotBlank((CharSequence)authParams)) {
                adminBuilder.authentication(authPlugin, authParams);
            }
            if (StringUtils.isNotBlank((CharSequence)tlsTrustCertsFilePath)) {
                adminBuilder.tlsTrustCertsFilePath(tlsTrustCertsFilePath);
            }
            if (allowTlsInsecureConnection != null) {
                adminBuilder.allowTlsInsecureConnection(allowTlsInsecureConnection.booleanValue());
            }
            if (enableTlsHostnameVerification != null) {
                adminBuilder.enableTlsHostnameVerification(enableTlsHostnameVerification.booleanValue());
            }
            return adminBuilder.build();
        }
        catch (PulsarClientException e) {
            log.error("Error creating pulsar admin client", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static PulsarClient getPulsarClient(String pulsarServiceUrl, String authPlugin, String authParams, Boolean useTls, String tlsTrustCertsFilePath, Boolean allowTlsInsecureConnection, Boolean enableTlsHostnameVerificationEnable) {
        return WorkerUtils.getPulsarClient(pulsarServiceUrl, authPlugin, authParams, useTls, tlsTrustCertsFilePath, allowTlsInsecureConnection, enableTlsHostnameVerificationEnable, null);
    }

    public static PulsarClient getPulsarClient(String pulsarServiceUrl, String authPlugin, String authParams, Boolean useTls, String tlsTrustCertsFilePath, Boolean allowTlsInsecureConnection, Boolean enableTlsHostnameVerificationEnable, WorkerConfig workerConfig) {
        try {
            ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(0L, SizeUnit.BYTES).serviceUrl(pulsarServiceUrl);
            if (workerConfig != null) {
                clientBuilder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)workerConfig.getProperties(), (String)"brokerClient_"));
            }
            if (StringUtils.isNotBlank((CharSequence)authPlugin) && StringUtils.isNotBlank((CharSequence)authParams)) {
                clientBuilder.authentication(authPlugin, authParams);
            }
            if (useTls != null) {
                clientBuilder.enableTls(useTls.booleanValue());
            }
            if (allowTlsInsecureConnection != null) {
                clientBuilder.allowTlsInsecureConnection(allowTlsInsecureConnection.booleanValue());
            }
            if (StringUtils.isNotBlank((CharSequence)tlsTrustCertsFilePath)) {
                clientBuilder.tlsTrustCertsFilePath(tlsTrustCertsFilePath);
            }
            if (enableTlsHostnameVerificationEnable != null) {
                clientBuilder.enableTlsHostnameVerification(enableTlsHostnameVerificationEnable.booleanValue());
            }
            return clientBuilder.build();
        }
        catch (PulsarClientException e) {
            log.error("Error creating pulsar client", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static FunctionInstanceStatsImpl getFunctionInstanceStats(String fullyQualifiedInstanceName, FunctionRuntimeInfo functionRuntimeInfo, int instanceId) {
        Runtime functionRuntime;
        RuntimeSpawner functionRuntimeSpawner = functionRuntimeInfo.getRuntimeSpawner();
        FunctionInstanceStatsImpl functionInstanceStats = new FunctionInstanceStatsImpl();
        if (functionRuntimeSpawner != null && (functionRuntime = functionRuntimeSpawner.getRuntime()) != null) {
            try {
                InstanceCommunication.MetricsData metricsData = (InstanceCommunication.MetricsData)functionRuntime.getMetrics(instanceId).get();
                functionInstanceStats.setInstanceId(instanceId);
                FunctionInstanceStatsDataImpl functionInstanceStatsData = new FunctionInstanceStatsDataImpl();
                functionInstanceStatsData.setReceivedTotal(metricsData.getReceivedTotal());
                functionInstanceStatsData.setProcessedSuccessfullyTotal(metricsData.getProcessedSuccessfullyTotal());
                functionInstanceStatsData.setSystemExceptionsTotal(metricsData.getSystemExceptionsTotal());
                functionInstanceStatsData.setUserExceptionsTotal(metricsData.getUserExceptionsTotal());
                functionInstanceStatsData.setAvgProcessLatency(metricsData.getAvgProcessLatency() == 0.0 ? null : Double.valueOf(metricsData.getAvgProcessLatency()));
                functionInstanceStatsData.setLastInvocation(metricsData.getLastInvocation() == 0L ? null : Long.valueOf(metricsData.getLastInvocation()));
                functionInstanceStatsData.oneMin.setReceivedTotal(metricsData.getReceivedTotal1Min());
                functionInstanceStatsData.oneMin.setProcessedSuccessfullyTotal(metricsData.getProcessedSuccessfullyTotal1Min());
                functionInstanceStatsData.oneMin.setSystemExceptionsTotal(metricsData.getSystemExceptionsTotal1Min());
                functionInstanceStatsData.oneMin.setUserExceptionsTotal(metricsData.getUserExceptionsTotal1Min());
                functionInstanceStatsData.oneMin.setAvgProcessLatency(metricsData.getAvgProcessLatency1Min() == 0.0 ? null : Double.valueOf(metricsData.getAvgProcessLatency1Min()));
                Map<String, Double> statsDataMap = metricsData.getUserMetricsMap().entrySet().stream().filter(stringDoubleEntry -> !((Double)stringDoubleEntry.getValue()).isNaN()).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (Double)x.getValue()));
                functionInstanceStatsData.setUserMetrics(statsDataMap);
                functionInstanceStats.setMetrics((FunctionInstanceStatsData)functionInstanceStatsData);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Failed to collect metrics for function instance {}", (Object)fullyQualifiedInstanceName, (Object)e);
            }
        }
        return functionInstanceStats;
    }

    public static File dumpToTmpFile(InputStream uploadedInputStream) {
        try {
            File tmpFile = FunctionCommon.createPkgTempFile();
            tmpFile.deleteOnExit();
            Files.copy(uploadedInputStream, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return tmpFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create a temporary file", e);
        }
    }

    public static Reader<byte[]> createReader(ReaderBuilder readerBuilder, String readerName, String topic, MessageId startMessageId) throws PulsarClientException {
        return readerBuilder.subscriptionRolePrefix(readerName).readerName(readerName).topic(topic).readCompacted(true).startMessageId(startMessageId).create();
    }

    public static Producer<byte[]> createExclusiveProducerWithRetry(PulsarClient client, String topic, String producerName, Supplier<Boolean> isLeader, int sleepInBetweenMs) throws NotLeaderAnymore {
        try {
            int tries = 0;
            while (true) {
                try {
                    return (Producer)client.newProducer().topic(topic).accessMode(ProducerAccessMode.Exclusive).enableBatching(false).blockIfQueueFull(true).compressionType(CompressionType.LZ4).producerName(producerName).createAsync().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.info("Encountered exception while at creating exclusive producer to topic {}", (Object)topic, (Object)e);
                    if (++tries % 6 == 0 && log.isDebugEnabled()) {
                        log.debug("Failed to acquire exclusive producer to topic {} after {} attempts. Will retry if we are still the leader.", (Object)topic, (Object)tries);
                    }
                    Thread.sleep(sleepInBetweenMs);
                    if (isLeader.get().booleanValue()) continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to create exclusive producer on topic " + topic, e);
        }
        throw new NotLeaderAnymore();
    }

    public static Supplier<Boolean> getIsStillLeaderSupplier(MembershipManager membershipManager, String workerId) {
        return () -> {
            WorkerInfo workerInfo = membershipManager.getLeader();
            return workerInfo != null && workerInfo.getWorkerId().equals(workerId);
        };
    }

    public static class NotLeaderAnymore
    extends Exception {
    }
}

