/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.admin.model.dto;

import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * ProxyApiKeyDTO.
 */
public class ProxyApiKeyDTO implements Serializable {

    private static final long serialVersionUID = -7123456789012345678L;

    /**
     * primary key.
     */
    private String id;

    /**
     * Real upstream API key.
     */
    private String realApiKey;

    /**
     * Proxy API key generated by Shenyu. If empty in create, server will generate
     * one.
     */
    private String proxyApiKey;

    /**
     * Mapping description.
     */
    private String description;

    /**
     * Enabled status.
     */
    private Boolean enabled;

    /**
     * Namespace id.
     */
    @NotBlank
    private String namespaceId;

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getRealApiKey() {
        return realApiKey;
    }

    public void setRealApiKey(final String realApiKey) {
        this.realApiKey = realApiKey;
    }

    public String getProxyApiKey() {
        return proxyApiKey;
    }

    public void setProxyApiKey(final String proxyApiKey) {
        this.proxyApiKey = proxyApiKey;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(final Boolean enabled) {
        this.enabled = enabled;
    }

    public String getNamespaceId() {
        return namespaceId;
    }

    public void setNamespaceId(final String namespaceId) {
        this.namespaceId = namespaceId;
    }
}