/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.admin.model.entity;

/**
 * ProxyApiKeyDO represents the mapping between a proxy API key and a real
 * upstream API key.
 * Table: proxy_api_key_mapping
 */
public final class ProxyApiKeyDO extends BaseDO {

    private static final long serialVersionUID = 326583247188331223L;

    /**
     * Proxy API key generated by Shenyu.
     */
    private String proxyApiKey;

    /**
     * Mapping description.
     */
    private String description;

    /**
     * Enabled status (0: disabled, 1: enabled).
     */
    private Boolean enabled;

    /**
     * Namespace id.
     */
    private String namespaceId;

    /**
     * Selector id which this mapping is bound to.
     */
    private String selectorId;

    public ProxyApiKeyDO() {
    }

    public ProxyApiKeyDO(final String proxyApiKey,
            final String description,
            final Boolean enabled,
            final String namespaceId) {
        this.proxyApiKey = proxyApiKey;
        this.description = description;
        this.enabled = enabled;
        this.namespaceId = namespaceId;
    }

    public String getProxyApiKey() {
        return proxyApiKey;
    }

    public void setProxyApiKey(final String proxyApiKey) {
        this.proxyApiKey = proxyApiKey;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(final Boolean enabled) {
        this.enabled = enabled;
    }

    public String getNamespaceId() {
        return namespaceId;
    }

    public void setNamespaceId(final String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getSelectorId() {
        return selectorId;
    }

    public void setSelectorId(final String selectorId) {
        this.selectorId = selectorId;
    }
}