/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableListBase;
import javafx.concurrent.Worker;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.gui.dataset.FeatureLoader;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Containers;

final class FeatureList
extends ObservableListBase<AbstractFeature> {
    private static final long NUM_PENDING_ROWS = 10L;
    private static final int MAXIMUM_ROWS = 0x7FFFFFFE;
    private static final AbstractFeature[] EMPTY = new AbstractFeature[0];
    private AbstractFeature[] elements = EMPTY;
    private int validCount;
    private int estimatedSize;
    private boolean isSizeExact;
    private FeatureLoader nextPageLoader;

    FeatureList() {
    }

    private List<AbstractFeature> validElements() {
        return Containers.viewAsUnmodifiableList((Object[])this.elements, (int)0, (int)this.validCount);
    }

    public void clear() {
        List<AbstractFeature> removed = this.validElements();
        this.elements = EMPTY;
        this.estimatedSize = 0;
        this.validCount = 0;
        this.beginChange();
        this.nextReplace(0, 0, removed);
        this.endChange();
    }

    final boolean startFeaturesLoading(FeatureTable table, FeatureSet features) {
        assert (Platform.isFxApplicationThread());
        FeatureLoader previous = this.nextPageLoader;
        if (previous != null) {
            this.nextPageLoader = null;
            previous.cancel(false);
        }
        if (features != null) {
            this.nextPageLoader = new FeatureLoader(table, features);
            BackgroundThreads.execute((Runnable)((Object)this.nextPageLoader));
            return true;
        }
        this.clear();
        return false;
    }

    final void setFeatures(long remainingCount, int characteristics, AbstractFeature[] features, int count, boolean hasMore) {
        assert (Platform.isFxApplicationThread());
        int newValidCount = 0;
        for (int i = 0; i < count; ++i) {
            AbstractFeature f = features[i];
            if (f == null) continue;
            features[newValidCount++] = f;
        }
        List<AbstractFeature> removed = this.validElements();
        if (remainingCount == Long.MAX_VALUE) {
            remainingCount = (long)count + 10L;
            characteristics = 0;
        }
        this.estimatedSize = (int)Math.min(0x7FFFFFFEL, Math.addExact(remainingCount, (long)newValidCount));
        this.isSizeExact = (characteristics & 0x40) != 0;
        this.elements = features;
        this.validCount = newValidCount;
        if (hasMore && this.estimatedSize <= newValidCount) {
            this.estimatedSize = (int)Math.min(0x7FFFFFFEL, (long)newValidCount + 10L);
        }
        this.beginChange();
        this.nextReplace(0, this.estimatedSize, removed);
        this.endChange();
        this.checkOverflow();
    }

    final void addFeatures(AbstractFeature[] features, int count, boolean hasMore) {
        assert (Platform.isFxApplicationThread());
        if (count > 0) {
            int newValidCount = Math.addExact(this.validCount, count);
            if (newValidCount > this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, Math.max(newValidCount, this.elements.length << 1));
            }
            newValidCount = this.validCount;
            for (int i = 0; i < count; ++i) {
                AbstractFeature f = features[i];
                if (f == null) continue;
                this.elements[newValidCount++] = f;
            }
            int replaceTo = Math.min(newValidCount, this.estimatedSize);
            List<Object> removed = Collections.nCopies(replaceTo - this.validCount, null);
            if (newValidCount >= this.estimatedSize) {
                this.estimatedSize = newValidCount;
                if (hasMore) {
                    this.estimatedSize = (int)Math.min(0x7FFFFFFEL, (long)newValidCount + 10L);
                }
            }
            this.beginChange();
            this.nextReplace(this.validCount, replaceTo, removed);
            this.validCount = newValidCount;
            this.nextAdd(replaceTo, replaceTo + this.validCount);
            this.endChange();
            this.checkOverflow();
        }
    }

    private void checkOverflow() {
        if (this.validCount >= 0x7FFFFFFE) {
            this.interrupt();
        }
    }

    final void setNextPage(FeatureLoader next) {
        assert (Platform.isFxApplicationThread());
        assert (this.nextPageLoader.isDone());
        this.nextPageLoader = next;
        if (next == null) {
            int n = this.estimatedSize - this.validCount;
            if (n != 0) {
                List<Object> removed = Collections.nCopies(n, null);
                this.estimatedSize = this.validCount;
                this.beginChange();
                this.nextRemove(this.validCount, removed);
                this.endChange();
            }
            this.isSizeExact = true;
            this.elements = (AbstractFeature[])ArraysExt.resize((Object[])this.elements, (int)this.validCount);
        }
    }

    final boolean isCurrentLoader(FeatureLoader loader) {
        return loader == this.nextPageLoader;
    }

    public int size() {
        return this.estimatedSize;
    }

    public AbstractFeature get(int index) {
        assert (Platform.isFxApplicationThread());
        if (index < this.validCount) {
            return this.elements[index];
        }
        if (this.isSizeExact && index >= this.estimatedSize) {
            throw new IndexOutOfBoundsException(index);
        }
        FeatureLoader loader = this.nextPageLoader;
        if (loader != null && loader.getState() == Worker.State.READY) {
            BackgroundThreads.execute((Runnable)((Object)loader));
        }
        return null;
    }

    final void interrupt() {
        assert (Platform.isFxApplicationThread());
        FeatureLoader loader = this.nextPageLoader;
        this.nextPageLoader = null;
        if (loader != null) {
            loader.cancel(false);
            BackgroundThreads.execute(loader::waitAndClose);
        }
    }
}

