/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Duration;
import org.apache.skywalking.library.elasticsearch.requests.search.Scroll;

public final class ScrollBuilder {
    private Duration contextRetention;
    private String scrollId;

    public ScrollBuilder contextRetention(Duration contextRetention) {
        Preconditions.checkArgument((contextRetention != null && !contextRetention.isNegative() && !contextRetention.isZero() ? 1 : 0) != 0, (String)"contextRetention must be positive, but was %s", (Object)contextRetention);
        this.contextRetention = contextRetention;
        return this;
    }

    public ScrollBuilder scrollId(String scrollId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scrollId) ? 1 : 0) != 0, (Object)"scrollId cannot be blank");
        this.scrollId = scrollId;
        return this;
    }

    public Scroll build() {
        Preconditions.checkState((this.contextRetention != null ? 1 : 0) != 0, (Object)"contextRetention is not set");
        Preconditions.checkState((this.scrollId != null ? 1 : 0) != 0, (Object)"scrollId is not set");
        return new Scroll(this.contextRetention.getSeconds() + "s", this.scrollId);
    }
}

