/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.linecorp.armeria.common.JacksonObjectMapperProvider;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DefaultJacksonObjectMapperProvider implements JacksonObjectMapperProvider
{
    INSTANCE;

    private static final Logger logger;
    private static boolean noticed;

    @Override
    public ObjectMapper newObjectMapper() {
        JsonMapper.Builder jsonMapperBuilder = JsonMapper.builder();
        jsonMapperBuilder.findAndAddModules();
        ObjectMapper mapper = jsonMapperBuilder.build();
        Set registeredModuleIds = mapper.getRegisteredModuleIds();
        if (registeredModuleIds.contains("com.fasterxml.jackson.module.scala.DefaultScalaModule")) {
            mapper.enable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES);
        }
        if (!noticed) {
            if (!registeredModuleIds.isEmpty()) {
                logger.debug("Available Jackson Modules: {}", (Object)registeredModuleIds);
            }
            noticed = true;
        }
        return mapper;
    }

    static {
        logger = LoggerFactory.getLogger(DefaultJacksonObjectMapperProvider.class);
    }
}

