/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.CacheControlBuilder;
import com.linecorp.armeria.common.ClientCacheControl;
import com.linecorp.armeria.common.annotation.Nullable;
import java.time.Duration;

public final class ClientCacheControlBuilder
extends CacheControlBuilder {
    private boolean onlyIfCached;
    private long maxStaleSeconds = -1L;
    private long minFreshSeconds = -1L;
    private long staleWhileRevalidateSeconds = -1L;
    private long staleIfErrorSeconds = -1L;

    ClientCacheControlBuilder() {
    }

    ClientCacheControlBuilder(ClientCacheControl c) {
        super(c);
        this.onlyIfCached = c.onlyIfCached();
        this.maxStaleSeconds = c.maxStaleSeconds;
        this.minFreshSeconds = c.minFreshSeconds();
        this.staleWhileRevalidateSeconds = c.staleWhileRevalidateSeconds();
        this.staleIfErrorSeconds = c.staleIfErrorSeconds();
    }

    public ClientCacheControlBuilder onlyIfCached() {
        return this.onlyIfCached(true);
    }

    public ClientCacheControlBuilder onlyIfCached(boolean onlyIfCached) {
        this.onlyIfCached = onlyIfCached;
        return this;
    }

    public ClientCacheControlBuilder maxStale() {
        return this.maxStale(true);
    }

    public ClientCacheControlBuilder maxStale(boolean maxStale) {
        this.maxStaleSeconds = maxStale ? -2L : -1L;
        return this;
    }

    public ClientCacheControlBuilder maxStale(@Nullable Duration maxStale) {
        this.maxStaleSeconds = ClientCacheControlBuilder.validateDuration(maxStale, "maxStale");
        return this;
    }

    public ClientCacheControlBuilder maxStaleSeconds(long maxStaleSeconds) {
        this.maxStaleSeconds = ClientCacheControlBuilder.validateSeconds(maxStaleSeconds, "maxStaleSeconds");
        return this;
    }

    public ClientCacheControlBuilder minFresh(@Nullable Duration minFresh) {
        this.minFreshSeconds = ClientCacheControlBuilder.validateDuration(minFresh, "minFresh");
        return this;
    }

    public ClientCacheControlBuilder minFreshSeconds(long minFreshSeconds) {
        this.minFreshSeconds = ClientCacheControlBuilder.validateSeconds(minFreshSeconds, "minFreshSeconds");
        return this;
    }

    public ClientCacheControlBuilder staleWhileRevalidate(@Nullable Duration staleWhileRevalidate) {
        this.staleWhileRevalidateSeconds = ClientCacheControlBuilder.validateDuration(staleWhileRevalidate, "staleWhileRevalidate");
        return this;
    }

    public ClientCacheControlBuilder staleWhileRevalidateSeconds(long staleWhileRevalidateSeconds) {
        this.staleWhileRevalidateSeconds = ClientCacheControlBuilder.validateSeconds(staleWhileRevalidateSeconds, "staleWhileRevalidateSeconds");
        return this;
    }

    public ClientCacheControlBuilder staleIfError(@Nullable Duration staleIfError) {
        this.staleIfErrorSeconds = ClientCacheControlBuilder.validateDuration(staleIfError, "staleIfError");
        return this;
    }

    public ClientCacheControlBuilder staleIfErrorSeconds(long staleIfErrorSeconds) {
        this.staleIfErrorSeconds = ClientCacheControlBuilder.validateSeconds(staleIfErrorSeconds, "staleIfErrorSeconds");
        return this;
    }

    @Override
    public ClientCacheControl build() {
        return (ClientCacheControl)super.build();
    }

    @Override
    ClientCacheControl build(boolean noCache, boolean noStore, boolean noTransform, long maxAgeSeconds) {
        return new ClientCacheControl(noCache, noStore, noTransform, maxAgeSeconds, this.onlyIfCached, this.maxStaleSeconds, this.minFreshSeconds, this.staleWhileRevalidateSeconds, this.staleIfErrorSeconds);
    }

    @Override
    public ClientCacheControlBuilder noCache() {
        return (ClientCacheControlBuilder)super.noCache();
    }

    @Override
    public ClientCacheControlBuilder noCache(boolean noCache) {
        return (ClientCacheControlBuilder)super.noCache(noCache);
    }

    @Override
    public ClientCacheControlBuilder noStore() {
        return (ClientCacheControlBuilder)super.noStore();
    }

    @Override
    public ClientCacheControlBuilder noStore(boolean noStore) {
        return (ClientCacheControlBuilder)super.noStore(noStore);
    }

    @Override
    public ClientCacheControlBuilder noTransform() {
        return (ClientCacheControlBuilder)super.noTransform();
    }

    @Override
    public ClientCacheControlBuilder noTransform(boolean noTransform) {
        return (ClientCacheControlBuilder)super.noTransform(noTransform);
    }

    @Override
    public ClientCacheControlBuilder maxAge(@Nullable Duration maxAge) {
        return (ClientCacheControlBuilder)super.maxAge(maxAge);
    }

    @Override
    public ClientCacheControlBuilder maxAgeSeconds(long maxAgeSeconds) {
        return (ClientCacheControlBuilder)super.maxAgeSeconds(maxAgeSeconds);
    }
}

