/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.log;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.record.LongText;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

public abstract class AbstractLogRecord
extends Record {
    public static final String ADDITIONAL_TAG_TABLE = "log_tag";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String TRACE_ID = "trace_id";
    public static final String TRACE_SEGMENT_ID = "trace_segment_id";
    public static final String SPAN_ID = "span_id";
    public static final String CONTENT_TYPE = "content_type";
    public static final String CONTENT = "content";
    public static final String TAGS_RAW_DATA = "tags_raw_data";
    public static final String TIMESTAMP = "timestamp";
    public static final String TAGS = "tags";
    @Column(name="service_id")
    @BanyanDB.SeriesID(index=0)
    @SQLDatabase.AdditionalEntity(additionalTables={"log_tag"}, reserveOriginalColumns=true)
    private String serviceId;
    @Column(name="service_instance_id", length=512)
    @BanyanDB.SeriesID(index=1)
    private String serviceInstanceId;
    @Column(name="endpoint_id", length=512)
    private String endpointId;
    @Column(name="trace_id", length=150)
    @BanyanDB.IndexRule(indexType=BanyanDB.IndexRule.IndexType.SKIPPING)
    private String traceId;
    @Column(name="trace_segment_id", length=150)
    private String traceSegmentId;
    @Column(name="span_id")
    @BanyanDB.NoIndexing
    private int spanId;
    @Column(name="content_type", storageOnly=true)
    private int contentType = ContentType.NONE.value();
    @Column(name="content", length=1000000)
    @ElasticSearch.MatchQuery(analyzer=ElasticSearch.MatchQuery.AnalyzerType.OAP_LOG_ANALYZER)
    private LongText content;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;
    @Column(name="tags_raw_data", storageOnly=true)
    private byte[] tagsRawData;
    @Column(name="tags", indexOnly=true, length=256)
    @SQLDatabase.AdditionalEntity(additionalTables={"log_tag"})
    private List<String> tagsInString;

    @Override
    public StorageID id() {
        throw new UnexpectedException("AbstractLogRecord doesn't provide id()");
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Generated
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Generated
    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    @Generated
    public String getEndpointId() {
        return this.endpointId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setTraceSegmentId(String traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public void setSpanId(int spanId) {
        this.spanId = spanId;
    }

    @Generated
    public int getSpanId() {
        return this.spanId;
    }

    @Generated
    public void setContentType(int contentType) {
        this.contentType = contentType;
    }

    @Generated
    public int getContentType() {
        return this.contentType;
    }

    @Generated
    public void setContent(LongText content) {
        this.content = content;
    }

    @Generated
    public LongText getContent() {
        return this.content;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTagsRawData(byte[] tagsRawData) {
        this.tagsRawData = tagsRawData;
    }

    @Generated
    public byte[] getTagsRawData() {
        return this.tagsRawData;
    }

    @Generated
    public void setTagsInString(List<String> tagsInString) {
        this.tagsInString = tagsInString;
    }

    @Generated
    public List<String> getTagsInString() {
        return this.tagsInString;
    }

    public static abstract class Builder<T extends AbstractLogRecord>
    implements StorageBuilder<T> {
        protected void map2Data(T record, Convert2Entity converter) {
            ((AbstractLogRecord)record).setServiceId((String)converter.get(AbstractLogRecord.SERVICE_ID));
            ((AbstractLogRecord)record).setServiceInstanceId((String)converter.get(AbstractLogRecord.SERVICE_INSTANCE_ID));
            ((AbstractLogRecord)record).setEndpointId((String)converter.get(AbstractLogRecord.ENDPOINT_ID));
            ((AbstractLogRecord)record).setTraceId((String)converter.get(AbstractLogRecord.TRACE_ID));
            ((AbstractLogRecord)record).setTraceSegmentId((String)converter.get(AbstractLogRecord.TRACE_SEGMENT_ID));
            ((AbstractLogRecord)record).setSpanId(((Number)converter.get(AbstractLogRecord.SPAN_ID)).intValue());
            ((AbstractLogRecord)record).setContentType(((Number)converter.get(AbstractLogRecord.CONTENT_TYPE)).intValue());
            ((AbstractLogRecord)record).setContent(new LongText((String)converter.get(AbstractLogRecord.CONTENT)));
            ((AbstractLogRecord)record).setTimestamp(((Number)converter.get(AbstractLogRecord.TIMESTAMP)).longValue());
            ((AbstractLogRecord)record).setTagsRawData(converter.getBytes(AbstractLogRecord.TAGS_RAW_DATA));
            ((Record)record).setTimeBucket(((Number)converter.get("time_bucket")).longValue());
        }

        protected void data2Map(T record, Convert2Storage converter) {
            converter.accept(AbstractLogRecord.SERVICE_ID, ((AbstractLogRecord)record).getServiceId());
            converter.accept(AbstractLogRecord.SERVICE_INSTANCE_ID, ((AbstractLogRecord)record).getServiceInstanceId());
            converter.accept(AbstractLogRecord.ENDPOINT_ID, ((AbstractLogRecord)record).getEndpointId());
            converter.accept(AbstractLogRecord.TRACE_ID, ((AbstractLogRecord)record).getTraceId());
            converter.accept(AbstractLogRecord.TRACE_SEGMENT_ID, ((AbstractLogRecord)record).getTraceSegmentId());
            converter.accept(AbstractLogRecord.SPAN_ID, ((AbstractLogRecord)record).getSpanId());
            converter.accept("time_bucket", ((Record)record).getTimeBucket());
            converter.accept(AbstractLogRecord.CONTENT_TYPE, ((AbstractLogRecord)record).getContentType());
            converter.accept(AbstractLogRecord.CONTENT, ((AbstractLogRecord)record).getContent());
            converter.accept(AbstractLogRecord.TIMESTAMP, ((AbstractLogRecord)record).getTimestamp());
            converter.accept(AbstractLogRecord.TAGS_RAW_DATA, ((AbstractLogRecord)record).getTagsRawData());
            converter.accept(AbstractLogRecord.TAGS, ((AbstractLogRecord)record).getTagsInString());
        }
    }
}

