/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.MBeanAwareTimeoutTransformer;

class JavaNetTimeoutTransformer
extends MBeanAwareTimeoutTransformer {
    static final Set<String> CLASSES_TO_TRANSFORM = new HashSet<String>();
    private final long readTimeoutMillis;
    private final long connectTimeoutMillis;

    public JavaNetTimeoutTransformer(long connectTimeout, long readTimeout, AgentInfo agentInfo) {
        super(agentInfo, CLASSES_TO_TRANSFORM);
        this.connectTimeoutMillis = connectTimeout;
        this.readTimeoutMillis = readTimeout;
    }

    @Override
    protected byte[] doTransformClass(CtClass cc) throws Exception {
        CtMethod connectMethod = cc.getDeclaredMethod("connect");
        connectMethod.insertBefore("if ( getConnectTimeout() == 0 ) { setConnectTimeout(" + this.connectTimeoutMillis + "); }");
        connectMethod.insertBefore("if ( getReadTimeout() == 0 ) { setReadTimeout(" + this.readTimeoutMillis + "); }");
        byte[] classfileBuffer = connectMethod.getDeclaringClass().toBytecode();
        connectMethod.getDeclaringClass().detach();
        return classfileBuffer;
    }

    static {
        CLASSES_TO_TRANSFORM.add(Descriptor.toJvmName("sun.net.www.protocol.http.HttpURLConnection"));
        CLASSES_TO_TRANSFORM.add(Descriptor.toJvmName("sun.net.www.protocol.https.AbstractDelegateHttpsURLConnection"));
    }
}

