/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ImportArtifact;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileOutput;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsTransaction;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.impl.AggregateBuilder;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.DirectoryArtifact;
import org.apache.jackrabbit.vault.fs.impl.VaultFileOutputImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAnalyzer;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.impl.io.InputSourceArtifact;
import org.apache.jackrabbit.vault.fs.io.AutoSave;
import org.apache.jackrabbit.vault.fs.io.DocViewAnalyzerListener;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.util.PathComparator;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements VaultFsTransaction {
    private static final Logger log = LoggerFactory.getLogger(TransactionImpl.class);
    private final VaultFileSystem fs;
    private final List<Change> changes = new LinkedList<Change>();
    private final Map<String, DotXmlInfo> dotXmlNodes = new HashMap<String, DotXmlInfo>();
    private boolean verbose;
    private final AutoSave autoSave = new AutoSave();

    public TransactionImpl(VaultFileSystem fs) {
        this.fs = fs;
    }

    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void delete(VaultFile file) throws IOException {
        if (file != null) {
            this.changes.add(new Change(VaultFsTransaction.Type.DELETED, file, null));
        }
    }

    @Override
    public void modify(VaultFile file, VaultInputSource input) throws IOException {
        final Change change = new Change(VaultFsTransaction.Type.MODIFIED, file, input);
        this.changes.add(change);
        if (file.getName().equals(".content.xml")) {
            String repoParentPath = file.getAggregate().getPath();
            DocViewAnalyzer.analyze(new DocViewAnalyzerListener(){

                @Override
                public void onNode(String path, boolean intermediate, String nodeType) {
                    if (!intermediate) {
                        TransactionImpl.this.dotXmlNodes.put(path, new DotXmlInfo(change, nodeType == null));
                    }
                }
            }, this.fs.getAggregateManager().getSession(), repoParentPath, input);
        }
    }

    @Override
    public VaultFileOutput add(String path, VaultInputSource input) throws IOException, RepositoryException {
        String repoPath = PlatformNameFormat.getRepositoryPath(path, true);
        String repoName = Text.getName(repoPath);
        String parentPath = Text.getRelativeParent(path, 1);
        String repoParentPath = Text.getRelativeParent(repoPath, 1);
        if (repoName.equals(".content.xml")) {
            final Change change = new Change(VaultFsTransaction.Type.ADDED_X, repoParentPath, path, input);
            this.changes.add(change);
            DocViewAnalyzer.analyze(new DocViewAnalyzerListener(){

                @Override
                public void onNode(String path, boolean intermediate, String nodeType) {
                    if (!intermediate) {
                        TransactionImpl.this.dotXmlNodes.put(path, new DotXmlInfo(change, nodeType == null));
                    }
                }
            }, this.fs.getAggregateManager().getSession(), repoParentPath, input);
            String parentExt = parentPath.endsWith(".dir") ? ".dir" : "";
            DirectoryArtifact parent = new DirectoryArtifact(Text.getName(repoParentPath), parentExt);
            InputSourceArtifact isa = new InputSourceArtifact(parent, ".content.xml", "", ArtifactType.PRIMARY, input, SerializationType.XML_DOCVIEW);
            isa.setContentType("text/xml");
            change.isa = isa;
            return new VaultFileOutputImpl(change);
        }
        SerializationType serType = SerializationType.GENERIC;
        ArtifactType aType = ArtifactType.FILE;
        String extension = "";
        int idx = repoName.lastIndexOf(46);
        if (idx > 0) {
            String base = repoName.substring(0, idx);
            String ext = repoName.substring(idx);
            if (ext.equals(".xml")) {
                if (DocViewParser.isDocView(input)) {
                    aType = ArtifactType.PRIMARY;
                    repoName = base;
                    extension = ext;
                    serType = SerializationType.XML_DOCVIEW;
                } else {
                    serType = SerializationType.GENERIC;
                }
            } else if (ext.equals(".binary")) {
                aType = ArtifactType.BINARY;
                repoName = base;
                extension = ext;
            }
        }
        InputSourceArtifact isa = new InputSourceArtifact(null, repoName, extension, aType, input, serType);
        Change change = new Change(VaultFsTransaction.Type.ADDED, repoParentPath + "/" + repoName, path, input);
        change.isa = isa;
        this.changes.add(change);
        return new VaultFileOutputImpl(change);
    }

    @Override
    public void mkdir(String path) throws IOException, RepositoryException {
        this.changes.add(new Change(VaultFsTransaction.Type.MKDIR, PlatformNameFormat.getRepositoryPath(path), path, null));
    }

    @Override
    public Collection<VaultFsTransaction.Info> commit() throws RepositoryException, IOException {
        HashMap<String, VaultFsTransaction.Info> infos = new HashMap<String, VaultFsTransaction.Info>();
        ImportInfoImpl allInfos = new ImportInfoImpl();
        if (!this.dotXmlNodes.isEmpty()) {
            Iterator<Change> iter = this.changes.iterator();
            while (iter.hasNext()) {
                DotXmlInfo dxi;
                Change c = iter.next();
                if (c.type == VaultFsTransaction.Type.ADDED) {
                    if (c.isa.getType() != ArtifactType.BINARY || (dxi = this.dotXmlNodes.get(c.repoPath)) == null) continue;
                    dxi.change.add(c);
                    iter.remove();
                    continue;
                }
                if (c.type != VaultFsTransaction.Type.MKDIR || (dxi = this.dotXmlNodes.get(c.repoPath)) == null) continue;
                iter.remove();
            }
        }
        TreeMap<String, TxInfo> modified = new TreeMap<String, TxInfo>(new PathComparator());
        boolean ignoreMP = true;
        while (!this.changes.isEmpty()) {
            int size = this.changes.size();
            Iterator<Change> iter = this.changes.iterator();
            while (iter.hasNext()) {
                Change change = iter.next();
                if (!this.processChange(change, modified, ignoreMP)) continue;
                this.changes.remove(change);
                iter = this.changes.iterator();
            }
            if (this.changes.size() == size) {
                if (ignoreMP) {
                    ignoreMP = false;
                } else {
                    for (Change c : this.changes) {
                        infos.put(c.filePath, new VaultFsTransaction.Info(VaultFsTransaction.Type.ERROR, c.filePath));
                    }
                    this.changes.clear();
                }
            } else {
                for (TxInfo info : modified.values()) {
                    if (info.out == null && info.aggregate == null) {
                        for (String path : info.original.keySet()) {
                            infos.put(path, new VaultFsTransaction.Info(VaultFsTransaction.Type.DELETED, path));
                            if (!this.verbose) continue;
                            log.info("...comitting  DEL {}", (Object)path);
                        }
                        continue;
                    }
                    if (info.out.getArtifacts().isEmpty() && info.aggregate != null) {
                        if (info.aggregate.isAttached()) {
                            info.aggregate.remove(false);
                        }
                        for (String path : info.original.keySet()) {
                            infos.put(path, new VaultFsTransaction.Info(VaultFsTransaction.Type.DELETED, path));
                            if (!this.verbose) continue;
                            log.info("...comitting  DEL {}", (Object)path);
                        }
                        String cXmlPath = info.parentFile.getPath();
                        cXmlPath = cXmlPath.endsWith("/") ? cXmlPath + ".content.xml" : cXmlPath + "/.content.xml";
                        VaultFsTransaction.Info i = (VaultFsTransaction.Info)infos.get(cXmlPath);
                        if (i != null) continue;
                        infos.put(cXmlPath, new VaultFsTransaction.Info(VaultFsTransaction.Type.MODIFIED, cXmlPath));
                        continue;
                    }
                    if (info.aggregate == null) {
                        String parentPath = info.parentFile.getPath();
                        if (!parentPath.endsWith("/")) {
                            parentPath = parentPath + "/";
                        }
                        for (Artifact artifact : info.out.getArtifacts().values()) {
                            if (!(artifact instanceof ImportArtifact)) continue;
                            String path = parentPath + artifact.getPlatformPath();
                            infos.put(path, new VaultFsTransaction.Info(VaultFsTransaction.Type.ADDED, path));
                        }
                        ImportInfo ret = info.out.close();
                        if (ret != null) {
                            allInfos.merge(ret);
                            if (this.verbose) {
                                for (Map.Entry<String, ImportInfo.Type> e : ret.getModifications().entrySet()) {
                                    log.info("...committing  {} {}", (Object)e.getValue(), (Object)e.getKey());
                                }
                            }
                        }
                        infos.put(info.parentFile.getPath(), new VaultFsTransaction.Info(VaultFsTransaction.Type.MODIFIED, info.parentFile.getPath()));
                        continue;
                    }
                    ImportInfo ret = info.out.close();
                    if (ret != null) {
                        allInfos.merge(ret);
                    }
                    for (VaultFile vaultFile : info.original.values()) {
                        infos.put(vaultFile.getPath(), new VaultFsTransaction.Info(VaultFsTransaction.Type.MODIFIED, vaultFile.getPath()));
                        if (!this.verbose) continue;
                        log.info("...comitting  UPD {}", (Object)vaultFile.getPath());
                    }
                    if (!this.verbose || ret == null) continue;
                    for (Map.Entry entry : ret.getModifications().entrySet()) {
                        log.info("...committing  {} {}", entry.getValue(), entry.getKey());
                    }
                }
            }
            modified.clear();
            this.fs.invalidate();
        }
        if (this.verbose) {
            log.info("Persisting changes...");
        }
        if (allInfos.numErrors() > 0) {
            try {
                this.fs.getAggregateManager().getSession().refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            throw new RepositoryException("There were errors during commit. Aborting transaction.");
        }
        this.fs.getAggregateManager().getSession().save();
        allInfos.checkinNodes(this.fs.getAggregateManager().getSession());
        this.fs.invalidate();
        return infos.values();
    }

    /*
     * WARNING - void declaration
     */
    private boolean processChange(Change change, Map<String, TxInfo> modified, boolean ignoreMP) throws RepositoryException, IOException {
        switch (change.type) {
            case ADDED_X: {
                TxInfo txInfo;
                String repoPath;
                String parentPath = Text.getRelativeParent(change.filePath, 1);
                VaultFile parent = this.fs.getFile(parentPath);
                if (parent == null) {
                    parentPath = Text.getRelativeParent(parentPath, 1);
                    parent = this.fs.getFile(parentPath);
                    repoPath = change.repoPath;
                    String string = Text.getName(repoPath);
                    if (parent == null) {
                        void var8_22;
                        if (!this.fs.getAggregateManager().getSession().nodeExists(Text.getRelativeParent(repoPath, 1))) {
                            return false;
                        }
                        while ((parent == null || parent.getAggregate() == null) && parentPath.length() > 0) {
                            String parentName = Text.getName(parentPath);
                            if (parentName.endsWith(".dir")) {
                                parentName = parentName.substring(0, parentName.length() - 4);
                            }
                            String string2 = PlatformNameFormat.getRepositoryName(parentName) + "/" + (String)var8_22;
                            parentPath = Text.getRelativeParent(parentPath, 1);
                            parent = this.fs.getFile(parentPath);
                        }
                        if (parent == null || parent.getAggregate() == null) {
                            return false;
                        }
                        String repoRelPath = Text.getName(parentPath) + "/" + (String)var8_22;
                        txInfo = modified.get(parent.getAggregate().getPath());
                        if (txInfo == null) {
                            txInfo = new TxInfo(parent.getAggregate());
                            modified.put(parent.getAggregate().getPath(), txInfo);
                        }
                        txInfo.out.getArtifacts().add(new InputSourceArtifact(null, repoRelPath, change.isa.getExtension(), ArtifactType.FILE, change.isa.getInputSource(), change.isa.getSerializationType()));
                    } else {
                        this.assertInFilter(repoPath);
                        txInfo = modified.get(repoPath);
                        if (txInfo == null) {
                            txInfo = new TxInfo(repoPath, ((AggregateImpl)parent.getAggregate()).create(string));
                            txInfo.parentFile = parent;
                            modified.put(repoPath, txInfo);
                        }
                        txInfo.out.getArtifacts().add(change.isa);
                    }
                } else {
                    repoPath = parent.getAggregate().getPath();
                    this.assertInFilter(repoPath);
                    txInfo = modified.get(repoPath);
                    if (txInfo == null) {
                        txInfo = new TxInfo(parent.getAggregate());
                        txInfo.parentFile = parent;
                        modified.put(repoPath, txInfo);
                    }
                    txInfo.out.getArtifacts().add(change.isa);
                }
                if (txInfo == null) {
                    return false;
                }
                if (change.subChanges != null) {
                    for (Change sc : change.subChanges) {
                        String relPath = PathUtil.getRelativePath(repoPath, sc.repoPath);
                        relPath = Text.getName(repoPath) + "/" + relPath;
                        if (!relPath.equals(sc.isa.getRelativePath())) {
                            sc.isa = new InputSourceArtifact(null, relPath, "", sc.isa.getType(), sc.isa.getInputSource(), sc.isa.getSerializationType());
                        }
                        txInfo.out.getArtifacts().add(sc.isa);
                    }
                }
                if (!this.verbose) break;
                log.info("...scheduling ADD {}/{}", (Object)parent.getPath(), (Object)".content.xml");
                break;
            }
            case ADDED: {
                String parentPath = Text.getRelativeParent(change.filePath, 1);
                VaultFile parent = this.fs.getFile(parentPath);
                String repoName = change.isa.getRelativePath();
                if (parent == null || parent.getAggregate() == null) {
                    if (ignoreMP) {
                        return false;
                    }
                    while ((parent == null || parent.getAggregate() == null) && parentPath.length() > 0) {
                        String parentName = Text.getName(parentPath);
                        if (parentName.endsWith(".dir")) {
                            parentName = parentName.substring(0, parentName.length() - 4);
                        }
                        repoName = PlatformNameFormat.getRepositoryName(parentName) + "/" + repoName;
                        parentPath = Text.getRelativeParent(parentPath, 1);
                        parent = this.fs.getFile(parentPath);
                    }
                    if (parent == null) {
                        return false;
                    }
                    String repoPath = parent.getAggregate().getPath();
                    String string = Text.getName(repoPath) + "/" + repoName;
                    if (!repoPath.endsWith("/")) {
                        repoPath = repoPath + "/";
                    }
                    repoPath = repoPath + repoName;
                    this.assertInFilter(repoPath);
                    TxInfo txInfo = modified.get(parent.getAggregate().getPath());
                    if (txInfo == null) {
                        txInfo = new TxInfo(parent.getAggregate());
                        modified.put(parent.getAggregate().getPath(), txInfo);
                    }
                    txInfo.out.getArtifacts().add(new InputSourceArtifact(null, string, change.isa.getExtension(), ArtifactType.FILE, change.isa.getInputSource(), change.isa.getSerializationType()));
                } else {
                    void var8_28;
                    String repoPath = parent.getAggregate().getPath();
                    if (!repoPath.endsWith("/")) {
                        repoPath = repoPath + "/";
                    }
                    repoPath = repoPath + repoName;
                    this.assertInFilter(repoPath);
                    TxInfo txInfo = modified.get(repoPath);
                    if (txInfo == null) {
                        TxInfo txInfo2 = new TxInfo(repoPath, ((AggregateImpl)parent.getAggregate()).create(repoName));
                        txInfo2.setParentFile(parent);
                        modified.put(repoPath, txInfo2);
                    }
                    ((TxInfo)var8_28).out.getArtifacts().add(change.isa);
                }
                if (!this.verbose) break;
                log.info("...scheduling ADD {}/{}", (Object)parent.getPath(), (Object)repoName);
                break;
            }
            case MKDIR: {
                String repoPath;
                String parentPath = Text.getRelativeParent(change.filePath, 1);
                String name = Text.getName(change.filePath);
                VaultFile parent = this.fs.getFile(parentPath);
                if (parent == null || parent.isTransient()) {
                    return false;
                }
                String repoName = PlatformNameFormat.getRepositoryName(name);
                int n = repoName.lastIndexOf(46);
                if (n > 0) {
                    String base = repoName.substring(0, n);
                    String ext = repoName.substring(n);
                    if (ext.equals(".dir")) {
                        repoName = base;
                    }
                }
                if (!(repoPath = parent.getAggregate().getPath()).endsWith("/")) {
                    repoPath = repoPath + "/";
                }
                repoPath = repoPath + repoName;
                this.assertInFilter(repoPath);
                TxInfo txInfo = modified.get(repoPath);
                if (txInfo == null) {
                    txInfo = new TxInfo(repoPath, ((AggregateImpl)parent.getAggregate()).create(repoName));
                    txInfo.setParentFile(parent);
                    modified.put(repoPath, txInfo);
                }
                txInfo.out.addArtifact(new DirectoryArtifact(repoName));
                if (!this.verbose) break;
                log.info("...scheduling MKD {}/{}", (Object)parent.getPath(), (Object)repoName);
                break;
            }
            case DELETED: {
                Aggregate an = change.file.getAggregate();
                if (an == null) {
                    this.assertInFilter(change.repoPath);
                    TxInfo txInfo = new TxInfo(change.repoPath, null);
                    txInfo.original.put(change.file.getPath(), change.file);
                    modified.put(txInfo.artifactsPath, txInfo);
                    break;
                }
                this.assertInFilter(an.getPath());
                TxInfo txInfo = modified.get(an.getPath());
                if (txInfo == null) {
                    txInfo = new TxInfo(an);
                    VaultFile dir = null;
                    for (VaultFile vaultFile : change.file.getRelated()) {
                        txInfo.original.put(vaultFile.getPath(), vaultFile);
                        if (!vaultFile.isDirectory()) continue;
                        dir = vaultFile;
                    }
                    modified.put(txInfo.artifactsPath, txInfo);
                    if (dir == null) {
                        txInfo.parentFile = change.file.getParent();
                    } else {
                        txInfo.parentFile = dir.getParent();
                    }
                }
                txInfo.out.getArtifacts().remove(change.file.getArtifact());
                if (!this.verbose) break;
                log.info("...scheduling DEL {}", (Object)an.getPath());
                break;
            }
            case MODIFIED: {
                Aggregate an = change.file.getAggregate();
                TxInfo txInfo = modified.get(an.getPath());
                if (txInfo == null) {
                    txInfo = new TxInfo(an);
                    VaultFile dir = null;
                    for (VaultFile vaultFile : change.file.getRelated()) {
                        txInfo.original.put(vaultFile.getPath(), vaultFile);
                        if (!vaultFile.isDirectory()) continue;
                        dir = vaultFile;
                    }
                    modified.put(txInfo.artifactsPath, txInfo);
                    if (dir == null) {
                        txInfo.parentFile = change.file.getParent();
                    } else {
                        txInfo.parentFile = dir.getParent();
                    }
                }
                InputSourceArtifact isa = new InputSourceArtifact(change.file.getArtifact(), change.input);
                txInfo.out.getArtifacts().put(isa);
                if (change.subChanges != null) {
                    for (Change change2 : change.subChanges) {
                        String relPath = PathUtil.getRelativePath(change.repoPath, change2.repoPath);
                        relPath = Text.getName(change.repoPath) + "/" + relPath;
                        if (!relPath.equals(change2.isa.getRelativePath())) {
                            change2.isa = new InputSourceArtifact(null, relPath, change2.isa.getExtension(), change2.isa.getType(), change2.isa.getInputSource(), change2.isa.getSerializationType());
                        }
                        txInfo.out.getArtifacts().add(change2.isa);
                    }
                }
                if (!this.verbose) break;
                log.info("...scheduling UPD {}/{}", (Object)isa.getRelativePath());
                break;
            }
        }
        return true;
    }

    private void assertInFilter(String repoPath) {
        if (!this.fs.getWorkspaceFilter().contains(repoPath)) {
            log.warn("{} is excluded by the workspace filter. continuing with unknown results.", (Object)repoPath);
        }
    }

    private static class TxInfo {
        private final AggregateImpl aggregate;
        private final String artifactsPath;
        private final AggregateBuilder out;
        private final Map<String, VaultFile> original = new HashMap<String, VaultFile>();
        private VaultFile parentFile;

        public TxInfo(Aggregate a) throws RepositoryException {
            this.aggregate = (AggregateImpl)a;
            this.artifactsPath = a.getPath();
            this.out = this.aggregate.getBuilder();
        }

        public TxInfo(String artifactsPath, AggregateBuilder out) {
            this.aggregate = null;
            this.artifactsPath = artifactsPath;
            this.out = out;
        }

        public void setParentFile(VaultFile parentFile) {
            this.parentFile = parentFile;
        }
    }

    private static class DotXmlInfo {
        private final Change change;
        private final boolean intermediate;

        private DotXmlInfo(Change change, boolean intermediate) {
            this.change = change;
            this.intermediate = intermediate;
        }
    }

    protected static class Change {
        private final VaultFsTransaction.Type type;
        private VaultFile file;
        private VaultInputSource input;
        private String filePath;
        private String repoPath;
        private InputSourceArtifact isa;
        private LinkedList<Change> subChanges;

        public Change(VaultFsTransaction.Type type, VaultFile file, VaultInputSource input) {
            this.type = type;
            this.file = file;
            this.repoPath = file.getAggregatePath();
            String relPath = file.getRepoRelPath();
            if (relPath != null && relPath.length() > 0) {
                this.repoPath = this.repoPath + "/" + relPath;
            }
            this.input = input;
        }

        public Change(VaultFsTransaction.Type type, String repoPath, String filePath, VaultInputSource input) {
            this.type = type;
            this.repoPath = repoPath;
            this.input = input;
            this.filePath = filePath;
        }

        public void setInputSource(VaultInputSource input) {
            this.input = input;
        }

        public void setContentType(String contentType) {
            if (this.isa != null) {
                this.isa.setContentType(contentType);
            }
        }

        public void add(Change c) {
            if (this.subChanges == null) {
                this.subChanges = new LinkedList();
            }
            this.subChanges.add(c);
        }
    }
}

