/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.registry.PackageTaskOptions;
import org.apache.jackrabbit.vault.packaging.registry.taskoption.ImportOptionsPackageTaskOption;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PackageTaskOptionsSerializer {
    private static final String TAG_OPTIONS = "options";
    private static final String ATTR_TYPE = "type";
    private static final String TAG_AC_HANDLING = "acHandling";
    private static final String TAG_IS_STRICT = "isStrict";
    private static final String TAG_AUTO_SAVE_THRESHOLD = "autoSaveThreshold";
    private static final String TAG_DEPENDENCY_HANDLING = "dependencyHandling";
    private static final String TAG_CUG_HANDLING = "cugHandling";
    private static final String TAG_NON_RECURSIVE = "nonRecursive";
    private static final String TAG_DRY_RUN = "dryRun";
    private static final String TAG_IMPORT_MODE = "importMode";
    private static final String TAG_OVERWRITE_PRIMARY_TYPES_OF_FOLDERS = "overwritePrimaryTypesOfFolders";
    private static final String TAG_ID_CONFLICT_POLICY = "idConflictPolicy";

    public PackageTaskOptions load(Element element) {
        ImportOptionsPackageTaskOption options;
        Element childElement = PackageTaskOptionsSerializer.getFirstElementByTagName(TAG_OPTIONS, element);
        if (childElement == null) {
            return null;
        }
        switch (Type.valueOf(childElement.getAttribute(ATTR_TYPE))) {
            case ImportOptions: {
                options = this.loadImportOptions(childElement);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong type used");
            }
        }
        return options;
    }

    public void save(XMLStreamWriter writer, PackageTaskOptions options) throws XMLStreamException {
        if (options == null) {
            return;
        }
        writer.writeStartElement(TAG_OPTIONS);
        Type type = Type.fromClass(options);
        writer.writeAttribute(ATTR_TYPE, type.name());
        switch (type) {
            case ImportOptions: {
                this.saveImportOptions(writer, (ImportOptionsPackageTaskOption)options);
            }
        }
        writer.writeEndElement();
    }

    public void saveImportOptions(XMLStreamWriter writer, ImportOptionsPackageTaskOption options) throws XMLStreamException {
        ImportOptions importOptions = options.getImportOptions();
        this.writeOption(writer, TAG_IS_STRICT, Boolean.class, importOptions.isStrict(false));
        this.writeOption(writer, TAG_AC_HANDLING, AccessControlHandling.class, importOptions.getAccessControlHandling());
        this.writeOption(writer, TAG_CUG_HANDLING, AccessControlHandling.class, importOptions.getCugHandling());
        this.writeOption(writer, TAG_AUTO_SAVE_THRESHOLD, Integer.class, importOptions.getAutoSaveThreshold());
        this.writeOption(writer, TAG_DEPENDENCY_HANDLING, DependencyHandling.class, importOptions.getDependencyHandling());
        this.writeOption(writer, TAG_NON_RECURSIVE, Boolean.class, importOptions.isNonRecursive());
        this.writeOption(writer, TAG_DRY_RUN, Boolean.class, importOptions.isDryRun());
        this.writeOption(writer, TAG_IMPORT_MODE, ImportMode.class, importOptions.getImportMode());
        this.writeOption(writer, TAG_OVERWRITE_PRIMARY_TYPES_OF_FOLDERS, Boolean.class, importOptions.overwritePrimaryTypesOfFolders());
        if (importOptions.hasIdConflictPolicyBeenSet()) {
            this.writeOption(writer, TAG_ID_CONFLICT_POLICY, IdConflictPolicy.class, importOptions.getIdConflictPolicy());
        }
    }

    public ImportOptionsPackageTaskOption loadImportOptions(Element element) {
        ImportOptions options = new ImportOptions();
        this.readOption(element, TAG_IS_STRICT, Boolean.class, options::setStrict);
        this.readOption(element, TAG_AC_HANDLING, AccessControlHandling.class, options::setAccessControlHandling);
        this.readOption(element, TAG_CUG_HANDLING, AccessControlHandling.class, options::setCugHandling);
        this.readOption(element, TAG_AUTO_SAVE_THRESHOLD, Integer.class, options::setAutoSaveThreshold);
        this.readOption(element, TAG_DEPENDENCY_HANDLING, DependencyHandling.class, options::setDependencyHandling);
        this.readOption(element, TAG_NON_RECURSIVE, Boolean.class, options::setNonRecursive);
        this.readOption(element, TAG_DRY_RUN, Boolean.class, options::setDryRun);
        this.readOption(element, TAG_IMPORT_MODE, ImportMode.class, options::setImportMode);
        this.readOption(element, TAG_OVERWRITE_PRIMARY_TYPES_OF_FOLDERS, Boolean.class, options::setOverwritePrimaryTypesOfFolders);
        this.readOption(element, TAG_ID_CONFLICT_POLICY, IdConflictPolicy.class, options::setIdConflictPolicy);
        return new ImportOptionsPackageTaskOption(options);
    }

    private <T> void writeOption(XMLStreamWriter writer, String tagElement, Class<T> type, T value) throws XMLStreamException {
        if (value != null) {
            writer.writeStartElement(tagElement);
            if (type.equals(Boolean.class)) {
                writer.writeCharacters(Boolean.toString((Boolean)value));
            } else if (type.isEnum()) {
                writer.writeCharacters(((Enum)value).name());
            } else if (type.equals(Integer.class)) {
                writer.writeCharacters(Integer.toString((Integer)value));
            }
            writer.writeEndElement();
        }
    }

    private <T> void readOption(Element element, String tagName, Class<T> type, Consumer<T> consumer) {
        Element childElement = PackageTaskOptionsSerializer.getFirstElementByTagName(tagName, element);
        if (childElement != null) {
            if (type.equals(Boolean.class)) {
                consumer.accept(Boolean.valueOf(childElement.getTextContent()));
            } else if (type.isEnum()) {
                consumer.accept((Boolean)Enum.valueOf(type, childElement.getTextContent()));
            } else if (type.equals(Integer.class)) {
                consumer.accept((Boolean)((Object)Integer.valueOf(childElement.getTextContent())));
            }
        }
    }

    private static final Element getFirstElementByTagName(String name, Element element) {
        NodeList nodeList = element.getElementsByTagName(name);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    static enum Type {
        ImportOptions;


        static Type fromClass(PackageTaskOptions options) {
            if (options instanceof ImportOptionsPackageTaskOption) {
                return ImportOptions;
            }
            throw new IllegalStateException("Unsupported task option class " + options.getClass());
        }
    }
}

