/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.actions;

import org.apache.sling.ide.eclipse.ui.internal.SelectionUtils;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class JcrNodeRenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        JcrNode node = SelectionUtils.getFirst(sel, JcrNode.class);
        if (node == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        InputDialog id = new InputDialog(shell, "Change Node Name", "Enter new name for node '" + node.getDescription() + "':", node.getLabel(), (IInputValidator)NodeNameValidator.INSTANCE);
        if (id.open() == 0) {
            node.rename(id.getValue());
        }
        return null;
    }

    static final class NodeNameValidator
    implements IInputValidator {
        static final NodeNameValidator INSTANCE = new NodeNameValidator();

        NodeNameValidator() {
        }

        public String isValid(String newText) {
            if (newText != null && newText.trim().length() > 0 && newText.trim().equals(newText)) {
                return null;
            }
            return "Invalid input";
        }
    }
}

