/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.authorization.restriction.CurrentPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobsPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.ItemNamePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.NodeTypePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrefixPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.SubtreePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AbstractRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RestrictionProvider.class}, property={"oak.security.name=org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl"})
public class RestrictionProviderImpl
extends AbstractRestrictionProvider {
    private static final Logger log = LoggerFactory.getLogger(RestrictionProviderImpl.class);
    private static final Map<String, RestrictionDefinition> DEFINITIONS;

    public RestrictionProviderImpl() {
        super(DEFINITIONS);
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Tree tree) {
        PropertyState ps;
        if (oakPath == null) {
            return RestrictionPattern.EMPTY;
        }
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>(DEFINITIONS.size());
        PropertyState glob = tree.getProperty("rep:glob");
        if (glob != null) {
            patterns.add(GlobPattern.create(oakPath, glob.getValue(Type.STRING)));
        }
        for (String name : new String[]{"rep:ntNames", "rep:itemNames"}) {
            ps = tree.getProperty(name);
            if (ps == null) continue;
            patterns.add(RestrictionProviderImpl.createPattern(oakPath, name, ps.getValue(Type.NAMES)));
        }
        for (String name : new String[]{"rep:prefixes", "rep:current", "rep:globs", "rep:subtrees"}) {
            ps = tree.getProperty(name);
            if (ps == null) continue;
            patterns.add(RestrictionProviderImpl.createPattern(oakPath, name, ps.getValue(Type.STRINGS)));
        }
        return CompositePattern.create(patterns);
    }

    private static RestrictionPattern createPattern(@NotNull String path, @NotNull String name, @NotNull Iterable<String> values) {
        switch (name) {
            case "rep:itemNames": {
                return new ItemNamePattern(values);
            }
            case "rep:ntNames": {
                return new NodeTypePattern(values);
            }
            case "rep:prefixes": {
                return new PrefixPattern(values);
            }
            case "rep:current": {
                return new CurrentPattern(path, values);
            }
            case "rep:globs": {
                return new GlobsPattern(path, values);
            }
            case "rep:subtrees": {
                return new SubtreePattern(path, values);
            }
        }
        log.debug("Ignoring unsupported restriction {} at {}", (Object)name, (Object)path);
        return RestrictionPattern.EMPTY;
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Set<Restriction> restrictions) {
        if (oakPath == null || restrictions.isEmpty()) {
            return RestrictionPattern.EMPTY;
        }
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>(DEFINITIONS.size());
        for (Restriction r : restrictions) {
            String name = r.getDefinition().getName();
            if ("rep:glob".equals(name)) {
                patterns.add(GlobPattern.create(oakPath, r.getProperty().getValue(Type.STRING)));
                continue;
            }
            if ("rep:ntNames".equals(name) || "rep:itemNames".equals(name)) {
                patterns.add(RestrictionProviderImpl.createPattern(oakPath, name, r.getProperty().getValue(Type.NAMES)));
                continue;
            }
            patterns.add(RestrictionProviderImpl.createPattern(oakPath, name, r.getProperty().getValue(Type.STRINGS)));
        }
        return CompositePattern.create(patterns);
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) throws AccessControlException {
        PropertyState globs;
        super.validateRestrictions(oakPath, aceTree);
        Tree restrictionsTree = this.getRestrictionsTree(aceTree);
        PropertyState glob = restrictionsTree.getProperty("rep:glob");
        if (glob != null) {
            GlobPattern.validate(glob.getValue(Type.STRING));
        }
        if ((globs = restrictionsTree.getProperty("rep:globs")) != null) {
            for (String v : globs.getValue(Type.STRINGS)) {
                GlobPattern.validate(v);
            }
        }
    }

    static {
        LinkedHashMap<String, RestrictionDefinitionImpl> tmp = new LinkedHashMap<String, RestrictionDefinitionImpl>();
        tmp.put("rep:glob", new RestrictionDefinitionImpl("rep:glob", Type.STRING, false));
        tmp.put("rep:ntNames", new RestrictionDefinitionImpl("rep:ntNames", Type.NAMES, false));
        tmp.put("rep:prefixes", new RestrictionDefinitionImpl("rep:prefixes", Type.STRINGS, false));
        tmp.put("rep:itemNames", new RestrictionDefinitionImpl("rep:itemNames", Type.NAMES, false));
        tmp.put("rep:current", new RestrictionDefinitionImpl("rep:current", Type.STRINGS, false));
        tmp.put("rep:globs", new RestrictionDefinitionImpl("rep:globs", Type.STRINGS, false));
        tmp.put("rep:subtrees", new RestrictionDefinitionImpl("rep:subtrees", Type.STRINGS, false));
        DEFINITIONS = Collections.unmodifiableMap(tmp);
    }
}

