/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

public final class FragmentMatcher {
    private FragmentMatcher() {
    }

    public static Result startsWith(String pattern, String subject) {
        int i = 0;
        int j = 0;
        char patternChar = '\u0000';
        block8: while (i < pattern.length() && j < subject.length()) {
            patternChar = pattern.charAt(i);
            char subjectChar = subject.charAt(j);
            switch (patternChar) {
                case '*': {
                    if (subjectChar == '/') {
                        ++i;
                        continue block8;
                    }
                    ++j;
                    continue block8;
                }
                case '$': {
                    return Result.MISMATCH;
                }
            }
            if (patternChar != subjectChar) {
                return Result.MISMATCH;
            }
            ++i;
            ++j;
        }
        if (j == subject.length()) {
            block9: while (i < pattern.length()) {
                patternChar = pattern.charAt(i);
                switch (patternChar) {
                    case '*': {
                        ++i;
                        continue block9;
                    }
                    case '$': {
                        ++i;
                        continue block9;
                    }
                }
                return Result.PARTIAL_MATCH;
            }
            return Result.FULL_MATCH;
        }
        return Result.FULL_MATCH;
    }

    public static enum Result {
        FULL_MATCH,
        PARTIAL_MATCH,
        MISMATCH;

    }
}

