% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/WindowSpec.R
\name{rangeBetween}
\alias{rangeBetween}
\alias{rangeBetween,WindowSpec,numeric,numeric-method}
\title{rangeBetween}
\usage{
rangeBetween(x, start, end)

\S4method{rangeBetween}{WindowSpec,numeric,numeric}(x, start, end)
}
\arguments{
\item{x}{a WindowSpec}

\item{start}{boundary start, inclusive.
The frame is unbounded if this is the minimum long value.}

\item{end}{boundary end, inclusive.
The frame is unbounded if this is the maximum long value.}
}
\value{
a WindowSpec
}
\description{
Defines the frame boundaries, from \code{start} (inclusive) to \code{end} (inclusive).
}
\details{
Both \code{start} and \code{end} are relative from the current row. For example, "0" means
"current row", while "-1" means one off before the current row, and "5" means the five off
after the current row.

We recommend users use \code{Window.unboundedPreceding}, \code{Window.unboundedFollowing},
and \code{Window.currentRow} to specify special boundary values, rather than using long values
directly.

A range-based boundary is based on the actual value of the ORDER BY
expression(s). An offset is used to alter the value of the ORDER BY expression,
for instance if the current ORDER BY expression has a value of 10 and the lower bound offset
is -3, the resulting lower bound for the current row will be 10 - 3 = 7. This however puts a
number of constraints on the ORDER BY expressions: there can be only one expression and this
expression must have a numerical data type. An exception can be made when the offset is
unbounded, because no value modification is needed, in this case multiple and non-numeric
ORDER BY expression are allowed.
}
\note{
rangeBetween since 2.0.0
}
\examples{
\dontrun{
  id <- c(rep(1, 3), rep(2, 3), 3)
  desc <- c('New', 'New', 'Good', 'New', 'Good', 'Good', 'New')
  df <- data.frame(id, desc)
  df <- createDataFrame(df)
  w1 <- orderBy(windowPartitionBy('desc'), df$id)
  w2 <- rangeBetween(w1, 0, 3)
  df1 <- withColumn(df, "sum", over(sum(df$id), w2))
  head(df1)
}
}
\seealso{
Other windowspec_method: 
\code{\link{orderBy}()},
\code{\link{partitionBy}()},
\code{\link{rowsBetween}()}
}
\concept{windowspec_method}
