/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.base.OutputLanguage;
import java.io.Serializable;
import java.util.Map;

public class MultiLanguageAttrValue
implements Serializable {
    private final ImmutableMap<OutputLanguage, String> map;
    private final String defaultValue;

    public MultiLanguageAttrValue(Map<OutputLanguage, String> map, String defaultValue) {
        this.map = ImmutableMap.copyOf(map);
        this.defaultValue = defaultValue;
    }

    public MultiLanguageAttrValue(String defaultValue) {
        this(ImmutableMap.of(), Preconditions.checkNotNull(defaultValue));
    }

    public String get(OutputLanguage outputLanguage) {
        return this.map.containsKey((Object)outputLanguage) ? this.map.get((Object)outputLanguage) : this.defaultValue;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public boolean isEmpty() {
        return this.map.isEmpty() && this.defaultValue == null;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof MultiLanguageAttrValue && this.equals((MultiLanguageAttrValue)that);
    }

    public boolean equals(MultiLanguageAttrValue that) {
        return Objects.equal(this.map, that.map) && Objects.equal(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hashCode(this.map, this.defaultValue);
    }
}

