/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Key;
import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.rsa.Rsa;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

public class BeginRsaPrivateKey {
    private BeginRsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.readObject();
            if (sequence.getType() != Asn1Type.SEQUENCE) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser p = sequence.createParser();
            p.readObject();
            Rsa.Private build = Rsa.Private.builder().modulus(p.readObject().asInteger()).publicExponent(p.readObject().asInteger()).privateExponent(p.readObject().asInteger()).primeP(p.readObject().asInteger()).primeQ(p.readObject().asInteger()).primeExponentP(p.readObject().asInteger()).primeExponentQ(p.readObject().asInteger()).crtCoefficient(p.readObject().asInteger()).build();
            RSAPrivateCrtKey privateKey = build.toKey();
            RSAPublicKey publicKey = build.toPublic().toKey();
            return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

