/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.DestroyedComponentException;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.httpclient.AbstractHttpClient;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.primitive.TimerSupport;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClientBuilder;
import org.apache.hc.client5.http.impl.cache.FileResourceFactory;
import org.apache.hc.client5.http.impl.cache.ManagedHttpCacheStorage;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.slf4j.Logger;

public class FileCachingHttpClientBuilder
extends HttpClientBuilder {
    @Nonnull
    private File cacheDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "wwwcache");
    private int maxCacheEntries = 100;
    private long maxCacheEntrySize = 0xA00000L;
    @Nonnull
    private Duration maintentanceTaskInterval = Duration.ofMinutes(30L);
    private ManagedHttpCacheStorage managedStorage;

    public FileCachingHttpClientBuilder() {
        this(CachingHttpClientBuilder.create());
    }

    public FileCachingHttpClientBuilder(@Nonnull CachingHttpClientBuilder builder) {
        super((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder);
    }

    public File getCacheDirectory() {
        return this.cacheDir;
    }

    public void setCacheDirectory(@Nonnull @NotEmpty String directoryPath) {
        String trimmedPath = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)directoryPath), (String)"Cache directory path can not be null or empty");
        this.cacheDir = new File(trimmedPath);
    }

    public void setCacheDirectory(@Nonnull File directory) {
        this.cacheDir = (File)Constraint.isNotNull((Object)directory, (String)"Cache directory can not be null");
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxEntries) {
        this.maxCacheEntries = Constraint.isGreaterThan((int)0, (int)maxEntries, (String)"Maximum number of cache entries must be greater than 0");
    }

    public long getMaxCacheEntrySize() {
        return this.maxCacheEntrySize;
    }

    public void setMaxCacheEntrySize(long size) {
        this.maxCacheEntrySize = (int)Constraint.isGreaterThan((long)0L, (long)size, (String)"Maximum cache entry size must be greater than 0");
    }

    @Nonnull
    public Duration getMaintentanceTaskInterval() {
        return this.maintentanceTaskInterval;
    }

    public void setMaintentanceTaskInterval(@Nonnull Duration value) {
        Constraint.isNotNull((Object)value, (String)"Interval cannot be null");
        Constraint.isFalse((value.isNegative() || value.isZero() ? 1 : 0) != 0, (String)"Interval must be positive");
        this.maintentanceTaskInterval = value;
    }

    @Override
    protected void decorateApacheBuilder() throws Exception {
        super.decorateApacheBuilder();
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            throw new IOException("Unable to create cache directory " + this.cacheDir.getAbsolutePath());
        }
        if (!this.cacheDir.canRead()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not readable");
        }
        if (!this.cacheDir.canWrite()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not writable");
        }
        CachingHttpClientBuilder cachingBuilder = (CachingHttpClientBuilder)this.getApacheBuilder();
        CacheConfig.Builder cacheConfigBuilder = CacheConfig.custom();
        cacheConfigBuilder.setMaxCacheEntries(this.maxCacheEntries);
        cacheConfigBuilder.setMaxObjectSize(this.maxCacheEntrySize);
        cacheConfigBuilder.setHeuristicCachingEnabled(false);
        cacheConfigBuilder.setSharedCache(false);
        CacheConfig cacheConfig = cacheConfigBuilder.build();
        cachingBuilder.setCacheConfig(cacheConfig);
        cachingBuilder.setResourceFactory((ResourceFactory)new FileResourceFactory(this.cacheDir));
        this.managedStorage = new ManagedHttpCacheStorage(cacheConfig);
        cachingBuilder.setHttpCacheStorage((HttpCacheStorage)this.managedStorage);
    }

    @Override
    @Nonnull
    public synchronized HttpClient buildClient() throws Exception {
        HttpClient client = super.buildClient();
        ManagedHttpCacheStorage tempStorage = this.managedStorage;
        assert (client != null && tempStorage != null);
        this.managedStorage = null;
        return new StorageManagingHttpClient(client, tempStorage, this.getMaintentanceTaskInterval().toMillis());
    }

    private static class StorageManagingHttpClient
    extends AbstractHttpClient
    implements InitializableComponent,
    DestructableComponent {
        @Nonnull
        private Logger log = LoggerFactory.getLogger(StorageManagingHttpClient.class);
        @NonnullAfterInit
        private HttpClient httpClient;
        @NonnullAfterInit
        private ManagedHttpCacheStorage storage;
        private long maintenanceTaskInterval;
        private boolean initialized;
        private boolean destroyed;
        @NonnullAfterInit
        private Timer timer;
        @NonnullAfterInit
        private TimerTask maintenanceTask;

        public StorageManagingHttpClient(@Nonnull HttpClient wrappedClient, @Nonnull ManagedHttpCacheStorage managedStorage, long taskInterval) {
            this.httpClient = (HttpClient)Constraint.isNotNull((Object)wrappedClient, (String)"HttpClient was null");
            this.storage = (ManagedHttpCacheStorage)Constraint.isNotNull((Object)managedStorage, (String)"ManagedHttpCacheStorage was null");
            this.maintenanceTaskInterval = taskInterval;
        }

        protected final void throwComponentStateExceptions() {
            if (!this.isInitialized()) {
                throw new UninitializedComponentException("StorageManagingHttpClient has not yet been initialized and cannot be used.");
            }
            if (this.isDestroyed()) {
                throw new DestroyedComponentException("StorageManagingHttpClient has already been destroyed and can no longer be used.");
            }
        }

        @Override
        protected ClassicHttpResponse doExecute(@Nullable HttpHost target, @Nonnull ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
            this.throwComponentStateExceptions();
            return this.httpClient.executeOpen(target, request, context);
        }

        public void close() throws IOException {
            this.throwComponentStateExceptions();
            if (Closeable.class.isInstance(this.httpClient)) {
                ((Closeable)Closeable.class.cast(this.httpClient)).close();
            }
        }

        public void close(CloseMode closeMode) {
            this.throwComponentStateExceptions();
            if (ModalCloseable.class.isInstance(this.httpClient)) {
                ((ModalCloseable)ModalCloseable.class.cast(this.httpClient)).close(closeMode);
            }
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        public void initialize() throws ComponentInitializationException {
            this.timer = new Timer(TimerSupport.getTimerName((Object)this), true);
            this.maintenanceTask = new StorageMaintenanceTask(this.storage);
            this.timer.schedule(this.maintenanceTask, this.maintenanceTaskInterval, this.maintenanceTaskInterval);
            this.initialized = true;
        }

        public void destroy() {
            this.maintenanceTask.cancel();
            this.timer.cancel();
            this.maintenanceTask = null;
            this.timer = null;
            try {
                this.log.debug("Executing ManagedHttpCacheStorage shutdown()");
                this.storage.shutdown();
            }
            catch (Throwable t) {
                this.log.warn("Error invoking ManagedHttpCacheStorage shutdown()", t);
            }
            this.storage = null;
            this.httpClient = null;
            this.destroyed = true;
        }
    }

    private static class StorageMaintenanceTask
    extends TimerTask {
        @Nonnull
        private Logger log = LoggerFactory.getLogger(StorageMaintenanceTask.class);
        @Nonnull
        private final ManagedHttpCacheStorage storage;

        public StorageMaintenanceTask(@Nonnull ManagedHttpCacheStorage managedStorage) {
            this.storage = (ManagedHttpCacheStorage)Constraint.isNotNull((Object)managedStorage, (String)"ManagedHttpCacheStorage was null");
        }

        @Override
        public void run() {
            try {
                this.log.debug("Executing ManagedHttpCacheStorage cleanResources()");
                this.storage.cleanResources();
            }
            catch (Throwable t) {
                this.log.warn("Error invoking ManagedHttpCacheStorage cleanResources()", t);
            }
        }
    }
}

