/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.GenericResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.MappedQueryResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.SQLProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.lib.rop.BatchedResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.util.InternalException;

public class XROP
implements BatchedResultObjectProvider {
    private final CallableStatement stmt;
    private final JDBCFetchConfiguration fetch;
    private final List<QueryResultMapping> _multi;
    private final List<Class<?>> _resultClasses;
    private int index;
    private final JDBCStore store;
    private boolean executionResult;

    public XROP(List<QueryResultMapping> mappings, List<Class<?>> classes, JDBCStore store, JDBCFetchConfiguration fetch, CallableStatement stmt) {
        this._multi = mappings;
        this._resultClasses = classes;
        this.stmt = stmt;
        this.fetch = fetch;
        this.store = store;
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    @Override
    public void open() throws Exception {
        this.executionResult = this.stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultObjectProvider getResultObject() throws Exception {
        ResultSet rs = this.stmt.getResultSet();
        if (rs == null) {
            return null;
        }
        ResultSetResult res = new ResultSetResult(rs, this.store.getDBDictionary());
        res.setCloseConnection(false);
        res.setCloseStatement(false);
        try {
            Object mapping;
            if (this._resultClasses != null && this._resultClasses.size() > this.index && (mapping = this._resultClasses.get(this.index)) != null) {
                GenericResultObjectProvider genericResultObjectProvider = new GenericResultObjectProvider((Class<?>)mapping, this.store, this.fetch, (Result)res);
                return genericResultObjectProvider;
            }
            if (this._multi != null && this._multi.size() > this.index && (mapping = this._multi.get(this.index)) != null) {
                MappedQueryResultObjectProvider mappedQueryResultObjectProvider = new MappedQueryResultObjectProvider((QueryResultMapping)mapping, this.store, this.fetch, res);
                return mappedQueryResultObjectProvider;
            }
            SQLProjectionResultObjectProvider sQLProjectionResultObjectProvider = new SQLProjectionResultObjectProvider(this.store, this.fetch, res, null);
            return sQLProjectionResultObjectProvider;
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public void close() throws Exception {
        this.stmt.close();
    }

    @Override
    public boolean hasMoreResults() {
        try {
            return this.stmt.getMoreResults();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean getExecutionResult() {
        return this.executionResult;
    }

    @Override
    public int getUpdateCount() {
        try {
            return this.stmt.getUpdateCount();
        }
        catch (SQLException e) {
            return -1;
        }
    }

    @Override
    public Object getOut(String name) {
        try {
            return this.stmt.getObject(name);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public Object getOut(int position) {
        try {
            return this.stmt.getObject(position);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public boolean next() throws Exception {
        throw new InternalException();
    }

    @Override
    public boolean absolute(int pos) throws Exception {
        return false;
    }

    @Override
    public int size() throws Exception {
        return -1;
    }

    @Override
    public void reset() throws Exception {
        throw new InternalException();
    }

    @Override
    public void handleCheckedException(Exception e) {
        throw new RuntimeException(e);
    }
}

