/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.generate;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PearExportOperation
implements IRunnableWithProgress {
    protected final IFile[] fExports;
    protected final IContainer fRoot;
    protected final String fFilename;
    protected final boolean fCompress;

    public PearExportOperation(IFile[] exports, IContainer virtualRoot, String filename, boolean compress) {
        this.fExports = exports;
        this.fRoot = virtualRoot;
        this.fFilename = filename;
        this.fCompress = compress;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            FileOutputStream fOut;
            int SCALE = 100;
            String jobName = "Exporting " + this.fExports.length + " files to Pear file " + this.fFilename + "...";
            monitor.beginTask(jobName, 200 * this.fExports.length);
            File pearFile = new File(this.fFilename);
            try {
                fOut = new FileOutputStream(pearFile);
            }
            catch (FileNotFoundException exception) {
                throw new InvocationTargetException(exception);
            }
            ZipOutputStream stream = new ZipOutputStream(fOut);
            if (monitor.isCanceled()) {
                stream.close();
                throw new OperationCanceledException();
            }
            for (int i = 0; i < this.fExports.length; ++i) {
                IFile file = this.fExports[i];
                if (!this.fRoot.getFullPath().isPrefixOf(file.getFullPath())) {
                    throw new IllegalArgumentException(String.valueOf(this.fRoot) + " is not a parent of " + String.valueOf(file));
                }
                String filename = file.getFullPath().toPortableString();
                String cutPath = this.fRoot.getFullPath().addTrailingSeparator().toPortableString();
                filename = filename.substring(cutPath.length());
                monitor.subTask("Adding " + filename);
                byte[] fileContents = this.readContents(file, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ZipEntry entry = new ZipEntry(filename);
                entry.setTime(file.getLocation().toFile().lastModified());
                if (this.fCompress) {
                    entry.setMethod(8);
                } else {
                    entry.setMethod(0);
                    entry.setSize(fileContents.length);
                    CRC32 checksumCalculator = new CRC32();
                    checksumCalculator.update(fileContents);
                    entry.setCrc(checksumCalculator.getValue());
                }
                stream.putNextEntry(entry);
                stream.write(fileContents);
                monitor.worked(100);
                if (!monitor.isCanceled()) continue;
                stream.close();
                pearFile.delete();
                throw new OperationCanceledException();
            }
            stream.close();
        }
        catch (FileNotFoundException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContents(IFile file, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        File localFile = file.getLocation().toFile();
        int bufferSize = 4096;
        int count = (int)(localFile.length() / 4096L);
        try {
            monitor.beginTask("Reading file " + file.getFullPath().toPortableString(), count);
            FileInputStream in = new FileInputStream(localFile);
            BufferedInputStream bIn = new BufferedInputStream(in);
            int length = 0;
            byte[] buffer = new byte[4096];
            byte[] bufferCopy = new byte[4096];
            while ((length = bIn.read(buffer, 0, 4096)) != -1) {
                bufferCopy = new byte[length];
                System.arraycopy(buffer, 0, bufferCopy, 0, length);
                output.write(bufferCopy);
                monitor.worked(1);
            }
            bIn.close();
        }
        finally {
            monitor.done();
            output.close();
        }
        return output.toByteArray();
    }
}

