/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "info.h"


ret_t 
cherokee_bench_info_init (cherokee_bench_info_t *info)
{
	   memset (info->error, 0, sizeof(info->error));
	   
	   info->tx        = 0;
	   info->rx        = 0;
	   info->transfers = 0;
	   info->keepalive = 0;
	   
	   return ret_ok;
}


ret_t 
cherokee_bench_info_clean (cherokee_bench_info_t *info)
{
	return cherokee_bench_info_init(info);
}


ret_t 
cherokee_bench_info_print (cherokee_bench_info_t *info)
{
	int i, j;
	
	printf ("Connections %8d\n"
		"rx          %8d bytes\n"
		"tx          %8d bytes\n"
		"Keepalive   %8d conns\n",
		info->transfers, info->rx, info->tx, info->keepalive);
	
	
	for (i=1; i<4; i++) {
		for (j=0; j<20; j++) {
			if (info->error[i].code[j] != 0) {
				printf ("Error %d%02d   %8d responses\n", i+1, j, info->error[i].code[j]);
			}
		}
	}

	return ret_ok;
}


ret_t 
cherokee_bench_info_add (cherokee_bench_info_t *info, cherokee_bench_info_t *to_add)
{
	int i, j;
	
	info->tx        += to_add->tx;
	info->rx        += to_add->rx;
	info->transfers += to_add->transfers;
	info->keepalive += to_add->keepalive;
	
	for (i=1; i<4; i++) {
		for (j=0; j<20; j++) {
			info->error[i].code[j] += to_add->error[i].code[j];
		}
	}
	
	return ret_ok;
}
