%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"
#include "list_ext.h"

#include "bench.h"
#include "request.h"
#include "http.h"

/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM bench

%}

%union {
	   int               number;
	   char             *string;
	   struct list_head *list;
}

%{
/* What is the right way to import these prototipes?
 * There's the same problem in read_config_grammar.y
 */
extern int   yy_url_lex(void);
extern char *yy_url_text;
extern int   yy_url_lineno;

void
yy_url_error(char* msg)
{
        PRINT_ERROR ("Error parsing configuration: '%s', line %d, symbol '%s' (0x%x)\n", 
				 msg, yy_url_lineno, yy_url_text, yy_url_text[0]);
}

/* Current objects
 */
cherokee_bench_request_t *current_request = NULL;

%}

%token T_METHOD T_KEEPALIVE T_NO_KEEPALIVE T_PIPELINE
%token <string> T_HTTP_URL T_ID
%token <number> T_NUMBER

%%

/* Example:
 *
 * http://cosa:80/dir/objeto?parametro=valor&otro {
 *   method get
 *   no-keepalive
 *   pipeline 10
 * }
 */

url_file : lines;

lines : line
      | lines line;

line : url_entry;

url_entry : T_HTTP_URL
{
	   ret_t ret;

	   /* Create a new object
	    */
	   ret = cherokee_bench_request_new (&current_request);
	   if (ret < ret_ok) return 1;

	   /* Parse the URL
	    */
	   ret = cherokee_url_parse (REQUEST_URL(current_request), $1);
	   if (ret < ret_ok) return 2;

	   /* Add it to the bench object
	    */
	   _cherokee_bench_add_request (BENCH(bench), current_request);

} maybe_url_entry_options;

maybe_url_entry_options : some_url_entry_options 
                        | ;

some_url_entry_options: '{' url_entry_options '}'
{
	   current_request = NULL;
};

url_entry_options : url_entry_option
                  | url_entry_options url_entry_option;

url_entry_option : T_METHOD T_ID
{
	   if (strncasecmp($2, "get", 3) == 0) {
			 REQUEST_METHOD(current_request) = http_get;
	   } else if (strncasecmp($2, "post", 4) == 0) {
			 REQUEST_METHOD(current_request) = http_post;

	   } else if (strncasecmp($2, "head", 4) == 0) {
			 REQUEST_METHOD(current_request) = http_head;

	   } else if (strncasecmp($2, "options", 6) == 0) {
			 REQUEST_METHOD(current_request) = http_options;

	   } else {
			 SHOULDNT_HAPPEN;
	   }
};

url_entry_option : T_NO_KEEPALIVE
{
	   REQUEST_KEEPALIVE(current_request) = false;
};

url_entry_option : T_KEEPALIVE
{
	   REQUEST_KEEPALIVE(current_request) = true;
};

url_entry_option : T_PIPELINE T_NUMBER
{
	   REQUEST_PIPELINE(current_request) = $2;
};


