/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: main.c,v 1.1.1.1.2.3 1998/07/02 06:59:40 sakane Exp $ */

#include <sys/types.h>
#include <sys/param.h>

#include <netinet/in.h>

#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "var.h"
#include "vmbuf.h"
#include "isakmp.h"
#include "extern.h"
#include "debug.h"

static char version[] = "@(#)racoon 0.2 sakane@ydc.co.jp";

char *pname;

unsigned long debug = 0;
int debug_f = 0;

void Usage();
int parse(int, char **);

extern int cfparse(void);
extern int isakmp_init(void);
extern int pfkey_init(void);
extern int admin_init(void);

main(ac, av)
	int ac;
	char **av;
{
	plog("racoon", "@(#)This program includes cryptographic software written by Eric Young.\n");
	plog("racoon", "@(#)His e-mail address is `eay@cryptsoft.com'.\n");

	/* get configuration file name */
	if (parse(ac, av) < 0) {
		exit(1);
	}

	if (cfparse() != 0) {
		exit(1);
	}

	if (parse(ac, av) < 0) {
		exit(1);
	}

	close(0);

	signal_handler(0);

	if (isakmp_init() < 0) {
		exit(1);
	}

	if (pfkey_init() < 0) {
		exit(1);
	}

	if (admin_init() < 0) {
		exit(1);
	}

	session();
}

void
Usage()
{
	printf("Usage: %s [-d] [-h] [-p (port)] [-k (port)] [-a (port)] [-f (file)]\n", pname);
	printf("   -p: The daemon always use a port %d of UDP to send\n", PORT_ISAKMP);
	printf("       unless you specify a port by using this option.\n");
	printf("   -k: The daemon opens another interface instead of\n");
	printf("       the PF_KEY interface.  You can specify explicitly\n");
	printf("       when you specify a port.\n");
	printf("   -a: You can specify a explicit port for administration.\n");
	printf("   -f: specify the configuration file.\n");
	printf("   -d: is specified debug mode.\n");
	return;
}

int
parse(ac, av)
	int ac;
	char **av;
{
	extern char *optarg;
	extern int optind;
	char *p;
	int c;

	pname = *av;

	while ((c = getopt(ac, av, "d:hp:k:a:f:")) != EOF) {
		switch (c) {
		case 'd':
			if (optarg) {
				debug = strtoul(optarg, &p, 16);
				debug_f = 1;
				if (*p != '\0') return(-1);
				YIPSDEBUG(DEBUG_INFO, plog("parse", "debug=0x%08x\n", debug));
			} else
				return(-1);
			break;
		case 'p':
			portI = atoi(optarg);
			break;
		case 'a':
			portA = atoi(optarg);
			break;
		case 'f':
			racoon_conf = optarg;
			break;
		default:
			Usage();
			exit(1);
			break;
		}
	}
	ac -= optind;
	av += optind;

	optind = 1;
	optarg = 0;

	return(0);
}

