/*
CLASS:lsh_connection:ssh_connection
*/
#ifndef GABA_DEFINE
struct lsh_connection
{
  struct ssh_connection super;
  int transport;
  struct service_read_state *reader;
  struct ssh_write_state *writer;
  struct resource_list *gateway_connections;
};
extern struct lsh_class lsh_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_connection_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_connection *i = (struct lsh_connection *) o;
  mark((struct lsh_object *) i->reader);
  mark((struct lsh_object *) i->writer);
  mark((struct lsh_object *) i->gateway_connections);
}
struct lsh_class lsh_connection_class =
{
  STATIC_HEADER,
  &(ssh_connection_class),
  "lsh_connection",
  sizeof(struct lsh_connection),
  do_lsh_connection_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

static struct command *
make_gateway_setup(struct local_info *local)
  /* (S connection_remember (S (B listen_local gateway_accept) (prog1 local))) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
{
  CAST_SUBTYPE(command, res,
MAKE_TRACE("make_gateway_setup",
    S2(CONNECTION_REMEMBER,
      S2(B2(LISTEN_LOCAL,
          GATEWAY_ACCEPT),
        A(PROG1,
          ((struct lsh_object *) local))))));
return res;
;
}
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
/*
CLASS:lsh_options:client_options
*/
#ifndef GABA_DEFINE
struct lsh_options
{
  struct client_options super;
  const char * home;
  int use_gateway;
  int start_gateway;
  int stop_gateway;
  struct local_info *gateway;
  struct arglist transport_args;
};
extern struct lsh_class lsh_options_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_options_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_options *i = (struct lsh_options *) o;
  mark((struct lsh_object *) i->gateway);
}
struct lsh_class lsh_options_class =
{
  STATIC_HEADER,
  &(client_options_class),
  "lsh_options",
  sizeof(struct lsh_options),
  do_lsh_options_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lsh_default_handler:exception_handler
*/
#ifndef GABA_DEFINE
struct lsh_default_handler
{
  struct exception_handler super;
  int * status;
};
extern struct lsh_class lsh_default_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class lsh_default_handler_class =
{
  STATIC_HEADER,
  &(exception_handler_class),
  "lsh_default_handler",
  sizeof(struct lsh_default_handler),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

