/*
CLASS:server_dh_exchange:keyexchange_algorithm
*/
#ifndef GABA_DEFINE
struct server_dh_exchange
{
  struct keyexchange_algorithm super;
  const struct dh_params *params;
  struct alist *keys;
};
extern struct lsh_class server_dh_exchange_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_server_dh_exchange_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct server_dh_exchange *i = (struct server_dh_exchange *) o;
  mark((struct lsh_object *) i->params);
  mark((struct lsh_object *) i->keys);
}
struct lsh_class server_dh_exchange_class =
{
  STATIC_HEADER,
  &(keyexchange_algorithm_class),
  "server_dh_exchange",
  sizeof(struct server_dh_exchange),
  do_server_dh_exchange_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:server_dh_handler:transport_handler
*/
#ifndef GABA_DEFINE
struct server_dh_handler
{
  struct transport_handler super;
  struct dh_state dh;
  struct keypair *key;
};
extern struct lsh_class server_dh_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_server_dh_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct server_dh_handler *i = (struct server_dh_handler *) o;
  dh_state_mark(&(i->dh),
    mark);
  mark((struct lsh_object *) i->key);
}
static void
do_server_dh_handler_free(struct lsh_object *o)
{
  struct server_dh_handler *i = (struct server_dh_handler *) o;
  dh_state_free(&(i->dh));
}
struct lsh_class server_dh_handler_class =
{
  STATIC_HEADER,
  &(transport_handler_class),
  "server_dh_handler",
  sizeof(struct server_dh_handler),
  do_server_dh_handler_mark,
  do_server_dh_handler_free,
};
#endif /* !GABA_DECLARE */

