﻿'======================================
' MRTG-OWL
'======================================
'(C) 2013 Michele Di Maria <michele@nt2.it> 
'Version 1.0 - 8/26/2013
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'     * Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'     * Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'     * Neither the name of the author nor the
'       names of its contributors may be used to endorse or promote products
'       derived from this software without specific prior written permission.
'
' THIS SOFTWARE IS PROVIDED BY Michele Di Maria (michele@nt2.it) ``AS IS'' AND ANY
' EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
' WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
' DISCLAIMED. IN NO EVENT SHALL Michele Di Maria BE LIABLE FOR ANY
' DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
' (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
' LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
' ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
' (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
' SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Imports System.Data.SQLite

Module Modulo
    Sub Main()
        Dim DBConnection As SQLiteConnection = Nothing
        Dim Reader As SQLiteDataReader = Nothing
        Dim NumberOfDataRows As Integer = 0
        Dim WSum As Long = 0
        Dim DataCommand As New SQLiteCommand("SELECT * FROM energy_history where dt >= @datefilter", DBConnection)
        Dim DBPath As String = Command()
        DataCommand.Parameters.AddWithValue("@datefilter", Now.AddMinutes(-5))
        Try
            DBPath = String.Format("Data Source=""{0}""", DBPath).Replace("\", "/")
            DBConnection = New SQLiteConnection(DBPath)
            DBConnection.Open()
            DataCommand.Connection = DBConnection
            Reader = DataCommand.ExecuteReader()
            While Reader.Read
                If Reader("ch1_kw_avg") > 0 Then
                    WSum += Reader("ch1_kw_avg") * 60
                    NumberOfDataRows += 1
                End If
            End While
            Reader.Close()
            DBConnection.Close()
            If NumberOfDataRows > 0 Then
                Console.WriteLine(WSum / NumberOfDataRows)
            Else
                Console.WriteLine(0)
            End If
            Console.WriteLine(0)
            Console.WriteLine(String.Format("last {0} measurements", NumberOfDataRows))
            Console.WriteLine(DBPath)
        Catch ex As Exception
            Console.WriteLine(0)
            Console.WriteLine(0)
            Console.WriteLine(0)
            Console.WriteLine("Error processing the data")
            If Not Reader Is Nothing Then Reader.Close()
            If Not DBConnection Is Nothing Then DBConnection.Close()
        End Try
    End Sub
End Module