/*  $Revision: 1.1.1.1 $
**
**  Quick CAN Input package -- optimized for reading through cans.
**  (why was the name QIO, if there is no output? Tobi)
*/
#include <stdio.h>
#include <sys/types.h>
#include "configdata.h"
#include "clibrary.h"
#include <fcntl.h>
#include <ctype.h>
#include <sys/stat.h>
#include <errno.h>
#include "libinn.h"
#include "logging.h"
#include "tree.h"
#include "can.h"
#include "qci.h"
#include "macros.h"


/*
**  Open a quick file from a descriptor.
*/
QCISTATE *
QCIcanopen(can, size)
    ARTCAN	*can;
    int		size;
{
    QCISTATE	*qp;
    long	artsize;

    qp = NEW(QCISTATE, 1);
    qp->flag = QCI_ok;
    qp->can = can;

    if( !(artsize=CANartsize(can)) )
    {	errno=ENOENT;					/* expired */	
    	return NULL;
    }

    if(size == 0)
	qp->Size=artsize;
    else
	qp->Size=size;

    qp->Bytepos = can->Bytepos[READ];
    qp->Artsize = artsize;
    qp->Buffer = NEW(char, qp->Size);
    qp->Count = 0;
    qp->Start = qp->Buffer;
    qp->End = qp->Buffer;

    return qp;
}


/*
**  Open a file for reading.
*/
QCISTATE *
QCIopen(name, size)
    char	*name;
    int		size;
{
    ARTCAN	*can;
    long	bytepos;
    char	canNameAndPos[SPOOLNAMEBUFF];
    char	*p;

    strcpy(canNameAndPos, name);
    if ((p = strchr(canNameAndPos, '!')) != NULL) {
	*p++ = '\0';
	/* Try to be forgiving of bad input. */
	bytepos = CTYPE(isdigit, *p) ? atol(p) : -1;
    }
    else
	return NULL;

    /* Open the can, read in the first chunk. */
    if( (can=CANopenByName(canNameAndPos))==0 )
	return NULL;

    if( can->Bytepos[READ]!=bytepos )
    {   lseek(can->fd[READ], bytepos, SEEK_SET);
	can->Bytepos[READ]=bytepos;
    }

    return QCIcanopen(can, size);
}


/*
**  Close an open stream.
*/
void
QCIclose(qp)
    QCISTATE	*qp;
{
    DISPOSE(qp->Buffer);
    DISPOSE(qp);
}


/*
**  Rewind an open stream.
*/
int
QCIrewind(qp)
    QCISTATE	*qp;
{
    int		i;

    if( qp->can->fd[READ]==0 )
	CANdescriptorCycle(READ, qp->can);
    
    if( qp->can->Bytepos[READ]!=qp->Bytepos - qp->Count )
    {   if (lseek(qp->can->fd[READ], (OFFSET_T)qp->Bytepos - qp->Count, 
    								SEEK_SET)==-1 )
	{   qp->can->Bytepos[READ]=0;
	    return -1;
	}

	qp->Bytepos=qp->can->Bytepos[READ]=qp->Bytepos - qp->Count;
    }

    i = read(qp->can->fd[READ], qp->Buffer, 
    		(SIZE_T)(qp->Artsize<qp->Size ? qp->Artsize : qp->Size));
    if (i < 0)
    {	qp->can->Bytepos[READ]=0;
        qp->Bytepos=0;
    	return i;
    }

    qp->can->Bytepos[READ]+=i;
    qp->Bytepos+=i;
    qp->Count = i;
    qp->Start = qp->Buffer;
    qp->End = &qp->Buffer[i];
    return 0;
}


/*
**  Get the next line from the input.
*/
char *
QCIread(qp)
    QCISTATE	*qp;
{
    register char	*p;
    register char	*q;
    char		*save;
    int			i;

    while (TRUE) {
        
        /* Read from buffer if there is any data there. */
        if (qp->End > qp->Start) {

            /* Find the newline. */
            p = memchr((POINTER)qp->Start,'\n',(SIZE_T)(qp->End - qp->Start));
            if (p != NULL) {
                *p = '\0';
                qp->Length = p - qp->Start;
                save = qp->Start;
                qp->Start = p + 1;
                qp->flag = QCI_ok;
                return save;
            }

            /* Not there; move unread part down to start of buffer. */
            for (p = qp->Buffer, q = qp->Start; q < qp->End; )
                *p++ = *q++;
        }
        else
            p = qp->Buffer;

	if( qp->can->fd[READ]==0 )
	    CANdescriptorCycle(READ, qp->can);

	if( qp->Bytepos!=qp->can->Bytepos[READ] )
	{   lseek(qp->can->fd[READ], qp->Bytepos, SEEK_SET);
	    qp->can->Bytepos[READ]=qp->Bytepos;
	    /*syslog(L_TRACE, "seeking to bytepos %ld", qp->Bytepos);*/
	}

        /* Read data, reset the pointers. */
        i = read(qp->can->fd[READ], p, 
	      (qp->Artsize - qp->Count < (SIZE_T)(&qp->Buffer[qp->Size]-p)
	      ? qp->Artsize - qp->Count : (SIZE_T)(&qp->Buffer[qp->Size]-p)));
        if (i < 0) {
            qp->flag = QCI_error;
            return NULL;
        }
        if (i == 0) {
            qp->flag = QCI_ok;
            return NULL;
        }

	qp->can->Bytepos[READ] += i;
	qp->can->AccessFlag[READ]=TRUE;
	qp->Bytepos += i;
        qp->Count += i;
        qp->Start = qp->Buffer;
        qp->End = &p[i];

        /* Now try to find it. */
        p = memchr((POINTER)qp->Start, '\n', (SIZE_T)(qp->End - qp->Start));
        if (p != NULL) {
            *p = '\0';
            qp->Length = p - qp->Start;
            save = qp->Start;
            qp->Start = p + 1;
            qp->flag = QCI_ok;
            return save;
        }
        
        if ((qp->End - qp->Start) >= qp->Size) {
            /* Still not there and buffer is full -- line is too long. */
            qp->flag = QCI_long;
            qp->Start = qp->End;
            return NULL;
        }
        /* otherwise, try to read more (in case we're reading from a pipe or
 	   something that won't always give us a full block at once.) */
    }
}
