/* pam_read_conf.c -- Configuration File routines

   Copyright (c) Dave Airlie 2000
   airlied@samba.org

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <string.h>

#include "constants.h"
#include "cache.h"

#define CONFFILE "/etc/pam_smb.conf"

int smb_readpamconf(domain_list *);

/*
 * Read pam_smb configuration file.
 */
int smb_readpamconf(domain_list *pamsmb_dlist)
{
  FILE *fl;
  char buf[255], *p1;
  char *cr0;
  int count=0, scount=0;
  
  if (!(fl=fopen(CONFFILE,"r")))
    {
      return 1;
    }
  
  fgets(buf, 255, fl); 
  
  /* Check for a , in the string, if one then new style file,
     if not then old style */
  
  p1=strchr(buf, ',');
  if (p1==NULL)
    {
      strncpy(pamsmb_dlist->controllers[0].domain, buf, MAX_NTDOM_LEN);
      cr0=strchr(pamsmb_dlist->controllers[0].domain, '\n');
      if (cr0 != NULL)
	*cr0 = '\0';
      pamsmb_dlist->controllers[0].domain[MAX_SERV_LEN]='\0';
      fgets(pamsmb_dlist->controllers[0].servers[0].sername, MAX_SERV_LEN, fl);
      cr0=strchr(pamsmb_dlist->controllers[0].servers[0].sername, '\n');
      if (cr0 != NULL)
	*cr0 = '\0';
      pamsmb_dlist->controllers[0].servers[0].sername[MAX_SERV_LEN]='\0';
      fgets(pamsmb_dlist->controllers[0].servers[1].sername, MAX_SERV_LEN, fl);
      cr0=strchr(pamsmb_dlist->controllers[0].servers[1].sername, '\n');
      if (cr0 != NULL)
	*cr0 = '\0';
      pamsmb_dlist->controllers[0].servers[1].sername[MAX_SERV_LEN]='\0';

      pamsmb_dlist->controllers[0].numservers=2;
      pamsmb_dlist->numdomains=1;
    }
  else
    {
      do 
	{
	  int l = strlen(buf);

	  if (l-- && buf[l] == '\n')
		  buf[l] = '\0';
	  p1=strtok(buf, ",");
	  strncpy(pamsmb_dlist->controllers[count].domain,p1,MAX_NTDOM_LEN);
	  while ((p1=strtok(NULL, ",")) != NULL)
	    {
	      strncpy(pamsmb_dlist->controllers[count].servers[scount].sername,p1,MAX_SERV_LEN);
	      scount++;
	    }
	  pamsmb_dlist->controllers[count].numservers=scount;
	  count++;
	  scount=0;
	} while (!feof(fl) && fgets(buf, 255,fl));
      pamsmb_dlist->numdomains=count;
      
    }
  fclose(fl);
  return(0);
}

