#ifndef _system_readline_h
#define _system_readline_h
/*
   Unix SMB/CIFS implementation.

   Readline wrappers

     ** NOTE! The following LGPL license applies to the replace
     ** library. This does NOT imply that all of Samba is released
     ** under the LGPL

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, see <http://www.gnu.org/licenses/>.

*/

#ifdef HAVE_LIBREADLINE
#  ifdef HAVE_READLINE_READLINE_H
#    ifdef HAVE_READLINE_READLINE_WORKAROUND
#      define _FUNCTION_DEF
#    endif
#    include <readline/readline.h>
#    ifdef HAVE_READLINE_HISTORY_H
#      include <readline/history.h>
#    endif
#  else
#    ifdef HAVE_READLINE_H
#      include <readline.h>
#      ifdef HAVE_HISTORY_H
#        include <history.h>
#      endif
#    else
#      undef HAVE_LIBREADLINE
#    endif
#  endif
#endif

#ifdef HAVE_NEW_LIBREADLINE
#if defined(HAVE_RL_COMPLETION_FUNC_T)
#  define RL_COMPLETION_CAST (rl_completion_func_t *)
#elif defined(HAVE_CPPFUNCTION)
#  define RL_COMPLETION_CAST (CPPFunction *)
#elif defined(HAVE_RL_COMPLETION_T)
#  define RL_COMPLETION_CAST (rl_completion_t *)
#else
#  define RL_COMPLETION_CAST
#endif
#else
/* This type is missing from libreadline<4.0  (approximately) */
#  define RL_COMPLETION_CAST
#endif /* HAVE_NEW_LIBREADLINE */

#endif
