
import os
# The name of the directory we'll pull our source into.
BUILD_DIR = "mozilla-central"
# This is everything that comes after https://hg.mozilla.org/
# e.g. "releases/mozilla-aurora"
REPO_PATH = "mozilla-central"
# This is where the l10n repos are (everything after https://hg.mozilla.org/)
# for mozilla-central, that's "l10n-central".
# For mozilla-aurora, that's "releases/l10n/mozilla-aurora"
L10N_REPO_PATH = "l10n-central"
# Currently this is assumed to be a subdirectory of your build dir
OBJDIR = "objdir-droid"
# Set this to mobile/xul for XUL Fennec
ANDROID_DIR = "mobile/android"
# Absolute path to your mozconfig.
# By default it looks at "./mozconfig"
MOZCONFIG = os.path.join(os.getcwd(), "mozconfig")

config = {
    "work_dir": ".",
    "log_name": "multilocale",
    "objdir": OBJDIR,
    "locales_file": "%s/mobile/locales/l10n-changesets.json" % BUILD_DIR,
    "locales_platform": "android-multilocale",
    "locales_dir": "%s/locales" % ANDROID_DIR,
    "ignore_locales": ["en-US", "multi"],
    "repos": [{
        "repo": "https://hg.mozilla.org/%s" % REPO_PATH,
        "branch": "default",
        "dest": BUILD_DIR,
    }],
    "vcs_share_base": "/builds/hg-shared",
    "l10n_repos": [],
    "hg_l10n_base": "https://hg.mozilla.org/%s" % L10N_REPO_PATH,
    "hg_l10n_tag": "default",
    "l10n_dir": "l10n",
    "mozilla_dir": BUILD_DIR,
    "mozconfig": MOZCONFIG,
    "default_actions": [
        "pull-locale-source",
        "build",
        "package-en-US",
        "backup-objdir",
        "restore-objdir",
        "add-locales",
        "package-multi",
        "summary",
    ],
}
