--TEST--
bcdiv() function div by one
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
$dividend_cases = ['100', '-100'];
$divisor_cases = ['1.010', '1.01', '1.1', '1', '-1.010', '-1.01', '-1.1', '-1'];
$scale_cases = [0, 1, 2, 3];

foreach ($scale_cases as $scale) {
    echo "scale: {$scale}\n";
    foreach ($divisor_cases as $divisor) {
        foreach ($dividend_cases as $dividend) {
            $dividend_label = str_pad($dividend, 4, ' ', STR_PAD_LEFT);
            $divisor_label = str_pad($divisor, 6, ' ', STR_PAD_LEFT);
            $quot = bcdiv($dividend, $divisor, $scale);
            $quot_label = str_pad($quot, $scale + 2 + ($scale ? 1 : 0), ' ', STR_PAD_LEFT);
            echo $dividend_label, ' / ', $divisor_label, ' = ', $quot_label, "\n";
        }
    }
    echo "\n";
}
?>
--EXPECT--
scale: 0
 100 /  1.010 = 99
-100 /  1.010 = -99
 100 /   1.01 = 99
-100 /   1.01 = -99
 100 /    1.1 = 90
-100 /    1.1 = -90
 100 /      1 = 100
-100 /      1 = -100
 100 / -1.010 = -99
-100 / -1.010 = 99
 100 /  -1.01 = -99
-100 /  -1.01 = 99
 100 /   -1.1 = -90
-100 /   -1.1 = 90
 100 /     -1 = -100
-100 /     -1 = 100

scale: 1
 100 /  1.010 = 99.0
-100 /  1.010 = -99.0
 100 /   1.01 = 99.0
-100 /   1.01 = -99.0
 100 /    1.1 = 90.9
-100 /    1.1 = -90.9
 100 /      1 = 100.0
-100 /      1 = -100.0
 100 / -1.010 = -99.0
-100 / -1.010 = 99.0
 100 /  -1.01 = -99.0
-100 /  -1.01 = 99.0
 100 /   -1.1 = -90.9
-100 /   -1.1 = 90.9
 100 /     -1 = -100.0
-100 /     -1 = 100.0

scale: 2
 100 /  1.010 = 99.00
-100 /  1.010 = -99.00
 100 /   1.01 = 99.00
-100 /   1.01 = -99.00
 100 /    1.1 = 90.90
-100 /    1.1 = -90.90
 100 /      1 = 100.00
-100 /      1 = -100.00
 100 / -1.010 = -99.00
-100 / -1.010 = 99.00
 100 /  -1.01 = -99.00
-100 /  -1.01 = 99.00
 100 /   -1.1 = -90.90
-100 /   -1.1 = 90.90
 100 /     -1 = -100.00
-100 /     -1 = 100.00

scale: 3
 100 /  1.010 = 99.009
-100 /  1.010 = -99.009
 100 /   1.01 = 99.009
-100 /   1.01 = -99.009
 100 /    1.1 = 90.909
-100 /    1.1 = -90.909
 100 /      1 = 100.000
-100 /      1 = -100.000
 100 / -1.010 = -99.009
-100 / -1.010 = 99.009
 100 /  -1.01 = -99.009
-100 /  -1.01 = 99.009
 100 /   -1.1 = -90.909
-100 /   -1.1 = 90.909
 100 /     -1 = -100.000
-100 /     -1 = 100.000
