/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/islandoftex/texplate/util/PathUtils;", "", "()V", "TEMPLATES_FOLDER", "", "USER_APPLICATION_FOLDER", "userTemplatePath", "Ljava/nio/file/Path;", "getUserTemplatePath", "()Ljava/nio/file/Path;", "getTemplatePath", "name", "texplate"})
public final class PathUtils {
    @NotNull
    public static final PathUtils INSTANCE = new PathUtils();
    @NotNull
    private static final String TEMPLATES_FOLDER = "templates";
    @NotNull
    private static final String USER_APPLICATION_FOLDER = ".texplate";

    private PathUtils() {
    }

    private final Path getUserTemplatePath() {
        Path path;
        try {
            String[] stringArray = new String[]{USER_APPLICATION_FOLDER, TEMPLATES_FOLDER};
            path = Paths.get(System.getProperty("user.home"), stringArray);
            Intrinsics.checkNotNullExpressionValue(path, "{\n            Paths.get(System.getProperty(\"user.home\"),\n                    USER_APPLICATION_FOLDER, TEMPLATES_FOLDER)\n        }");
        }
        catch (RuntimeException e) {
            Path path2 = Paths.get(".", new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "{\n            Paths.get(\".\")\n        }");
            path = path2;
        }
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getTemplatePath(@NotNull String name) throws FileNotFoundException {
        Path path;
        Intrinsics.checkNotNullParameter(name, "name");
        if (StringsKt.endsWith$default(name, ".toml", false, 2, null) && Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            Path path2 = Paths.get(name, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(name)");
            return path2;
        }
        String fullName = Intrinsics.stringPlus(name, ".toml");
        Path reference = INSTANCE.getUserTemplatePath().resolve(fullName);
        if (Files.exists(reference, new LinkOption[0])) {
            Path path3 = reference;
            Intrinsics.checkNotNullExpressionValue(path3, "{\n            reference\n        }");
            path = path3;
        } else {
            Path path4;
            try {
                Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
                Serializable serializable = tempFile.toFile();
                Intrinsics.checkNotNullExpressionValue(serializable, "tempFile.toFile()");
                File file = serializable;
                serializable = PathUtils.class.getResource(Intrinsics.stringPlus("/org/islandoftex/texplate/templates/texplate-", fullName));
                Intrinsics.checkNotNullExpressionValue(serializable, "PathUtils::class.java\n                        .getResource(\"/org/islandoftex/texplate/templates/texplate-$fullName\")");
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)serializable);
                boolean bl2 = false;
                boolean bl3 = false;
                FilesKt.writeText$default(file, new String(byArray, charset), null, 2, null);
                path4 = tempFile;
            }
            catch (RuntimeException e) {
                throw new FileNotFoundException("I am sorry, but the template file '" + fullName + "' could not be found in the default template locations (system and user). Make sure the reference is correct and try again. For reference, these are the paths I searched: '" + INSTANCE.getUserTemplatePath() + "'.");
            }
            Path path5 = path4;
            Intrinsics.checkNotNullExpressionValue(path5, "{\n            // the reference was not found in the user location, so let us try the\n            // system counterpart\n            try {\n                val tempFile = Files.createTempFile(null, null)\n                tempFile.toFile().writeText(PathUtils::class.java\n                        .getResource(\"/org/islandoftex/texplate/templates/texplate-$fullName\")\n                        .readText())\n                tempFile\n            } catch (e: RuntimeException) {\n                throw FileNotFoundException(\"I am sorry, but the template \" +\n                        \"file '\" + fullName + \"' could not be found in the \" +\n                        \"default template locations (system and user). Make \" +\n                        \"sure the reference is correct and try again. For \" +\n                        \"reference, these are the paths I searched: '\" +\n                        userTemplatePath + \"'.\")\n            }\n        }");
            path = path5;
        }
        return path;
    }
}

