% !TeX root = genealogytree.tex
%% The LaTeX package genealogytree - version 0.10 (2015/01/12)
%% genealogytree.tex: Manual class file
%%
%% -------------------------------------------------------------------------------------------
%% Copyright (c) 2013-2015 by Prof. Dr. Dr. Thomas F. Sturm <thomas dot sturm at unibw dot de>
%% -------------------------------------------------------------------------------------------
%%
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This work has the LPPL maintenance status `author-maintained'.
%%
%% This work consists of all files listed in README
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{genealogytree.doc}[2015/01/12 version 0.10 auxiliary documentation class]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions
\LoadClass{book}
\RequirePackage{doc}
\AtBeginDocument{\MakeShortVerb{\|}}

\RequirePackage[T1]{fontenc}
\RequirePackage[latin1]{inputenc}
\RequirePackage[english]{babel}
\RequirePackage{lmodern,parskip,array,ifthen,calc,makeidx,varioref}
\RequirePackage{amsmath,amssymb}
\RequirePackage[svgnames,table,hyperref]{xcolor}
\RequirePackage{tikz}
\RequirePackage[pdftex,bookmarks,raiselinks,pageanchor,hyperindex,colorlinks]{hyperref}

\RequirePackage[a4paper,left=2.5cm,right=2.5cm,top=1.5cm,bottom=1.5cm,
    marginparsep=5mm,marginparwidth=10mm,
    headheight=0mm,headsep=0cm,
    footskip=1.5cm,includeheadfoot]{geometry}
\RequirePackage{fancyhdr}
\fancyhf{}
\fancyfoot[C]{\thepage}%
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\pagestyle{fancy}
\tolerance=2000%
\setlength{\emergencystretch}{20pt}%

\RequirePackage{csquotes}
\RequirePackage[style=numeric-comp,sorting=nyt,
  maxnames=8,minnames=8,abbreviate=false,backend=biber]{biblatex}
\DeclareFieldFormat{url}{\newline\url{#1}}%
\DeclareListFormat{language}{}%
\setlength{\bibitemsep}{\smallskipamount}

\usetikzlibrary{shadings,shadows}
\usetikzlibrary{decorations.pathmorphing}
\usetikzlibrary{patterns}

\RequirePackage{array,tabularx}
\RequirePackage{amsmath}
\RequirePackage{lipsum}

\RequirePackage{changepage}
\strictpagecheck

\RequirePackage[most,documentation]{tcolorbox}
\tcbset{skin=enhanced,
  doc head={colback=yellow!10!white,interior style=fill},
  doc head key={colback=magenta!5!white,interior style=fill},
  color key=DarkViolet,
  color value=Teal,
  color color=Teal,
  index colorize,index annotate}

\urlstyle{sf}

\RequirePackage{cleveref}

\lstdefinestyle{mydocumentation}{style=tcbdocumentation,
  classoffset=0,
  texcsstyle=\color{blue},
  % LaTeX and other packages
  moretexcs={arrayrulecolor,draw,includegraphics,ifthenelse,isodd,lipsum,path,pgfkeysalso},
  classoffset=1,
  % genealogytree macros
  moretexcs={%
    gtrset,genealogytree,gtrsetoptionfor,gtrparserdebug,gtrparserdebuginput,
    },
  texcsstyle=\color{Definition}\bfseries,
  classoffset=2,
  keywordstyle=\color{Option}\bfseries,
  % option list
  morekeywords={%
    },
  classoffset=0% restore default
  }

\tcbset{documentation listing style=mydocumentation,%
  sbs/.style={sidebyside,before lower app={\tcbset{sidebyside=false}}},%
  innerbox/.style={reset,documentation listing style=mydocumentation,docexample/.style={docexample original}},
  base example/.style={enhanced,colframe=Navy!50!ExampleFrame,colback=Navy!5!ExampleBack,fontlower=\footnotesize,
    bicolor,colbacklower=ExampleBack!5!white,drop fuzzy shadow},
  docexample/.style={base example,%
    },
  docexample original/.style={colframe=ExampleFrame,colback=ExampleBack,fontlower=\footnotesize,frame style={}},
}

\tcbmakedocSubKey{docGtrKey}{gtr}
\tcbmakedocSubKey{dataGtrKey}{gtr/database}

\tcbmakedocSubKey{docTcbKey}{tcb}
\tcbmakedocSubKey{docTikzKey}{tikz}


\newtcolorbox{syntax}[2][]{title={#2},enhanced,drop fuzzy shadow,
  colback=red!5!white,colframe=red!75!black,colbacktitle=red!90!black,
  fonttitle=\bfseries,fontupper=\ttfamily,
  before upper=\begin{tabbing}pa\=\hspace*{8cm}\=\kill,after upper=\end{tabbing},#1}

\newcommand{\syncomment}[1]{\textcolor{blue}{\textrm{\itshape#1}}}

\def\externalnext#1{\tikzsetnextfilename{#1}}

\tcbset{%
  external/.code={\externalnext{#1}},
  remake/.code={\tikzset{external/remake next}},
  savefile/.style={tempfile={#1},
    fonttitle=\bfseries,title=File \flqq\texttt{\detokenize{#1}}\frqq},
  }

\tcbset{index format=pgfchapter}
