% File src/library/tools/man/buildVignettes.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2014 R Core Team
% Distributed under GPL 2 or later

\name{buildVignettes}
\alias{buildVignettes}
\alias{pkgVignettes}
\title{List and Build Package Vignettes}
\description{
  Run \code{\link{Sweave}} (or other custom weave function)
  and \code{\link{texi2dvi}} on all vignettes
  of a package.
}
\usage{
buildVignettes(package, dir, lib.loc = NULL, quiet = TRUE,
               clean = TRUE, tangle = FALSE)

pkgVignettes(package, dir, subdirs = NULL, lib.loc = NULL,
	     output = FALSE, source = FALSE, check = FALSE)
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, vignette source files are by default looked for in
    subdirectory \file{doc}.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This subdirectory \file{vignettes} (or if it
    does not exist \file{inst/doc}) is searched for vignette source
    files.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    search for \code{package}.}
  \item{quiet}{logical. Weave and run
    \code{\link{texi2pdf}} in quiet mode.}
  \item{clean}{Remove all files generated by the build, even if there
    were copies there before.}
  \item{tangle}{logical.  Do tangling as well as weaving.}
  \item{subdirs}{a character vector of subdirectories of \code{dir} in which
    to look for vignettes. The first which exists is used.  Defaults to
    \code{"doc"} if \code{package} is supplied, otherwise \code{"vignettes"}.}
  \item{output}{logical indicating if the output filenames for each
    vignette should be returned (in component \code{outputs}).}
  \item{source}{logical indicating if the \emph{tangled} output
    filenames for each vignette should be returned (in component \code{sources}).}
  \item{check}{logical.  If \code{TRUE}, check whether all files that
    have vignette-like filenames have an identifiable vignette engine.
    This may be a false positive if a file is not a vignette but has a 
    filename matching a pattern defined by one of the vignette engines.} 
}
\details{
  \code{buildVignettes} is used by \command{R CMD build} and \command{R CMD
    check} to (re-)build vignette PDFs from their sources. 
}
\value{
  \code{buildVignettes} is called for its side effect of creating the
  PDF versions of all vignettes, and if \code{tangle = TRUE}, 
  extracting the \R{} code.

  \code{pkgVignettes} returns an object of class \code{"pkgVignettes"}
  if a vignette directory is found, otherwise \code{NULL}.  
}
\examples{
gVigns <- pkgVignettes("grid")
\donttest{str(gVigns)}% because it contains paths
}
\keyword{utilities}
\keyword{documentation}
