/* plugin.c generated by valac 0.30.0, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/libanjuta.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <gio/gio.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gtk/gtk.h>
#include <valacodegen.h>
#include <glib/gi18n-lib.h>


#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
typedef struct _ValaPluginPrivate ValaPluginPrivate;

#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;

#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;

#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
	GSettings* settings;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};

struct _ValaPluginPrivate {
	guint editor_watch_id;
	gulong project_loaded_id;
	ValaCodeContext* context;
	GStaticRecMutex __lock_context;
	GCancellable* cancel;
	BlockLocator* locator;
	AnjutaReport* report;
	ValaProvider* provider;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaSet* current_sources;
};


static gpointer vala_plugin_parent_class = NULL;
extern gchar* vala_plugin_PREFS_BUILDER;
gchar* vala_plugin_PREFS_BUILDER = NULL;
extern GtkBuilder* vala_plugin_bxml;
GtkBuilder* vala_plugin_bxml = NULL;
static IAnjutaPreferencesIface* vala_plugin_ianjuta_preferences_parent_iface = NULL;
static GType vala_plugin_type_id = 0;

GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
#define VALA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PLUGIN, ValaPluginPrivate))
enum  {
	VALA_PLUGIN_DUMMY_PROPERTY
};
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
#define VALA_PLUGIN_PREF_WIDGET_SPACE "preferences:completion-space-after-func"
#define VALA_PLUGIN_PREF_WIDGET_BRACE "preferences:completion-brace-after-func"
#define VALA_PLUGIN_PREF_WIDGET_AUTO "preferences:completion-enable"
#define VALA_PLUGIN_ICON_FILE "anjuta-vala.png"
#define VALA_PLUGIN_DECL_MARK "/* ANJUTA: Widgets declaration for %s - DO NOT REMOVE */\n"
#define VALA_PLUGIN_INIT_MARK "/* ANJUTA: Widgets initialization for %s - DO NOT REMOVE */\n"
static ValaPlugin* vala_plugin_new (void);
static ValaPlugin* vala_plugin_construct (GType object_type);
static gboolean vala_plugin_real_activate (AnjutaPlugin* base);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void vala_plugin_init_context (ValaPlugin* self);
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value);
static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self);
void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name);
static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self);
static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base);
void anjuta_report_clear_error_indicators (AnjutaReport* self, ValaSourceFile* file);
static void vala_plugin_parse (ValaPlugin* self);
static void ___lambda4_ (ValaPlugin* self);
static gpointer ____lambda4__gthread_func (gpointer self);
static void vala_plugin_add_project_files (ValaPlugin* self);
static void __lambda5_ (ValaPlugin* self, AnjutaProjectNode* node);
static void ___lambda5__anjuta_project_node_foreach_func (AnjutaProjectNode* node, gpointer self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup1 (gchar** self, int length);
void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e);
static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self);
void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch);
static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self);
void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file);
static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self);
gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position);
static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self);
void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data);
static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self);
static void vala_plugin_insert_member_decl_and_init (ValaPlugin* self, IAnjutaEditor* editor, const gchar* widget_ctype, const gchar* widget_name, const gchar* filename);
static void _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add (IAnjutaEditor* _sender, const gchar* widget_typename, const gchar* widget_name, const gchar* filename, gpointer self);
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file);
#define VALA_PROVIDER_PREF_CALLTIP_ENABLE "calltip-enable"
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor);
static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent);
static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static gboolean vala_plugin_insert_after_mark (ValaPlugin* self, IAnjutaEditor* editor, const gchar* mark, const gchar* code_to_add);
ValaSymbol* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block);
static void vala_plugin_on_autocompletion_toggled (ValaPlugin* self, GtkToggleButton* button);
static void vala_plugin_real_merge (IAnjutaPreferences* base, AnjutaPreferences* prefs, GError** error);
static void _vala_plugin_on_autocompletion_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void vala_plugin_real_unmerge (IAnjutaPreferences* base, AnjutaPreferences* prefs, GError** error);
static void vala_plugin_finalize (GObject* obj);
GType anjuta_glue_register_components (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static ValaPlugin* vala_plugin_construct (GType object_type) {
	ValaPlugin * self = NULL;
	self = (ValaPlugin*) g_object_new (object_type, NULL);
	return self;
}


static ValaPlugin* vala_plugin_new (void) {
	return vala_plugin_construct (TYPE_VALA_PLUGIN);
}


static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self) {
	vala_plugin_editor_value_added ((ValaPlugin*) self, plugin, name, value);
}


static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self) {
	vala_plugin_editor_value_removed ((ValaPlugin*) self, plugin, name);
}


static gboolean vala_plugin_real_activate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	AnjutaReport* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	AnjutaShell* _tmp2_ = NULL;
	AnjutaShell* _tmp3_ = NULL;
	AnjutaShell* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	AnjutaReport* _tmp7_ = NULL;
	ValaParser* _tmp8_ = NULL;
	ValaGenieParser* _tmp9_ = NULL;
	ValaProvider* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:51: Activating ValaPlugin");
	_tmp0_ = anjuta_report_new ();
	_g_object_unref0 (self->priv->report);
	self->priv->report = _tmp0_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = anjuta_shell_get_object (_tmp4_, "IAnjutaDocumentManager", &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp1_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = self->priv->report;
	anjuta_report_set_docman (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, ianjuta_document_manager_get_type (), IAnjutaDocumentManager));
	_tmp8_ = vala_parser_new ();
	_vala_code_visitor_unref0 (self->priv->parser);
	self->priv->parser = _tmp8_;
	_tmp9_ = vala_genie_parser_new ();
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	self->priv->genie_parser = _tmp9_;
	vala_plugin_init_context (self);
	_tmp10_ = vala_provider_new (self);
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp10_;
	_tmp11_ = anjuta_plugin_add_watch ((AnjutaPlugin*) self, "document_manager_current_document", _vala_plugin_editor_value_added_anjuta_plugin_value_added, _vala_plugin_editor_value_removed_anjuta_plugin_value_removed, self);
	self->priv->editor_watch_id = _tmp11_;
	result = TRUE;
	return result;
}


static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	GCancellable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:68: Deactivating ValaPlugin");
	_tmp0_ = self->priv->editor_watch_id;
	anjuta_plugin_remove_watch ((AnjutaPlugin*) self, _tmp0_, TRUE);
	_tmp1_ = self->priv->cancel;
	g_cancellable_cancel (_tmp1_);
	{
		ValaCodeContext* _tmp2_ = NULL;
		_tmp2_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			_vala_code_context_unref0 (self->priv->context);
			self->priv->context = NULL;
		}
		__finally0:
		{
			ValaCodeContext* _tmp3_ = NULL;
			_tmp3_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static void vala_plugin_init_context (ValaPlugin* self) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	ValaCodeContext* _tmp2_ = NULL;
	AnjutaReport* _tmp3_ = NULL;
	AnjutaReport* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	ValaParser* _tmp6_ = NULL;
	ValaCodeContext* _tmp7_ = NULL;
	ValaGenieParser* _tmp8_ = NULL;
	ValaCodeContext* _tmp9_ = NULL;
	GHashFunc _tmp10_ = NULL;
	GEqualFunc _tmp11_ = NULL;
	ValaHashSet* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = self->priv->report;
	vala_code_context_set_report (_tmp2_, (ValaReport*) _tmp3_);
	_tmp4_ = self->priv->report;
	anjuta_report_clear_error_indicators (_tmp4_, NULL);
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp5_;
	_tmp6_ = self->priv->parser;
	_tmp7_ = self->priv->context;
	vala_parser_parse (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->genie_parser;
	_tmp9_ = self->priv->context;
	vala_genie_parser_parse (_tmp8_, _tmp9_);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp10_, _tmp11_);
	_vala_iterable_unref0 (self->priv->current_sources);
	self->priv->current_sources = (ValaSet*) _tmp12_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda4_ (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	{
		ValaCodeContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaCodeContext* _tmp1_ = NULL;
			AnjutaReport* report = NULL;
			ValaCodeContext* _tmp2_ = NULL;
			ValaReport* _tmp3_ = NULL;
			ValaReport* _tmp4_ = NULL;
			AnjutaReport* _tmp5_ = NULL;
			gboolean _tmp33_ = FALSE;
			AnjutaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			ValaCodeContext* _tmp39_ = NULL;
			_tmp1_ = self->priv->context;
			vala_code_context_push (_tmp1_);
			_tmp2_ = self->priv->context;
			_tmp3_ = vala_code_context_get_report (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_ANJUTA_REPORT) ? ((AnjutaReport*) _tmp4_) : NULL);
			report = _tmp5_;
			{
				ValaList* _src_list = NULL;
				ValaCodeContext* _tmp6_ = NULL;
				ValaList* _tmp7_ = NULL;
				gint _src_size = 0;
				ValaList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _src_index = 0;
				_tmp6_ = self->priv->context;
				_tmp7_ = vala_code_context_get_source_files (_tmp6_);
				_src_list = _tmp7_;
				_tmp8_ = _src_list;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				_src_size = _tmp10_;
				_src_index = -1;
				while (TRUE) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					ValaSourceFile* src = NULL;
					ValaList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gpointer _tmp16_ = NULL;
					ValaSourceFile* _tmp17_ = NULL;
					ValaList* _tmp18_ = NULL;
					ValaList* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					gboolean _tmp22_ = FALSE;
					GCancellable* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
					_tmp11_ = _src_index;
					_src_index = _tmp11_ + 1;
					_tmp12_ = _src_index;
					_tmp13_ = _src_size;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = _src_list;
					_tmp15_ = _src_index;
					_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
					src = (ValaSourceFile*) _tmp16_;
					_tmp17_ = src;
					_tmp18_ = vala_source_file_get_nodes (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = _tmp21_ == 0;
					_vala_iterable_unref0 (_tmp19_);
					if (_tmp22_) {
						ValaSourceFile* _tmp23_ = NULL;
						const gchar* _tmp24_ = NULL;
						const gchar* _tmp25_ = NULL;
						ValaGenieParser* _tmp26_ = NULL;
						ValaSourceFile* _tmp27_ = NULL;
						ValaParser* _tmp28_ = NULL;
						ValaSourceFile* _tmp29_ = NULL;
						_tmp23_ = src;
						_tmp24_ = vala_source_file_get_filename (_tmp23_);
						_tmp25_ = _tmp24_;
						g_debug ("plugin.vala:105: parsing file %s", _tmp25_);
						_tmp26_ = self->priv->genie_parser;
						_tmp27_ = src;
						vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp26_, _tmp27_);
						_tmp28_ = self->priv->parser;
						_tmp29_ = src;
						vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp28_, _tmp29_);
					}
					_tmp30_ = self->priv->cancel;
					_tmp31_ = g_cancellable_is_cancelled (_tmp30_);
					if (_tmp31_) {
						vala_code_context_pop ();
						_vala_source_file_unref0 (src);
						_vala_iterable_unref0 (_src_list);
						_g_object_unref0 (report);
						{
							ValaCodeContext* _tmp32_ = NULL;
							_tmp32_ = self->priv->context;
							g_static_rec_mutex_unlock (&self->priv->__lock_context);
						}
						return;
					}
					_vala_source_file_unref0 (src);
				}
				_vala_iterable_unref0 (_src_list);
			}
			_tmp34_ = report;
			_tmp35_ = vala_report_get_errors ((ValaReport*) _tmp34_);
			if (_tmp35_ > 0) {
				_tmp33_ = TRUE;
			} else {
				GCancellable* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				_tmp36_ = self->priv->cancel;
				_tmp37_ = g_cancellable_is_cancelled (_tmp36_);
				_tmp33_ = _tmp37_;
			}
			if (_tmp33_) {
				vala_code_context_pop ();
				_g_object_unref0 (report);
				{
					ValaCodeContext* _tmp38_ = NULL;
					_tmp38_ = self->priv->context;
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				return;
			}
			_tmp39_ = self->priv->context;
			vala_code_context_check (_tmp39_);
			vala_code_context_pop ();
			_g_object_unref0 (report);
		}
		__finally2:
		{
			ValaCodeContext* _tmp40_ = NULL;
			_tmp40_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer ____lambda4__gthread_func (gpointer self) {
	gpointer result;
	___lambda4_ ((ValaPlugin*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}


static void vala_plugin_parse (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_thread_create (____lambda4__gthread_func, g_object_ref (self), FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch1_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		g_warning ("plugin.vala:126: cannot create thread : %s", _tmp1_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda5_ (ValaPlugin* self, AnjutaProjectNode* node) {
	AnjutaProjectNode* _tmp0_ = NULL;
	AnjutaProjectNodeType _tmp1_ = 0;
	AnjutaProjectNode* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* path = NULL;
	AnjutaProjectNode* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = anjuta_project_node_get_node_type (_tmp0_);
	if (!((_tmp1_ & ANJUTA_PROJECT_SOURCE) == ANJUTA_PROJECT_SOURCE)) {
		return;
	}
	_tmp2_ = node;
	_tmp3_ = anjuta_project_node_get_file (_tmp2_);
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = node;
	_tmp5_ = anjuta_project_node_get_file (_tmp4_);
	_tmp6_ = g_file_get_path (_tmp5_);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp10_ = path;
	_tmp11_ = g_str_has_suffix (_tmp10_, ".vala");
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = path;
		_tmp13_ = g_str_has_suffix (_tmp12_, ".vapi");
		_tmp9_ = _tmp13_;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = path;
		_tmp15_ = g_str_has_suffix (_tmp14_, ".gs");
		_tmp8_ = _tmp15_;
	}
	if (_tmp8_) {
		ValaSet* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp16_ = self->priv->current_sources;
		_tmp17_ = path;
		_tmp18_ = vala_collection_contains ((ValaCollection*) _tmp16_, _tmp17_);
		if (_tmp18_) {
			const gchar* _tmp19_ = NULL;
			_tmp19_ = path;
			g_debug ("plugin.vala:160: file %s already added", _tmp19_);
		} else {
			ValaCodeContext* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			ValaSet* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp20_ = self->priv->context;
			_tmp21_ = path;
			vala_code_context_add_source_filename (_tmp20_, _tmp21_, FALSE, FALSE);
			_tmp22_ = self->priv->current_sources;
			_tmp23_ = path;
			vala_collection_add ((ValaCollection*) _tmp22_, _tmp23_);
			_tmp24_ = path;
			g_debug ("plugin.vala:164: file %s added", _tmp24_);
		}
	} else {
		const gchar* _tmp25_ = NULL;
		_tmp25_ = path;
		g_debug ("plugin.vala:167: file %s skipped", _tmp25_);
	}
	_g_free0 (path);
}


static void ___lambda5__anjuta_project_node_foreach_func (AnjutaProjectNode* node, gpointer self) {
	__lambda5_ ((ValaPlugin*) self, node);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void vala_plugin_add_project_files (ValaPlugin* self) {
	GObject* _tmp0_ = NULL;
	AnjutaShell* _tmp1_ = NULL;
	AnjutaShell* _tmp2_ = NULL;
	AnjutaShell* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	IAnjutaProjectManager* pm = NULL;
	IAnjutaProjectManager* _tmp6_ = NULL;
	IAnjutaProject* project = NULL;
	IAnjutaProjectManager* _tmp7_ = NULL;
	IAnjutaProject* _tmp8_ = NULL;
	IAnjutaProject* _tmp9_ = NULL;
	GFile* current_file = NULL;
	IAnjutaEditor* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	IAnjutaProject* _tmp12_ = NULL;
	ValaCodeContext* _tmp13_ = NULL;
	AnjutaProjectNode* _tmp14_ = NULL;
	IAnjutaProject* _tmp15_ = NULL;
	AnjutaProjectNode* _tmp16_ = NULL;
	AnjutaProjectNode* current_src = NULL;
	GFile* _tmp17_ = NULL;
	AnjutaProjectNode* _tmp18_ = NULL;
	AnjutaProjectNode* _tmp19_ = NULL;
	AnjutaProjectNode* _tmp20_ = NULL;
	AnjutaProjectNode* current_target = NULL;
	AnjutaProjectNode* _tmp21_ = NULL;
	AnjutaProjectNode* _tmp22_ = NULL;
	AnjutaProjectNode* _tmp23_ = NULL;
	AnjutaProjectNode* _tmp24_ = NULL;
	AnjutaProjectNode* _tmp25_ = NULL;
	ValaCodeContext* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	gchar** flags = NULL;
	gchar** _tmp30_ = NULL;
	gint flags_length1 = 0;
	gint _flags_size_ = 0;
	AnjutaProjectProperty* prop = NULL;
	AnjutaProjectNode* _tmp31_ = NULL;
	AnjutaProjectProperty* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	AnjutaProjectProperty* _tmp34_ = NULL;
	gchar** packages = NULL;
	gchar** _tmp58_ = NULL;
	gint packages_length1 = 0;
	gint _packages_size_ = 0;
	gchar** vapidirs = NULL;
	gchar** _tmp59_ = NULL;
	gint vapidirs_length1 = 0;
	gint _vapidirs_size_ = 0;
	gchar* srcdir = NULL;
	AnjutaProjectNode* _tmp107_ = NULL;
	AnjutaProjectNode* _tmp108_ = NULL;
	GFile* _tmp109_ = NULL;
	gchar* _tmp110_ = NULL;
	AnjutaProjectNode* _tmp111_ = NULL;
	IAnjutaProject* _tmp112_ = NULL;
	AnjutaProjectNode* _tmp113_ = NULL;
	gchar* top_srcdir = NULL;
	GFile* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	ValaCodeContext* _tmp131_ = NULL;
	gchar** _tmp132_ = NULL;
	gint _tmp132__length1 = 0;
	gchar** _tmp133_ = NULL;
	gint _tmp133__length1 = 0;
	gchar** _tmp134_ = NULL;
	gint _tmp134__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = anjuta_shell_get_object (_tmp3_, "IAnjutaProjectManager", &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp0_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ianjuta_project_manager_get_type (), IAnjutaProjectManager));
	pm = _tmp6_;
	_tmp7_ = pm;
	_tmp8_ = ianjuta_project_manager_get_current_project (_tmp7_, &_inner_error_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	project = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = self->current_editor;
	_tmp11_ = ianjuta_file_get_file (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, ianjuta_file_get_type ()) ? ((IAnjutaFile*) _tmp10_) : NULL, &_inner_error_);
	current_file = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = project;
	if (_tmp12_ == NULL) {
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp13_ = self->priv->context;
	vala_code_context_push (_tmp13_);
	_tmp15_ = project;
	_tmp16_ = ianjuta_project_get_root (_tmp15_, &_inner_error_);
	_tmp14_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = current_file;
	_tmp18_ = anjuta_project_node_get_source_from_file (_tmp14_, _tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	current_src = _tmp19_;
	_tmp20_ = current_src;
	if (_tmp20_ == NULL) {
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp21_ = current_src;
	_tmp22_ = anjuta_project_node_parent_type (_tmp21_, ANJUTA_PROJECT_TARGET);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	current_target = _tmp23_;
	_tmp24_ = current_target;
	if (_tmp24_ == NULL) {
		_g_object_unref0 (current_target);
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp25_ = current_target;
	anjuta_project_node_foreach (_tmp25_, G_PRE_ORDER, ___lambda5__anjuta_project_node_foreach_func, self);
	_tmp26_ = self->priv->context;
	_tmp27_ = vala_code_context_has_package (_tmp26_, "gobject-2.0");
	if (!_tmp27_) {
		ValaCodeContext* _tmp28_ = NULL;
		ValaCodeContext* _tmp29_ = NULL;
		_tmp28_ = self->priv->context;
		vala_code_context_add_external_package (_tmp28_, "glib-2.0");
		_tmp29_ = self->priv->context;
		vala_code_context_add_external_package (_tmp29_, "gobject-2.0");
		g_debug ("plugin.vala:174: standard packages added");
	} else {
		g_debug ("plugin.vala:176: standard packages already added");
	}
	_tmp30_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp30_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp31_ = current_target;
	_tmp32_ = anjuta_project_node_get_property (_tmp31_, "VALAFLAGS");
	prop = _tmp32_;
	_tmp34_ = prop;
	if (_tmp34_ != NULL) {
		AnjutaProjectProperty* _tmp35_ = NULL;
		AnjutaProjectProperty* _tmp36_ = NULL;
		AnjutaProjectPropertyInfo* _tmp37_ = NULL;
		AnjutaProjectProperty* _tmp38_ = NULL;
		_tmp35_ = prop;
		_tmp36_ = prop;
		_tmp37_ = _tmp36_->info;
		_tmp38_ = _tmp37_->default_value;
		_tmp33_ = _tmp35_ != _tmp38_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		AnjutaProjectProperty* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar** _tmp41_ = NULL;
		gint _tmp42_ = 0;
		_tmp39_ = prop;
		_tmp40_ = _tmp39_->value;
		g_shell_parse_argv (_tmp40_, &_tmp42_, &_tmp41_, &_inner_error_);
		flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
		flags = _tmp41_;
		flags_length1 = _tmp42_;
		_flags_size_ = flags_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (current_target);
			_g_object_unref0 (current_src);
			_g_object_unref0 (current_file);
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		AnjutaProjectNode* current_group = NULL;
		AnjutaProjectNode* _tmp43_ = NULL;
		AnjutaProjectNode* _tmp44_ = NULL;
		AnjutaProjectNode* _tmp45_ = NULL;
		AnjutaProjectNode* _tmp46_ = NULL;
		AnjutaProjectProperty* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		AnjutaProjectProperty* _tmp49_ = NULL;
		_tmp43_ = current_target;
		_tmp44_ = anjuta_project_node_parent_type (_tmp43_, ANJUTA_PROJECT_GROUP);
		_tmp45_ = _g_object_ref0 (_tmp44_);
		current_group = _tmp45_;
		_tmp46_ = current_group;
		_tmp47_ = anjuta_project_node_get_property (_tmp46_, "VALAFLAGS");
		prop = _tmp47_;
		_tmp49_ = prop;
		if (_tmp49_ != NULL) {
			AnjutaProjectProperty* _tmp50_ = NULL;
			AnjutaProjectProperty* _tmp51_ = NULL;
			AnjutaProjectPropertyInfo* _tmp52_ = NULL;
			AnjutaProjectProperty* _tmp53_ = NULL;
			_tmp50_ = prop;
			_tmp51_ = prop;
			_tmp52_ = _tmp51_->info;
			_tmp53_ = _tmp52_->default_value;
			_tmp48_ = _tmp50_ != _tmp53_;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			AnjutaProjectProperty* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			gchar** _tmp56_ = NULL;
			gint _tmp57_ = 0;
			_tmp54_ = prop;
			_tmp55_ = _tmp54_->value;
			g_shell_parse_argv (_tmp55_, &_tmp57_, &_tmp56_, &_inner_error_);
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			flags = _tmp56_;
			flags_length1 = _tmp57_;
			_flags_size_ = flags_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (current_group);
				flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (current_target);
				_g_object_unref0 (current_src);
				_g_object_unref0 (current_file);
				_g_object_unref0 (project);
				_g_object_unref0 (pm);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (current_group);
	}
	_tmp58_ = g_new0 (gchar*, 0 + 1);
	packages = _tmp58_;
	packages_length1 = 0;
	_packages_size_ = packages_length1;
	_tmp59_ = g_new0 (gchar*, 0 + 1);
	vapidirs = _tmp59_;
	vapidirs_length1 = 0;
	_vapidirs_size_ = vapidirs_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				gint _tmp62_ = 0;
				gchar** _tmp63_ = NULL;
				gint _tmp63__length1 = 0;
				gchar** _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				gint _tmp65_ = 0;
				const gchar* _tmp66_ = NULL;
				if (!_tmp60_) {
					gint _tmp61_ = 0;
					_tmp61_ = i;
					i = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = i;
				_tmp63_ = flags;
				_tmp63__length1 = flags_length1;
				if (!(_tmp62_ < _tmp63__length1)) {
					break;
				}
				_tmp64_ = flags;
				_tmp64__length1 = flags_length1;
				_tmp65_ = i;
				_tmp66_ = _tmp64_[_tmp65_];
				if (g_strcmp0 (_tmp66_, "--vapidir") == 0) {
					gchar** _tmp67_ = NULL;
					gint _tmp67__length1 = 0;
					gchar** _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					const gchar* _tmp71_ = NULL;
					gchar* _tmp72_ = NULL;
					_tmp67_ = vapidirs;
					_tmp67__length1 = vapidirs_length1;
					_tmp68_ = flags;
					_tmp68__length1 = flags_length1;
					_tmp69_ = i;
					i = _tmp69_ + 1;
					_tmp70_ = i;
					_tmp71_ = _tmp68_[_tmp70_];
					_tmp72_ = g_strdup (_tmp71_);
					_vala_array_add1 (&vapidirs, &vapidirs_length1, &_vapidirs_size_, _tmp72_);
				} else {
					gchar** _tmp73_ = NULL;
					gint _tmp73__length1 = 0;
					gint _tmp74_ = 0;
					const gchar* _tmp75_ = NULL;
					gboolean _tmp76_ = FALSE;
					_tmp73_ = flags;
					_tmp73__length1 = flags_length1;
					_tmp74_ = i;
					_tmp75_ = _tmp73_[_tmp74_];
					_tmp76_ = g_str_has_prefix (_tmp75_, "--vapidir=");
					if (_tmp76_) {
						gchar** _tmp77_ = NULL;
						gint _tmp77__length1 = 0;
						gchar** _tmp78_ = NULL;
						gint _tmp78__length1 = 0;
						gint _tmp79_ = 0;
						const gchar* _tmp80_ = NULL;
						gint _tmp81_ = 0;
						gint _tmp82_ = 0;
						gchar* _tmp83_ = NULL;
						_tmp77_ = vapidirs;
						_tmp77__length1 = vapidirs_length1;
						_tmp78_ = flags;
						_tmp78__length1 = flags_length1;
						_tmp79_ = i;
						_tmp80_ = _tmp78_[_tmp79_];
						_tmp81_ = strlen ("--vapidir=");
						_tmp82_ = _tmp81_;
						_tmp83_ = string_substring (_tmp80_, (glong) _tmp82_, (glong) -1);
						_vala_array_add2 (&vapidirs, &vapidirs_length1, &_vapidirs_size_, _tmp83_);
					} else {
						gchar** _tmp84_ = NULL;
						gint _tmp84__length1 = 0;
						gint _tmp85_ = 0;
						const gchar* _tmp86_ = NULL;
						_tmp84_ = flags;
						_tmp84__length1 = flags_length1;
						_tmp85_ = i;
						_tmp86_ = _tmp84_[_tmp85_];
						if (g_strcmp0 (_tmp86_, "--pkg") == 0) {
							gchar** _tmp87_ = NULL;
							gint _tmp87__length1 = 0;
							gchar** _tmp88_ = NULL;
							gint _tmp88__length1 = 0;
							gint _tmp89_ = 0;
							gint _tmp90_ = 0;
							const gchar* _tmp91_ = NULL;
							gchar* _tmp92_ = NULL;
							_tmp87_ = packages;
							_tmp87__length1 = packages_length1;
							_tmp88_ = flags;
							_tmp88__length1 = flags_length1;
							_tmp89_ = i;
							i = _tmp89_ + 1;
							_tmp90_ = i;
							_tmp91_ = _tmp88_[_tmp90_];
							_tmp92_ = g_strdup (_tmp91_);
							_vala_array_add3 (&packages, &packages_length1, &_packages_size_, _tmp92_);
						} else {
							gchar** _tmp93_ = NULL;
							gint _tmp93__length1 = 0;
							gint _tmp94_ = 0;
							const gchar* _tmp95_ = NULL;
							gboolean _tmp96_ = FALSE;
							_tmp93_ = flags;
							_tmp93__length1 = flags_length1;
							_tmp94_ = i;
							_tmp95_ = _tmp93_[_tmp94_];
							_tmp96_ = g_str_has_prefix (_tmp95_, "--pkg=");
							if (_tmp96_) {
								gchar** _tmp97_ = NULL;
								gint _tmp97__length1 = 0;
								gchar** _tmp98_ = NULL;
								gint _tmp98__length1 = 0;
								gint _tmp99_ = 0;
								const gchar* _tmp100_ = NULL;
								gint _tmp101_ = 0;
								gint _tmp102_ = 0;
								gchar* _tmp103_ = NULL;
								_tmp97_ = packages;
								_tmp97__length1 = packages_length1;
								_tmp98_ = flags;
								_tmp98__length1 = flags_length1;
								_tmp99_ = i;
								_tmp100_ = _tmp98_[_tmp99_];
								_tmp101_ = strlen ("--pkg=");
								_tmp102_ = _tmp101_;
								_tmp103_ = string_substring (_tmp100_, (glong) _tmp102_, (glong) -1);
								_vala_array_add4 (&packages, &packages_length1, &_packages_size_, _tmp103_);
							} else {
								gchar** _tmp104_ = NULL;
								gint _tmp104__length1 = 0;
								gint _tmp105_ = 0;
								const gchar* _tmp106_ = NULL;
								_tmp104_ = flags;
								_tmp104__length1 = flags_length1;
								_tmp105_ = i;
								_tmp106_ = _tmp104_[_tmp105_];
								g_debug ("plugin.vala:204: Unknown valac flag %s", _tmp106_);
							}
						}
					}
				}
			}
		}
	}
	_tmp107_ = current_target;
	_tmp108_ = anjuta_project_node_parent_type (_tmp107_, ANJUTA_PROJECT_GROUP);
	_tmp109_ = anjuta_project_node_get_file (_tmp108_);
	_tmp110_ = g_file_get_path (_tmp109_);
	srcdir = _tmp110_;
	_tmp112_ = project;
	_tmp113_ = ianjuta_project_get_root (_tmp112_, &_inner_error_);
	_tmp111_ = _tmp113_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (srcdir);
		vapidirs = (_vala_array_free (vapidirs, vapidirs_length1, (GDestroyNotify) g_free), NULL);
		packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
		flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (current_target);
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp114_ = anjuta_project_node_get_file (_tmp111_);
	_tmp115_ = g_file_get_path (_tmp114_);
	top_srcdir = _tmp115_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp116_ = FALSE;
			_tmp116_ = TRUE;
			while (TRUE) {
				gint _tmp118_ = 0;
				gchar** _tmp119_ = NULL;
				gint _tmp119__length1 = 0;
				gchar** _tmp120_ = NULL;
				gint _tmp120__length1 = 0;
				gint _tmp121_ = 0;
				gchar** _tmp122_ = NULL;
				gint _tmp122__length1 = 0;
				gint _tmp123_ = 0;
				const gchar* _tmp124_ = NULL;
				const gchar* _tmp125_ = NULL;
				gchar* _tmp126_ = NULL;
				gchar* _tmp127_ = NULL;
				const gchar* _tmp128_ = NULL;
				gchar* _tmp129_ = NULL;
				gchar* _tmp130_ = NULL;
				if (!_tmp116_) {
					gint _tmp117_ = 0;
					_tmp117_ = i;
					i = _tmp117_ + 1;
				}
				_tmp116_ = FALSE;
				_tmp118_ = i;
				_tmp119_ = vapidirs;
				_tmp119__length1 = vapidirs_length1;
				if (!(_tmp118_ < _tmp119__length1)) {
					break;
				}
				_tmp120_ = vapidirs;
				_tmp120__length1 = vapidirs_length1;
				_tmp121_ = i;
				_tmp122_ = vapidirs;
				_tmp122__length1 = vapidirs_length1;
				_tmp123_ = i;
				_tmp124_ = _tmp122_[_tmp123_];
				_tmp125_ = srcdir;
				_tmp126_ = string_replace (_tmp124_, "$(srcdir)", _tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = top_srcdir;
				_tmp129_ = string_replace (_tmp127_, "$(top_srcdir)", _tmp128_);
				_g_free0 (_tmp120_[_tmp121_]);
				_tmp120_[_tmp121_] = _tmp129_;
				_tmp130_ = _tmp120_[_tmp121_];
				_g_free0 (_tmp127_);
			}
		}
	}
	_tmp131_ = self->priv->context;
	_tmp132_ = vapidirs;
	_tmp132__length1 = vapidirs_length1;
	_tmp133_ = (_tmp132_ != NULL) ? _vala_array_dup1 (_tmp132_, _tmp132__length1) : ((gpointer) _tmp132_);
	_tmp133__length1 = _tmp132__length1;
	_tmp131_->vapi_directories = (_vala_array_free (_tmp131_->vapi_directories, _tmp131_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp131_->vapi_directories = _tmp133_;
	_tmp131_->vapi_directories_length1 = _tmp133__length1;
	_tmp134_ = packages;
	_tmp134__length1 = packages_length1;
	{
		gchar** pkg_collection = NULL;
		gint pkg_collection_length1 = 0;
		gint _pkg_collection_size_ = 0;
		gint pkg_it = 0;
		pkg_collection = _tmp134_;
		pkg_collection_length1 = _tmp134__length1;
		for (pkg_it = 0; pkg_it < _tmp134__length1; pkg_it = pkg_it + 1) {
			gchar* _tmp135_ = NULL;
			gchar* pkg = NULL;
			_tmp135_ = g_strdup (pkg_collection[pkg_it]);
			pkg = _tmp135_;
			{
				ValaCodeContext* _tmp136_ = NULL;
				const gchar* _tmp137_ = NULL;
				gboolean _tmp138_ = FALSE;
				_tmp136_ = self->priv->context;
				_tmp137_ = pkg;
				_tmp138_ = vala_code_context_has_package (_tmp136_, _tmp137_);
				if (_tmp138_) {
					const gchar* _tmp139_ = NULL;
					_tmp139_ = pkg;
					g_debug ("plugin.vala:217: package %s skipped", _tmp139_);
				} else {
					ValaCodeContext* _tmp140_ = NULL;
					const gchar* _tmp141_ = NULL;
					gboolean _tmp142_ = FALSE;
					_tmp140_ = self->priv->context;
					_tmp141_ = pkg;
					_tmp142_ = vala_code_context_add_external_package (_tmp140_, _tmp141_);
					if (_tmp142_) {
						const gchar* _tmp143_ = NULL;
						_tmp143_ = pkg;
						g_debug ("plugin.vala:219: package %s added", _tmp143_);
					} else {
						const gchar* _tmp144_ = NULL;
						_tmp144_ = pkg;
						g_debug ("plugin.vala:221: package %s not found", _tmp144_);
					}
				}
				_g_free0 (pkg);
			}
		}
	}
	vala_code_context_pop ();
	_g_free0 (top_srcdir);
	_g_free0 (srcdir);
	vapidirs = (_vala_array_free (vapidirs, vapidirs_length1, (GDestroyNotify) g_free), NULL);
	packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (current_target);
	_g_object_unref0 (current_src);
	_g_object_unref0 (current_file);
	_g_object_unref0 (project);
	_g_object_unref0 (pm);
}


void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e) {
	ValaCodeContext* _tmp0_ = NULL;
	IAnjutaProjectManager* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pm != NULL);
	_tmp0_ = self->priv->context;
	if (_tmp0_ == NULL) {
		return;
	}
	vala_plugin_add_project_files (self);
	vala_plugin_parse (self);
	_tmp1_ = pm;
	_tmp2_ = self->priv->project_loaded_id;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	self->priv->project_loaded_id = (gulong) 0;
}


static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self) {
	vala_plugin_on_project_loaded ((ValaPlugin*) self, _sender, _error_);
}


static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self) {
	vala_plugin_on_char_added ((ValaPlugin*) self, _sender, position, ch);
}


static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self) {
	vala_plugin_on_file_saved ((ValaPlugin*) self, _sender, file);
}


static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self) {
	gboolean result;
	result = vala_plugin_on_drop_possible ((ValaPlugin*) self, _sender, iterator);
	return result;
}


static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self) {
	vala_plugin_on_drop ((ValaPlugin*) self, _sender, iterator, signal_data);
}


static void _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add (IAnjutaEditor* _sender, const gchar* widget_typename, const gchar* widget_name, const gchar* filename, gpointer self) {
	vala_plugin_insert_member_decl_and_init ((ValaPlugin*) self, _sender, widget_typename, widget_name, filename);
}


void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value) {
	IAnjutaEditor* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	IAnjutaFile* current_file = NULL;
	GObject* _tmp3_ = NULL;
	IAnjutaFile* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	AnjutaShell* _tmp6_ = NULL;
	AnjutaShell* _tmp7_ = NULL;
	AnjutaShell* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	IAnjutaProjectManager* pm = NULL;
	IAnjutaProjectManager* _tmp11_ = NULL;
	IAnjutaProject* project = NULL;
	IAnjutaProjectManager* _tmp12_ = NULL;
	IAnjutaProject* _tmp13_ = NULL;
	IAnjutaProject* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	IAnjutaProject* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	IAnjutaEditor* _tmp33_ = NULL;
	AnjutaReport* _tmp49_ = NULL;
	IAnjutaEditor* _tmp50_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("plugin.vala:238: editor value added");
	_tmp0_ = self->current_editor;
	_vala_assert (_tmp0_ == NULL, "current_editor == null");
	_tmp1_ = g_value_get_object (value);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ianjuta_editor_get_type ())) {
		return;
	}
	_tmp2_ = g_value_get_object (value);
	self->current_editor = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, ianjuta_editor_get_type ()) ? ((IAnjutaEditor*) _tmp2_) : NULL;
	_tmp3_ = g_value_get_object (value);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, ianjuta_file_get_type ()) ? ((IAnjutaFile*) _tmp3_) : NULL);
	current_file = _tmp4_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = anjuta_shell_get_object (_tmp8_, "IAnjutaProjectManager", &_inner_error_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_tmp5_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, ianjuta_project_manager_get_type (), IAnjutaProjectManager));
	pm = _tmp11_;
	_tmp12_ = pm;
	_tmp13_ = ianjuta_project_manager_get_current_project (_tmp12_, &_inner_error_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	project = _tmp14_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = project;
	_tmp17_ = ianjuta_project_is_loaded (_tmp16_, &_inner_error_);
	_tmp15_ = _tmp17_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (!_tmp15_) {
		gulong _tmp18_ = 0UL;
		_tmp18_ = self->priv->project_loaded_id;
		if (_tmp18_ == ((gulong) 0)) {
			IAnjutaProjectManager* _tmp19_ = NULL;
			gulong _tmp20_ = 0UL;
			_tmp19_ = pm;
			_tmp20_ = g_signal_connect_object (_tmp19_, "project-loaded", (GCallback) _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded, self, 0);
			self->priv->project_loaded_id = _tmp20_;
		}
	} else {
		GFile* cur_gfile = NULL;
		IAnjutaFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		ValaSet* _tmp24_ = NULL;
		GFile* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp21_ = current_file;
		_tmp22_ = ianjuta_file_get_file (_tmp21_, &_inner_error_);
		cur_gfile = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = cur_gfile;
		if (_tmp23_ == NULL) {
			_g_object_unref0 (cur_gfile);
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			return;
		}
		_tmp24_ = self->priv->current_sources;
		_tmp25_ = cur_gfile;
		_tmp26_ = g_file_get_path (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_contains ((ValaCollection*) _tmp24_, _tmp27_);
		_tmp29_ = !_tmp28_;
		_g_free0 (_tmp27_);
		if (_tmp29_) {
			GCancellable* _tmp30_ = NULL;
			_tmp30_ = self->priv->cancel;
			g_cancellable_cancel (_tmp30_);
			{
				ValaCodeContext* _tmp31_ = NULL;
				_tmp31_ = self->priv->context;
				g_static_rec_mutex_lock (&self->priv->__lock_context);
				{
					vala_plugin_init_context (self);
					vala_plugin_add_project_files (self);
				}
				__finally4:
				{
					ValaCodeContext* _tmp32_ = NULL;
					_tmp32_ = self->priv->context;
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (cur_gfile);
					_g_object_unref0 (project);
					_g_object_unref0 (pm);
					_g_object_unref0 (current_file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_plugin_parse (self);
		}
		_g_object_unref0 (cur_gfile);
	}
	_tmp33_ = self->current_editor;
	if (_tmp33_ != NULL) {
		IAnjutaEditor* _tmp34_ = NULL;
		IAnjutaEditor* _tmp37_ = NULL;
		IAnjutaEditor* _tmp39_ = NULL;
		IAnjutaEditor* _tmp43_ = NULL;
		IAnjutaEditor* _tmp48_ = NULL;
		_tmp34_ = self->current_editor;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, ianjuta_editor_assist_get_type ())) {
			IAnjutaEditor* _tmp35_ = NULL;
			ValaProvider* _tmp36_ = NULL;
			_tmp35_ = self->current_editor;
			_tmp36_ = self->priv->provider;
			ianjuta_editor_assist_add (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, ianjuta_editor_assist_get_type ()) ? ((IAnjutaEditorAssist*) _tmp35_) : NULL, (IAnjutaProvider*) _tmp36_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (project);
				_g_object_unref0 (pm);
				_g_object_unref0 (current_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp37_ = self->current_editor;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, ianjuta_editor_tip_get_type ())) {
			IAnjutaEditor* _tmp38_ = NULL;
			_tmp38_ = self->current_editor;
			g_signal_connect_object (_tmp38_, "char-added", (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self, 0);
		}
		_tmp39_ = self->current_editor;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, ianjuta_file_savable_get_type ())) {
			IAnjutaFileSavable* file_savable = NULL;
			IAnjutaEditor* _tmp40_ = NULL;
			IAnjutaFileSavable* _tmp41_ = NULL;
			IAnjutaFileSavable* _tmp42_ = NULL;
			_tmp40_ = self->current_editor;
			_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, ianjuta_file_savable_get_type (), IAnjutaFileSavable));
			file_savable = _tmp41_;
			_tmp42_ = file_savable;
			g_signal_connect_object (_tmp42_, "saved", (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self, 0);
			_g_object_unref0 (file_savable);
		}
		_tmp43_ = self->current_editor;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, ianjuta_editor_glade_signal_get_type ())) {
			IAnjutaEditorGladeSignal* gladesig = NULL;
			IAnjutaEditor* _tmp44_ = NULL;
			IAnjutaEditorGladeSignal* _tmp45_ = NULL;
			IAnjutaEditorGladeSignal* _tmp46_ = NULL;
			IAnjutaEditorGladeSignal* _tmp47_ = NULL;
			_tmp44_ = self->current_editor;
			_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, ianjuta_editor_glade_signal_get_type ()) ? ((IAnjutaEditorGladeSignal*) _tmp44_) : NULL);
			gladesig = _tmp45_;
			_tmp46_ = gladesig;
			g_signal_connect_object (_tmp46_, "drop-possible", (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self, 0);
			_tmp47_ = gladesig;
			g_signal_connect_object (_tmp47_, "drop", (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self, 0);
			_g_object_unref0 (gladesig);
		}
		_tmp48_ = self->current_editor;
		g_signal_connect_object (_tmp48_, "glade-member-add", (GCallback) _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add, self, 0);
	}
	_tmp49_ = self->priv->report;
	_tmp50_ = self->current_editor;
	anjuta_report_update_errors (_tmp49_, _tmp50_);
	_g_object_unref0 (project);
	_g_object_unref0 (pm);
	_g_object_unref0 (current_file);
}


void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name) {
	IAnjutaEditor* _tmp0_ = NULL;
	IAnjutaEditor* _tmp3_ = NULL;
	IAnjutaEditor* _tmp6_ = NULL;
	IAnjutaEditor* _tmp11_ = NULL;
	IAnjutaEditor* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("plugin.vala:290: editor value removed");
	_tmp0_ = self->current_editor;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, ianjuta_editor_assist_get_type ())) {
		IAnjutaEditor* _tmp1_ = NULL;
		ValaProvider* _tmp2_ = NULL;
		_tmp1_ = self->current_editor;
		_tmp2_ = self->priv->provider;
		ianjuta_editor_assist_remove (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ianjuta_editor_assist_get_type ()) ? ((IAnjutaEditorAssist*) _tmp1_) : NULL, (IAnjutaProvider*) _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->current_editor;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, ianjuta_editor_tip_get_type ())) {
		IAnjutaEditor* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		_tmp4_ = self->current_editor;
		g_signal_parse_name ("char-added", ianjuta_editor_get_type (), &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self);
	}
	_tmp6_ = self->current_editor;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, ianjuta_file_savable_get_type ())) {
		IAnjutaFileSavable* file_savable = NULL;
		IAnjutaEditor* _tmp7_ = NULL;
		IAnjutaFileSavable* _tmp8_ = NULL;
		IAnjutaFileSavable* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp7_ = self->current_editor;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, ianjuta_file_savable_get_type (), IAnjutaFileSavable));
		file_savable = _tmp8_;
		_tmp9_ = file_savable;
		g_signal_parse_name ("saved", ianjuta_file_savable_get_type (), &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self);
		_g_object_unref0 (file_savable);
	}
	_tmp11_ = self->current_editor;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, ianjuta_editor_glade_signal_get_type ())) {
		IAnjutaEditorGladeSignal* gladesig = NULL;
		IAnjutaEditor* _tmp12_ = NULL;
		IAnjutaEditorGladeSignal* _tmp13_ = NULL;
		IAnjutaEditorGladeSignal* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		IAnjutaEditorGladeSignal* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		_tmp12_ = self->current_editor;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, ianjuta_editor_glade_signal_get_type ()) ? ((IAnjutaEditorGladeSignal*) _tmp12_) : NULL);
		gladesig = _tmp13_;
		_tmp14_ = gladesig;
		g_signal_parse_name ("drop-possible", ianjuta_editor_glade_signal_get_type (), &_tmp15_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self);
		_tmp16_ = gladesig;
		g_signal_parse_name ("drop", ianjuta_editor_glade_signal_get_type (), &_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self);
		_g_object_unref0 (gladesig);
	}
	_tmp18_ = self->current_editor;
	g_signal_parse_name ("glade-member-add", ianjuta_editor_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add, self);
	self->current_editor = NULL;
}


void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (savable != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_ = NULL;
		ValaList* _tmp1_ = NULL;
		gint _source_file_size = 0;
		ValaList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ValaSourceFile* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GFile* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			guint8* contents = NULL;
			gint contents_length1 = 0;
			gint _contents_size_ = 0;
			_tmp5_ = _source_file_index;
			_source_file_index = _tmp5_ + 1;
			_tmp6_ = _source_file_index;
			_tmp7_ = _source_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _source_file_list;
			_tmp9_ = _source_file_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			source_file = (ValaSourceFile*) _tmp10_;
			_tmp11_ = source_file;
			_tmp12_ = vala_source_file_get_filename (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = file;
			_tmp15_ = g_file_get_path (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				_vala_source_file_unref0 (source_file);
				continue;
			}
			{
				GFile* _tmp18_ = NULL;
				guint8* _tmp19_ = NULL;
				gsize _tmp20_;
				ValaSourceFile* _tmp21_ = NULL;
				ValaSourceFile* _tmp22_ = NULL;
				_tmp18_ = file;
				g_file_load_contents (_tmp18_, NULL, &_tmp19_, &_tmp20_, NULL, &_inner_error_);
				contents = (g_free (contents), NULL);
				contents = _tmp19_;
				contents_length1 = _tmp20_;
				_contents_size_ = contents_length1;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
				_tmp21_ = source_file;
				vala_source_file_set_content (_tmp21_, (const gchar*) contents);
				_tmp22_ = source_file;
				vala_plugin_update_file (self, _tmp22_);
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally5:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				contents = (g_free (contents), NULL);
				_vala_source_file_unref0 (source_file);
				_vala_iterable_unref0 (_source_file_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			contents = (g_free (contents), NULL);
			_vala_source_file_unref0 (source_file);
			_vala_iterable_unref0 (_source_file_list);
			return;
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	IAnjutaEditorTip* editortip = NULL;
	IAnjutaEditor* _tmp2_ = NULL;
	IAnjutaEditorTip* _tmp3_ = NULL;
	gchar _tmp4_ = '\0';
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	_tmp0_ = self->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, VALA_PROVIDER_PREF_CALLTIP_ENABLE);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = editor;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, ianjuta_editor_tip_get_type ()) ? ((IAnjutaEditorTip*) _tmp2_) : NULL);
	editortip = _tmp3_;
	_tmp4_ = ch;
	if (_tmp4_ == '(') {
		ValaProvider* _tmp5_ = NULL;
		IAnjutaEditorTip* _tmp6_ = NULL;
		_tmp5_ = self->priv->provider;
		_tmp6_ = editortip;
		vala_provider_show_call_tip (_tmp5_, _tmp6_);
	} else {
		gchar _tmp7_ = '\0';
		_tmp7_ = ch;
		if (_tmp7_ == ')') {
			IAnjutaEditorTip* _tmp8_ = NULL;
			_tmp8_ = editortip;
			ianjuta_editor_tip_cancel (_tmp8_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (editortip);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (editortip);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	gint depth = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	g_return_val_if_fail (position != NULL, NULL);
	depth = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar* current_char = NULL;
			IAnjutaIterable* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				IAnjutaIterable* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = position;
				_tmp3_ = ianjuta_iterable_previous (_tmp2_, &_inner_error_);
				_tmp1_ = _tmp3_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp4_ = position;
			_tmp5_ = ianjuta_editor_cell_get_character (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, ianjuta_editor_cell_get_type ()) ? ((IAnjutaEditorCell*) _tmp4_) : NULL, &_inner_error_);
			current_char = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp6_ = current_char;
			if (g_strcmp0 (_tmp6_, "}") == 0) {
				gint _tmp7_ = 0;
				_tmp7_ = depth;
				depth = _tmp7_ + 1;
			} else {
				const gchar* _tmp8_ = NULL;
				_tmp8_ = current_char;
				if (g_strcmp0 (_tmp8_, "{") == 0) {
					gint _tmp9_ = 0;
					_tmp9_ = depth;
					if (_tmp9_ > 0) {
						gint _tmp10_ = 0;
						_tmp10_ = depth;
						depth = _tmp10_ - 1;
					} else {
						IAnjutaEditor* _tmp20_ = NULL;
						IAnjutaIterable* _tmp21_ = NULL;
						ValaSymbol* _tmp22_ = NULL;
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								IAnjutaIterable* _tmp15_ = NULL;
								gchar* _tmp16_ = NULL;
								IAnjutaIterable* _tmp17_ = NULL;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								if (!_tmp11_) {
									const gchar* _tmp12_ = NULL;
									gunichar _tmp13_ = 0U;
									gboolean _tmp14_ = FALSE;
									_tmp12_ = current_char;
									_tmp13_ = string_get_char (_tmp12_, (glong) 0);
									_tmp14_ = g_unichar_isalnum (_tmp13_);
									if (!(!_tmp14_)) {
										break;
									}
								}
								_tmp11_ = FALSE;
								_tmp15_ = position;
								ianjuta_iterable_previous (_tmp15_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp17_ = position;
								_tmp18_ = ianjuta_editor_cell_get_character (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, ianjuta_editor_cell_get_type ()) ? ((IAnjutaEditorCell*) _tmp17_) : NULL, &_inner_error_);
								_tmp16_ = _tmp18_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp19_ = _tmp16_;
								_tmp16_ = NULL;
								_g_free0 (current_char);
								current_char = _tmp19_;
								_g_free0 (_tmp16_);
							}
						}
						_tmp20_ = editor;
						_tmp21_ = position;
						_tmp22_ = vala_plugin_get_current_context (self, _tmp20_, _tmp21_);
						result = _tmp22_;
						_g_free0 (current_char);
						return result;
					}
				}
			}
			_g_free0 (current_char);
		}
	}
	result = NULL;
	return result;
}


gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position) {
	gboolean result = FALSE;
	gint line = 0;
	IAnjutaEditorGladeSignal* _tmp0_ = NULL;
	IAnjutaIterable* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	IAnjutaIterable* _tmp3_ = NULL;
	IAnjutaEditorGladeSignal* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	IAnjutaIterable* _tmp6_ = NULL;
	gint column = 0;
	IAnjutaIterable* _tmp7_ = NULL;
	IAnjutaIterable* _tmp8_ = NULL;
	IAnjutaIterable* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	IAnjutaIterable* _tmp14_ = NULL;
	IAnjutaIterable* _tmp15_ = NULL;
	IAnjutaIterable* _tmp16_ = NULL;
	ValaSymbol* scope = NULL;
	IAnjutaEditorGladeSignal* _tmp17_ = NULL;
	ValaSymbol* _tmp18_ = NULL;
	ValaSymbol* _tmp19_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	ValaSymbol* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (editor != NULL, FALSE);
	g_return_val_if_fail (position != NULL, FALSE);
	_tmp0_ = editor;
	_tmp1_ = position;
	_tmp2_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) _tmp0_, _tmp1_, &_inner_error_);
	line = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = editor;
	_tmp5_ = line;
	_tmp6_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) _tmp4_, _tmp5_, &_inner_error_);
	_tmp3_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = _tmp3_;
	_tmp3_ = NULL;
	_tmp8_ = _tmp7_;
	_tmp9_ = position;
	_tmp10_ = ianjuta_iterable_diff (_tmp8_, _tmp9_, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp8_);
	column = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (_tmp3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp12_ = line;
	_tmp13_ = column;
	g_debug ("plugin.vala:365: line %d, column %d", _tmp12_, _tmp13_);
	_tmp15_ = position;
	_tmp16_ = ianjuta_iterable_clone (_tmp15_, &_inner_error_);
	_tmp14_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (_tmp3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp17_ = editor;
	_tmp18_ = vala_plugin_get_scope (self, (IAnjutaEditor*) _tmp17_, _tmp14_);
	scope = _tmp18_;
	_tmp19_ = scope;
	if (_tmp19_ != NULL) {
		ValaSymbol* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp20_ = scope;
		_tmp21_ = vala_symbol_get_full_name (_tmp20_);
		_tmp22_ = _tmp21_;
		g_debug ("plugin.vala:369: drag is inside %s", _tmp22_);
		_g_free0 (_tmp22_);
	}
	_tmp25_ = scope;
	if (_tmp25_ == NULL) {
		_tmp24_ = TRUE;
	} else {
		ValaSymbol* _tmp26_ = NULL;
		_tmp26_ = scope;
		_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_NAMESPACE);
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		ValaSymbol* _tmp27_ = NULL;
		_tmp27_ = scope;
		_tmp23_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_CLASS);
	}
	if (_tmp23_) {
		result = TRUE;
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (_tmp3_);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (scope);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp3_);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data) {
	gchar** data = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	gchar* widget_name = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* signal_name = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* handler_name = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean swapped = FALSE;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	IAnjutaIterable* _tmp14_ = NULL;
	IAnjutaIterable* _tmp15_ = NULL;
	IAnjutaIterable* _tmp16_ = NULL;
	ValaSymbol* scope = NULL;
	IAnjutaEditorGladeSignal* _tmp17_ = NULL;
	ValaSymbol* _tmp18_ = NULL;
	GString* builder = NULL;
	GString* _tmp19_ = NULL;
	gchar* scope_prefix = NULL;
	gchar* _tmp20_ = NULL;
	ValaSymbol* _tmp21_ = NULL;
	gchar* handler_cname = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	ValaSymbol* widget = NULL;
	const gchar* _tmp51_ = NULL;
	ValaCodeContext* _tmp52_ = NULL;
	ValaNamespace* _tmp53_ = NULL;
	ValaNamespace* _tmp54_ = NULL;
	ValaSymbol* _tmp55_ = NULL;
	GList* sigs = NULL;
	ValaSymbol* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GList* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	GList* _tmp60_ = NULL;
	ValaSignal* sig = NULL;
	GList* _tmp63_ = NULL;
	gconstpointer _tmp64_ = NULL;
	ValaSignal* _tmp65_ = NULL;
	GString* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	GString* _tmp121_ = NULL;
	IAnjutaEditorGladeSignal* _tmp122_ = NULL;
	IAnjutaIterable* _tmp123_ = NULL;
	GString* _tmp124_ = NULL;
	const gchar* _tmp125_ = NULL;
	GObject* _tmp126_ = NULL;
	AnjutaShell* _tmp127_ = NULL;
	AnjutaShell* _tmp128_ = NULL;
	AnjutaShell* _tmp129_ = NULL;
	GObject* _tmp130_ = NULL;
	GObject* _tmp131_ = NULL;
	IAnjutaIndenter* indenter = NULL;
	IAnjutaIndenter* _tmp132_ = NULL;
	IAnjutaIndenter* _tmp133_ = NULL;
	gint _tmp146_ = 0;
	IAnjutaEditorGladeSignal* _tmp147_ = NULL;
	IAnjutaIterable* _tmp148_ = NULL;
	gint _tmp149_ = 0;
	IAnjutaIterable* inside = NULL;
	IAnjutaEditorGladeSignal* _tmp150_ = NULL;
	IAnjutaIterable* _tmp151_ = NULL;
	IAnjutaEditorGladeSignal* _tmp152_ = NULL;
	IAnjutaIterable* _tmp153_ = NULL;
	IAnjutaIndenter* _tmp154_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	g_return_if_fail (signal_data != NULL);
	_tmp0_ = signal_data;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 0);
	data = _tmp2_;
	data_length1 = _vala_array_length (_tmp1_);
	_data_size_ = data_length1;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	widget_name = _tmp5_;
	_tmp6_ = data;
	_tmp6__length1 = data_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = string_replace (_tmp7_, "-", "_");
	signal_name = _tmp8_;
	_tmp9_ = data;
	_tmp9__length1 = data_length1;
	_tmp10_ = _tmp9_[2];
	_tmp11_ = g_strdup (_tmp10_);
	handler_name = _tmp11_;
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_tmp13_ = _tmp12_[4];
	swapped = g_strcmp0 (_tmp13_, "1") == 0;
	_tmp15_ = position;
	_tmp16_ = ianjuta_iterable_clone (_tmp15_, &_inner_error_);
	_tmp14_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = editor;
	_tmp18_ = vala_plugin_get_scope (self, (IAnjutaEditor*) _tmp17_, _tmp14_);
	scope = _tmp18_;
	_tmp19_ = g_string_new ("");
	builder = _tmp19_;
	_tmp20_ = g_strdup ("");
	scope_prefix = _tmp20_;
	_tmp21_ = scope;
	if (_tmp21_ != NULL) {
		ValaSymbol* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		_tmp22_ = scope;
		_tmp23_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp22_);
		_g_free0 (scope_prefix);
		scope_prefix = _tmp23_;
		_tmp24_ = handler_name;
		_tmp25_ = scope_prefix;
		_tmp26_ = g_str_has_prefix (_tmp24_, _tmp25_);
		if (_tmp26_) {
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gchar* _tmp31_ = NULL;
			_tmp27_ = handler_name;
			_tmp28_ = scope_prefix;
			_tmp29_ = strlen (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = string_substring (_tmp27_, (glong) _tmp30_, (glong) -1);
			_g_free0 (handler_name);
			handler_name = _tmp31_;
		}
	}
	_tmp32_ = scope_prefix;
	_tmp33_ = handler_name;
	_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
	handler_cname = _tmp34_;
	_tmp36_ = data;
	_tmp36__length1 = data_length1;
	_tmp37_ = _tmp36_[2];
	_tmp38_ = handler_cname;
	if (g_strcmp0 (_tmp37_, _tmp38_) != 0) {
		gboolean _tmp39_ = FALSE;
		_tmp39_ = swapped;
		_tmp35_ = !_tmp39_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GString* _tmp40_ = NULL;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		const gchar* _tmp42_ = NULL;
		_tmp40_ = builder;
		_tmp41_ = data;
		_tmp41__length1 = data_length1;
		_tmp42_ = _tmp41_[2];
		g_string_append_printf (_tmp40_, "[CCode (cname=\"%s\", instance_pos=-1)]\n", _tmp42_);
	} else {
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		_tmp43_ = data;
		_tmp43__length1 = data_length1;
		_tmp44_ = _tmp43_[2];
		_tmp45_ = handler_cname;
		if (g_strcmp0 (_tmp44_, _tmp45_) != 0) {
			GString* _tmp46_ = NULL;
			gchar** _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			const gchar* _tmp48_ = NULL;
			_tmp46_ = builder;
			_tmp47_ = data;
			_tmp47__length1 = data_length1;
			_tmp48_ = _tmp47_[2];
			g_string_append_printf (_tmp46_, "[CCode (cname=\"%s\")]\n", _tmp48_);
		} else {
			gboolean _tmp49_ = FALSE;
			_tmp49_ = swapped;
			if (!_tmp49_) {
				GString* _tmp50_ = NULL;
				_tmp50_ = builder;
				g_string_append (_tmp50_, "[CCode (instance_pos=-1)]\n");
			}
		}
	}
	_tmp51_ = widget_name;
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_code_context_get_root (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_plugin_lookup_symbol_by_cname (self, _tmp51_, (ValaSymbol*) _tmp54_);
	widget = _tmp55_;
	_tmp56_ = widget;
	_tmp57_ = signal_name;
	_tmp58_ = vala_plugin_symbol_lookup_inherited (self, _tmp56_, _tmp57_, FALSE, FALSE);
	sigs = _tmp58_;
	_tmp60_ = sigs;
	if (_tmp60_ == NULL) {
		_tmp59_ = TRUE;
	} else {
		GList* _tmp61_ = NULL;
		gconstpointer _tmp62_ = NULL;
		_tmp61_ = sigs;
		_tmp62_ = _tmp61_->data;
		_tmp59_ = !G_TYPE_CHECK_INSTANCE_TYPE ((ValaSymbol*) _tmp62_, VALA_TYPE_SIGNAL);
	}
	if (_tmp59_) {
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp63_ = sigs;
	_tmp64_ = _tmp63_->data;
	_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp64_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp65_;
	_tmp66_ = builder;
	_tmp67_ = handler_name;
	g_string_append_printf (_tmp66_, "public void %s (", _tmp67_);
	_tmp68_ = swapped;
	if (_tmp68_) {
		GString* _tmp69_ = NULL;
		ValaSymbol* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		_tmp69_ = builder;
		_tmp70_ = widget;
		_tmp71_ = vala_symbol_get_full_name (_tmp70_);
		_tmp72_ = _tmp71_;
		g_string_append_printf (_tmp69_, "%s sender", _tmp72_);
		_g_free0 (_tmp72_);
		{
			ValaList* _param_list = NULL;
			ValaSignal* _tmp73_ = NULL;
			ValaList* _tmp74_ = NULL;
			gint _param_size = 0;
			ValaList* _tmp75_ = NULL;
			gint _tmp76_ = 0;
			gint _tmp77_ = 0;
			gint _param_index = 0;
			_tmp73_ = sig;
			_tmp74_ = vala_signal_get_parameters (_tmp73_);
			_param_list = _tmp74_;
			_tmp75_ = _param_list;
			_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
			_tmp77_ = _tmp76_;
			_param_size = _tmp77_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				ValaParameter* param = NULL;
				ValaList* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gpointer _tmp83_ = NULL;
				GString* _tmp84_ = NULL;
				ValaParameter* _tmp85_ = NULL;
				ValaDataType* _tmp86_ = NULL;
				ValaDataType* _tmp87_ = NULL;
				ValaTypeSymbol* _tmp88_ = NULL;
				ValaTypeSymbol* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				gchar* _tmp91_ = NULL;
				ValaParameter* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				_tmp78_ = _param_index;
				_param_index = _tmp78_ + 1;
				_tmp79_ = _param_index;
				_tmp80_ = _param_size;
				if (!(_tmp79_ < _tmp80_)) {
					break;
				}
				_tmp81_ = _param_list;
				_tmp82_ = _param_index;
				_tmp83_ = vala_list_get (_tmp81_, _tmp82_);
				param = (ValaParameter*) _tmp83_;
				_tmp84_ = builder;
				_tmp85_ = param;
				_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) _tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_data_type_get_data_type (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = param;
				_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
				_tmp94_ = _tmp93_;
				g_string_append_printf (_tmp84_, ", %s %s", _tmp91_, _tmp94_);
				_g_free0 (_tmp91_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	} else {
		GString* _tmp117_ = NULL;
		ValaSymbol* _tmp118_ = NULL;
		gchar* _tmp119_ = NULL;
		gchar* _tmp120_ = NULL;
		{
			ValaList* _param_list = NULL;
			ValaSignal* _tmp95_ = NULL;
			ValaList* _tmp96_ = NULL;
			gint _param_size = 0;
			ValaList* _tmp97_ = NULL;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			gint _param_index = 0;
			_tmp95_ = sig;
			_tmp96_ = vala_signal_get_parameters (_tmp95_);
			_param_list = _tmp96_;
			_tmp97_ = _param_list;
			_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
			_tmp99_ = _tmp98_;
			_param_size = _tmp99_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp100_ = 0;
				gint _tmp101_ = 0;
				gint _tmp102_ = 0;
				ValaParameter* param = NULL;
				ValaList* _tmp103_ = NULL;
				gint _tmp104_ = 0;
				gpointer _tmp105_ = NULL;
				GString* _tmp106_ = NULL;
				ValaParameter* _tmp107_ = NULL;
				ValaDataType* _tmp108_ = NULL;
				ValaDataType* _tmp109_ = NULL;
				ValaTypeSymbol* _tmp110_ = NULL;
				ValaTypeSymbol* _tmp111_ = NULL;
				gchar* _tmp112_ = NULL;
				gchar* _tmp113_ = NULL;
				ValaParameter* _tmp114_ = NULL;
				const gchar* _tmp115_ = NULL;
				const gchar* _tmp116_ = NULL;
				_tmp100_ = _param_index;
				_param_index = _tmp100_ + 1;
				_tmp101_ = _param_index;
				_tmp102_ = _param_size;
				if (!(_tmp101_ < _tmp102_)) {
					break;
				}
				_tmp103_ = _param_list;
				_tmp104_ = _param_index;
				_tmp105_ = vala_list_get (_tmp103_, _tmp104_);
				param = (ValaParameter*) _tmp105_;
				_tmp106_ = builder;
				_tmp107_ = param;
				_tmp108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_data_type_get_data_type (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = param;
				_tmp115_ = vala_symbol_get_name ((ValaSymbol*) _tmp114_);
				_tmp116_ = _tmp115_;
				g_string_append_printf (_tmp106_, "%s %s, ", _tmp113_, _tmp116_);
				_g_free0 (_tmp113_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp117_ = builder;
		_tmp118_ = widget;
		_tmp119_ = vala_symbol_get_full_name (_tmp118_);
		_tmp120_ = _tmp119_;
		g_string_append_printf (_tmp117_, "%s sender", _tmp120_);
		_g_free0 (_tmp120_);
	}
	_tmp121_ = builder;
	g_string_append_printf (_tmp121_, ") {\n\n}\n");
	_tmp122_ = editor;
	_tmp123_ = position;
	_tmp124_ = builder;
	_tmp125_ = _tmp124_->str;
	ianjuta_editor_insert ((IAnjutaEditor*) _tmp122_, _tmp123_, _tmp125_, -1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp127_, NULL);
	_tmp128_ = _tmp127_;
	_tmp129_ = _tmp128_;
	_tmp130_ = anjuta_shell_get_object (_tmp129_, "IAnjutaIndenter", &_inner_error_);
	_tmp131_ = _tmp130_;
	_g_object_unref0 (_tmp129_);
	_tmp126_ = _tmp131_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp132_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, ianjuta_indenter_get_type ()) ? ((IAnjutaIndenter*) _tmp126_) : NULL);
	indenter = _tmp132_;
	_tmp133_ = indenter;
	if (_tmp133_ != NULL) {
		IAnjutaIterable* end = NULL;
		IAnjutaIterable* _tmp134_ = NULL;
		IAnjutaIterable* _tmp135_ = NULL;
		gint _tmp136_ = 0;
		IAnjutaIterable* _tmp137_ = NULL;
		gint _tmp138_ = 0;
		IAnjutaIterable* _tmp139_ = NULL;
		GString* _tmp140_ = NULL;
		const gchar* _tmp141_ = NULL;
		gint _tmp142_ = 0;
		IAnjutaIndenter* _tmp143_ = NULL;
		IAnjutaIterable* _tmp144_ = NULL;
		IAnjutaIterable* _tmp145_ = NULL;
		_tmp134_ = position;
		_tmp135_ = ianjuta_iterable_clone (_tmp134_, &_inner_error_);
		end = _tmp135_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_object_unref0 (_tmp14_);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp137_ = end;
		_tmp138_ = ianjuta_iterable_get_position (_tmp137_, &_inner_error_);
		_tmp136_ = _tmp138_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_object_unref0 (_tmp14_);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp139_ = end;
		_tmp140_ = builder;
		_tmp141_ = _tmp140_->str;
		_tmp142_ = g_utf8_strlen (_tmp141_, (gssize) -1);
		ianjuta_iterable_set_position (_tmp139_, (_tmp136_ + _tmp142_) - 1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_object_unref0 (_tmp14_);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp143_ = indenter;
		_tmp144_ = position;
		_tmp145_ = end;
		ianjuta_indenter_indent (_tmp143_, _tmp144_, _tmp145_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_object_unref0 (_tmp14_);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (end);
	}
	_tmp147_ = editor;
	_tmp148_ = position;
	_tmp149_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) _tmp147_, _tmp148_, &_inner_error_);
	_tmp146_ = _tmp149_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp150_ = editor;
	_tmp151_ = ianjuta_editor_get_line_end_position ((IAnjutaEditor*) _tmp150_, _tmp146_ + 2, &_inner_error_);
	inside = _tmp151_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp152_ = editor;
	_tmp153_ = inside;
	ianjuta_editor_goto_position ((IAnjutaEditor*) _tmp152_, _tmp153_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (inside);
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_object_unref0 (_tmp14_);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp154_ = indenter;
	if (_tmp154_ != NULL) {
		IAnjutaIndenter* _tmp155_ = NULL;
		IAnjutaIterable* _tmp156_ = NULL;
		IAnjutaIterable* _tmp157_ = NULL;
		_tmp155_ = indenter;
		_tmp156_ = inside;
		_tmp157_ = inside;
		ianjuta_indenter_indent (_tmp155_, _tmp156_, _tmp157_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (inside);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_object_unref0 (_tmp14_);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (inside);
	_g_object_unref0 (indenter);
	_vala_code_node_unref0 (sig);
	__g_list_free__vala_code_node_unref0_0 (sigs);
	_vala_code_node_unref0 (widget);
	_g_free0 (handler_cname);
	_g_free0 (scope_prefix);
	_g_string_free0 (builder);
	_vala_code_node_unref0 (scope);
	_g_object_unref0 (_tmp14_);
	_g_free0 (handler_name);
	_g_free0 (signal_name);
	_g_free0 (widget_name);
	data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
}


static void vala_plugin_insert_member_decl_and_init (ValaPlugin* self, IAnjutaEditor* editor, const gchar* widget_ctype, const gchar* widget_name, const gchar* filename) {
	gchar* widget_type = NULL;
	const gchar* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	ValaNamespace* _tmp2_ = NULL;
	ValaNamespace* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* basename = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* member_decl = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* member_init = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	IAnjutaEditor* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (widget_ctype != NULL);
	g_return_if_fail (widget_name != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = widget_ctype;
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_root (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_plugin_lookup_symbol_by_cname (self, _tmp0_, (ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_full_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_code_node_unref0 (_tmp5_);
	widget_type = _tmp7_;
	_tmp8_ = filename;
	_tmp9_ = g_path_get_basename (_tmp8_);
	basename = _tmp9_;
	_tmp10_ = widget_type;
	_tmp11_ = widget_name;
	_tmp12_ = g_strdup_printf ("%s %s;\n", _tmp10_, _tmp11_);
	member_decl = _tmp12_;
	_tmp13_ = widget_name;
	_tmp14_ = widget_name;
	_tmp15_ = widget_type;
	_tmp16_ = g_strdup_printf ("%s = builder.get_object(\"%s\") as %s;\n", _tmp13_, _tmp14_, _tmp15_);
	member_init = _tmp16_;
	_tmp18_ = editor;
	_tmp19_ = basename;
	_tmp20_ = g_strdup_printf (VALA_PLUGIN_DECL_MARK, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = member_decl;
	_tmp23_ = vala_plugin_insert_after_mark (self, _tmp18_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp21_);
	if (_tmp24_) {
		IAnjutaEditor* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		_tmp25_ = editor;
		_tmp26_ = basename;
		_tmp27_ = g_strdup_printf (VALA_PLUGIN_INIT_MARK, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = member_init;
		_tmp30_ = vala_plugin_insert_after_mark (self, _tmp25_, _tmp28_, _tmp29_);
		_tmp17_ = _tmp30_;
		_g_free0 (_tmp28_);
	} else {
		_tmp17_ = FALSE;
	}
	_g_free0 (member_init);
	_g_free0 (member_decl);
	_g_free0 (basename);
	_g_free0 (widget_type);
}


static gboolean vala_plugin_insert_after_mark (ValaPlugin* self, IAnjutaEditor* editor, const gchar* mark, const gchar* code_to_add) {
	gboolean result = FALSE;
	IAnjutaIterable* _tmp0_ = NULL;
	IAnjutaEditor* _tmp1_ = NULL;
	IAnjutaIterable* _tmp2_ = NULL;
	IAnjutaEditorCell* search_start = NULL;
	IAnjutaEditorCell* _tmp3_ = NULL;
	IAnjutaIterable* _tmp4_ = NULL;
	IAnjutaEditor* _tmp5_ = NULL;
	IAnjutaIterable* _tmp6_ = NULL;
	IAnjutaEditorCell* search_end = NULL;
	IAnjutaEditorCell* _tmp7_ = NULL;
	IAnjutaEditorCell* result_end = NULL;
	IAnjutaEditor* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IAnjutaEditorCell* _tmp10_ = NULL;
	IAnjutaEditorCell* _tmp11_ = NULL;
	IAnjutaEditorCell* _tmp12_ = NULL;
	IAnjutaIterable* mark_position = NULL;
	IAnjutaEditorCell* _tmp13_ = NULL;
	IAnjutaIterable* _tmp14_ = NULL;
	IAnjutaIterable* _tmp15_ = NULL;
	IAnjutaEditor* _tmp16_ = NULL;
	IAnjutaIterable* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	AnjutaShell* _tmp20_ = NULL;
	AnjutaShell* _tmp21_ = NULL;
	AnjutaShell* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	IAnjutaIndenter* indenter = NULL;
	IAnjutaIndenter* _tmp25_ = NULL;
	IAnjutaIndenter* _tmp26_ = NULL;
	IAnjutaEditor* _tmp38_ = NULL;
	IAnjutaIterable* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (editor != NULL, FALSE);
	g_return_val_if_fail (mark != NULL, FALSE);
	g_return_val_if_fail (code_to_add != NULL, FALSE);
	_tmp1_ = editor;
	_tmp2_ = ianjuta_editor_get_start_position (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, ianjuta_editor_cell_get_type ()) ? ((IAnjutaEditorCell*) _tmp0_) : NULL);
	search_start = _tmp3_;
	_tmp5_ = editor;
	_tmp6_ = ianjuta_editor_get_end_position (_tmp5_, &_inner_error_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, ianjuta_editor_cell_get_type ()) ? ((IAnjutaEditorCell*) _tmp4_) : NULL);
	search_end = _tmp7_;
	_tmp8_ = editor;
	_tmp9_ = mark;
	_tmp10_ = search_start;
	_tmp11_ = search_end;
	ianjuta_editor_search_forward (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, ianjuta_editor_search_get_type ()) ? ((IAnjutaEditorSearch*) _tmp8_) : NULL, _tmp9_, FALSE, _tmp10_, _tmp11_, NULL, &_tmp12_, &_inner_error_);
	_g_object_unref0 (result_end);
	result_end = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = result_end;
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, ianjuta_iterable_get_type ()) ? ((IAnjutaIterable*) _tmp13_) : NULL);
	mark_position = _tmp14_;
	_tmp15_ = mark_position;
	if (_tmp15_ == NULL) {
		result = FALSE;
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		return result;
	}
	_tmp16_ = editor;
	_tmp17_ = mark_position;
	_tmp18_ = code_to_add;
	ianjuta_editor_insert (_tmp16_, _tmp17_, _tmp18_, -1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = anjuta_shell_get_object (_tmp22_, "IAnjutaIndenter", &_inner_error_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_tmp19_ = _tmp24_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, ianjuta_indenter_get_type ()) ? ((IAnjutaIndenter*) _tmp19_) : NULL);
	indenter = _tmp25_;
	_tmp26_ = indenter;
	if (_tmp26_ != NULL) {
		IAnjutaIterable* end = NULL;
		IAnjutaIterable* _tmp27_ = NULL;
		IAnjutaIterable* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		IAnjutaIterable* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		IAnjutaIterable* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		IAnjutaIndenter* _tmp35_ = NULL;
		IAnjutaIterable* _tmp36_ = NULL;
		IAnjutaIterable* _tmp37_ = NULL;
		_tmp27_ = mark_position;
		_tmp28_ = ianjuta_iterable_clone (_tmp27_, &_inner_error_);
		end = _tmp28_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp30_ = end;
		_tmp31_ = ianjuta_iterable_get_position (_tmp30_, &_inner_error_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp32_ = end;
		_tmp33_ = code_to_add;
		_tmp34_ = g_utf8_strlen (_tmp33_, (gssize) -1);
		ianjuta_iterable_set_position (_tmp32_, (_tmp29_ + _tmp34_) - 1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp35_ = indenter;
		_tmp36_ = mark_position;
		_tmp37_ = end;
		ianjuta_indenter_indent (_tmp35_, _tmp36_, _tmp37_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (end);
	}
	_tmp38_ = editor;
	_tmp39_ = mark_position;
	_tmp40_ = code_to_add;
	g_signal_emit_by_name (_tmp38_, "code-added", _tmp39_, _tmp40_);
	result = TRUE;
	_g_object_unref0 (indenter);
	_g_object_unref0 (mark_position);
	_g_object_unref0 (result_end);
	_g_object_unref0 (search_end);
	_g_object_unref0 (search_start);
	return result;
}


static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent) {
	ValaSymbol* result = NULL;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_ = NULL;
	ValaScope* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	ValaMap* symtab = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaScope* _tmp7_ = NULL;
	ValaScope* _tmp8_ = NULL;
	ValaMap* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = vala_symbol_get_scope (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = cname;
	_tmp4_ = vala_scope_lookup (_tmp2_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (_tmp5_ != NULL) {
		result = sym;
		return result;
	}
	_tmp6_ = parent;
	_tmp7_ = vala_symbol_get_scope (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_get_symbol_table (_tmp8_);
	symtab = _tmp9_;
	{
		ValaIterator* _name_it = NULL;
		ValaMap* _tmp10_ = NULL;
		ValaSet* _tmp11_ = NULL;
		ValaSet* _tmp12_ = NULL;
		ValaIterator* _tmp13_ = NULL;
		ValaIterator* _tmp14_ = NULL;
		_tmp10_ = symtab;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_name_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gchar* name = NULL;
			ValaIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp15_ = _name_it;
			_tmp16_ = vala_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _name_it;
			_tmp18_ = vala_iterator_get (_tmp17_);
			name = (gchar*) _tmp18_;
			_tmp19_ = cname;
			_tmp20_ = name;
			_tmp21_ = g_str_has_prefix (_tmp19_, _tmp20_);
			if (_tmp21_) {
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				ValaSymbol* _tmp28_ = NULL;
				ValaScope* _tmp29_ = NULL;
				ValaScope* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				ValaSymbol* _tmp32_ = NULL;
				ValaSymbol* _tmp33_ = NULL;
				ValaSymbol* _tmp34_ = NULL;
				ValaSymbol* _tmp35_ = NULL;
				_tmp22_ = cname;
				_tmp23_ = name;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_substring (_tmp22_, (glong) _tmp25_, (glong) -1);
				_tmp27_ = _tmp26_;
				_tmp28_ = parent;
				_tmp29_ = vala_symbol_get_scope (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = name;
				_tmp32_ = vala_scope_lookup (_tmp30_, _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_plugin_lookup_symbol_by_cname (self, _tmp27_, _tmp33_);
				_tmp35_ = _tmp34_;
				_vala_code_node_unref0 (_tmp33_);
				_g_free0 (_tmp27_);
				result = _tmp35_;
				_g_free0 (name);
				_vala_iterator_unref0 (_name_it);
				_vala_map_unref0 (symtab);
				_vala_code_node_unref0 (sym);
				return result;
			}
			_g_free0 (name);
		}
		_vala_iterator_unref0 (_name_it);
	}
	result = NULL;
	_vala_map_unref0 (symtab);
	_vala_code_node_unref0 (sym);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	IAnjutaEditor* _tmp0_ = NULL;
	IAnjutaFile* file = NULL;
	IAnjutaEditor* _tmp1_ = NULL;
	IAnjutaFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	IAnjutaFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* path = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	_tmp0_ = editor;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, ianjuta_file_get_type ()), "editor is IAnjuta.File", NULL);
	_tmp1_ = editor;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ianjuta_file_get_type ()) ? ((IAnjutaFile*) _tmp1_) : NULL);
	file = _tmp2_;
	_tmp4_ = file;
	_tmp5_ = ianjuta_file_get_file (_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	path = _tmp9_;
	{
		ValaCodeContext* _tmp10_ = NULL;
		_tmp10_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaSourceFile* source = NULL;
			ValaSourceFile* _tmp28_ = NULL;
			gint line = 0;
			gint column = 0;
			IAnjutaIterable* _tmp38_ = NULL;
			BlockLocator* _tmp59_ = NULL;
			ValaSourceFile* _tmp60_ = NULL;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			ValaSymbol* _tmp63_ = NULL;
			source = NULL;
			{
				ValaList* _src_list = NULL;
				ValaCodeContext* _tmp11_ = NULL;
				ValaList* _tmp12_ = NULL;
				gint _src_size = 0;
				ValaList* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _src_index = 0;
				_tmp11_ = self->priv->context;
				_tmp12_ = vala_code_context_get_source_files (_tmp11_);
				_src_list = _tmp12_;
				_tmp13_ = _src_list;
				_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
				_tmp15_ = _tmp14_;
				_src_size = _tmp15_;
				_src_index = -1;
				while (TRUE) {
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					ValaSourceFile* src = NULL;
					ValaList* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gpointer _tmp21_ = NULL;
					ValaSourceFile* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					_tmp16_ = _src_index;
					_src_index = _tmp16_ + 1;
					_tmp17_ = _src_index;
					_tmp18_ = _src_size;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = _src_list;
					_tmp20_ = _src_index;
					_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
					src = (ValaSourceFile*) _tmp21_;
					_tmp22_ = src;
					_tmp23_ = vala_source_file_get_filename (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = path;
					if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
						ValaSourceFile* _tmp26_ = NULL;
						ValaSourceFile* _tmp27_ = NULL;
						_tmp26_ = src;
						_tmp27_ = _vala_source_file_ref0 (_tmp26_);
						_vala_source_file_unref0 (source);
						source = _tmp27_;
						_vala_source_file_unref0 (src);
						break;
					}
					_vala_source_file_unref0 (src);
				}
				_vala_iterable_unref0 (_src_list);
			}
			_tmp28_ = source;
			if (_tmp28_ == NULL) {
				ValaSourceFileType _tmp29_ = 0;
				const gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				ValaCodeContext* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				ValaSourceFile* _tmp34_ = NULL;
				ValaCodeContext* _tmp35_ = NULL;
				ValaSourceFile* _tmp36_ = NULL;
				ValaSourceFile* _tmp37_ = NULL;
				_tmp30_ = path;
				_tmp31_ = g_str_has_suffix (_tmp30_, "vapi");
				if (_tmp31_) {
					_tmp29_ = VALA_SOURCE_FILE_TYPE_PACKAGE;
				} else {
					_tmp29_ = VALA_SOURCE_FILE_TYPE_SOURCE;
				}
				_tmp32_ = self->priv->context;
				_tmp33_ = path;
				_tmp34_ = vala_source_file_new (_tmp32_, _tmp29_, _tmp33_, NULL, FALSE);
				_vala_source_file_unref0 (source);
				source = _tmp34_;
				_tmp35_ = self->priv->context;
				_tmp36_ = source;
				vala_code_context_add_source_file (_tmp35_, _tmp36_);
				_tmp37_ = source;
				vala_plugin_update_file (self, _tmp37_);
			}
			_tmp38_ = position;
			if (_tmp38_ == NULL) {
				gint _tmp39_ = 0;
				IAnjutaEditor* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				IAnjutaEditor* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				_tmp40_ = editor;
				_tmp41_ = ianjuta_editor_get_lineno (_tmp40_, &_inner_error_);
				_tmp39_ = _tmp41_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				line = _tmp39_;
				_tmp43_ = editor;
				_tmp44_ = ianjuta_editor_get_column (_tmp43_, &_inner_error_);
				_tmp42_ = _tmp44_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				column = _tmp42_;
			} else {
				gint _tmp45_ = 0;
				IAnjutaEditor* _tmp46_ = NULL;
				IAnjutaIterable* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				IAnjutaIterable* _tmp49_ = NULL;
				IAnjutaEditor* _tmp50_ = NULL;
				gint _tmp51_ = 0;
				IAnjutaIterable* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				IAnjutaIterable* _tmp54_ = NULL;
				IAnjutaIterable* _tmp55_ = NULL;
				IAnjutaIterable* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				_tmp46_ = editor;
				_tmp47_ = position;
				_tmp48_ = ianjuta_editor_get_line_from_position (_tmp46_, _tmp47_, &_inner_error_);
				_tmp45_ = _tmp48_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				line = _tmp45_;
				_tmp50_ = editor;
				_tmp51_ = line;
				_tmp52_ = ianjuta_editor_get_line_begin_position (_tmp50_, _tmp51_, &_inner_error_);
				_tmp49_ = _tmp52_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				_tmp54_ = _tmp49_;
				_tmp49_ = NULL;
				_tmp55_ = _tmp54_;
				_tmp56_ = position;
				_tmp57_ = ianjuta_iterable_diff (_tmp55_, _tmp56_, &_inner_error_);
				_tmp58_ = _tmp57_;
				_g_object_unref0 (_tmp55_);
				_tmp53_ = _tmp58_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (_tmp49_);
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				column = _tmp53_;
				_g_object_unref0 (_tmp49_);
			}
			_tmp59_ = self->priv->locator;
			_tmp60_ = source;
			_tmp61_ = line;
			_tmp62_ = column;
			_tmp63_ = block_locator_locate (_tmp59_, _tmp60_, _tmp61_, _tmp62_);
			result = _tmp63_;
			_vala_source_file_unref0 (source);
			{
				ValaCodeContext* _tmp64_ = NULL;
				_tmp64_ = self->priv->context;
				g_static_rec_mutex_unlock (&self->priv->__lock_context);
			}
			_g_free0 (path);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			return result;
		}
		__finally6:
		{
			ValaCodeContext* _tmp65_ = NULL;
			_tmp65_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		_g_free0 (path);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (file);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block) {
	GList* result = NULL;
	GList* matching_symbols = NULL;
	ValaBlock* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	matching_symbols = NULL;
	_tmp0_ = block;
	if (_tmp0_ == NULL) {
		result = matching_symbols;
		return result;
	}
	{
		ValaCodeContext* _tmp1_ = NULL;
		_tmp1_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaExpression* _tmp2_ = NULL;
			_tmp2_ = inner;
			if (_tmp2_ == NULL) {
				{
					ValaSymbol* sym = NULL;
					ValaBlock* _tmp3_ = NULL;
					ValaSymbol* _tmp4_ = NULL;
					_tmp3_ = block;
					_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SYMBOL, ValaSymbol));
					sym = _tmp4_;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							ValaSymbol* _tmp10_ = NULL;
							ValaSymbol* _tmp11_ = NULL;
							const gchar* _tmp12_ = NULL;
							gboolean _tmp13_ = FALSE;
							GList* _tmp14_ = NULL;
							if (!_tmp5_) {
								ValaSymbol* _tmp6_ = NULL;
								ValaSymbol* _tmp7_ = NULL;
								ValaSymbol* _tmp8_ = NULL;
								ValaSymbol* _tmp9_ = NULL;
								_tmp6_ = sym;
								_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
								_tmp8_ = _tmp7_;
								_tmp9_ = _vala_code_node_ref0 (_tmp8_);
								_vala_code_node_unref0 (sym);
								sym = _tmp9_;
							}
							_tmp5_ = FALSE;
							_tmp10_ = sym;
							if (!(_tmp10_ != NULL)) {
								break;
							}
							_tmp11_ = sym;
							_tmp12_ = name;
							_tmp13_ = prefix_match;
							_tmp14_ = vala_plugin_symbol_lookup_inherited (self, _tmp11_, _tmp12_, _tmp13_, FALSE);
							matching_symbols = g_list_concat (matching_symbols, _tmp14_);
						}
					}
					_vala_code_node_unref0 (sym);
				}
				{
					ValaList* _ns_list = NULL;
					ValaBlock* _tmp15_ = NULL;
					ValaSourceReference* _tmp16_ = NULL;
					ValaSourceReference* _tmp17_ = NULL;
					ValaSourceFile* _tmp18_ = NULL;
					ValaSourceFile* _tmp19_ = NULL;
					ValaList* _tmp20_ = NULL;
					ValaList* _tmp21_ = NULL;
					ValaList* _tmp22_ = NULL;
					gint _ns_size = 0;
					ValaList* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint _ns_index = 0;
					_tmp15_ = block;
					_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = vala_source_reference_get_file (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_source_file_get_current_using_directives (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = _vala_iterable_ref0 (_tmp21_);
					_ns_list = _tmp22_;
					_tmp23_ = _ns_list;
					_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
					_tmp25_ = _tmp24_;
					_ns_size = _tmp25_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp26_ = 0;
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						gpointer _tmp31_ = NULL;
						ValaUsingDirective* _tmp32_ = NULL;
						ValaSymbol* _tmp33_ = NULL;
						ValaSymbol* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						GList* _tmp37_ = NULL;
						_tmp26_ = _ns_index;
						_ns_index = _tmp26_ + 1;
						_tmp27_ = _ns_index;
						_tmp28_ = _ns_size;
						if (!(_tmp27_ < _tmp28_)) {
							break;
						}
						_tmp29_ = _ns_list;
						_tmp30_ = _ns_index;
						_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
						ns = (ValaUsingDirective*) _tmp31_;
						_tmp32_ = ns;
						_tmp33_ = vala_using_directive_get_namespace_symbol (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = name;
						_tmp36_ = prefix_match;
						_tmp37_ = vala_plugin_symbol_lookup_inherited (self, _tmp34_, _tmp35_, _tmp36_, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp37_);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			} else {
				ValaExpression* _tmp38_ = NULL;
				ValaSymbol* _tmp39_ = NULL;
				ValaSymbol* _tmp40_ = NULL;
				_tmp38_ = inner;
				_tmp39_ = vala_expression_get_symbol_reference (_tmp38_);
				_tmp40_ = _tmp39_;
				if (_tmp40_ != NULL) {
					ValaExpression* _tmp41_ = NULL;
					ValaSymbol* _tmp42_ = NULL;
					ValaSymbol* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					GList* _tmp46_ = NULL;
					_tmp41_ = inner;
					_tmp42_ = vala_expression_get_symbol_reference (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = name;
					_tmp45_ = prefix_match;
					_tmp46_ = vala_plugin_symbol_lookup_inherited (self, _tmp43_, _tmp44_, _tmp45_, FALSE);
					matching_symbols = g_list_concat (matching_symbols, _tmp46_);
				} else {
					ValaExpression* _tmp47_ = NULL;
					_tmp47_ = inner;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_MEMBER_ACCESS)) {
						ValaMemberAccess* inner_ma = NULL;
						ValaExpression* _tmp48_ = NULL;
						ValaMemberAccess* _tmp49_ = NULL;
						GList* matching = NULL;
						ValaMemberAccess* _tmp50_ = NULL;
						ValaExpression* _tmp51_ = NULL;
						ValaExpression* _tmp52_ = NULL;
						ValaMemberAccess* _tmp53_ = NULL;
						const gchar* _tmp54_ = NULL;
						const gchar* _tmp55_ = NULL;
						ValaBlock* _tmp56_ = NULL;
						GList* _tmp57_ = NULL;
						GList* _tmp58_ = NULL;
						_tmp48_ = inner;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
						inner_ma = _tmp49_;
						_tmp50_ = inner_ma;
						_tmp51_ = vala_member_access_get_inner (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = inner_ma;
						_tmp54_ = vala_member_access_get_member_name (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = block;
						_tmp57_ = vala_plugin_lookup_symbol (self, _tmp52_, _tmp55_, FALSE, _tmp56_);
						matching = _tmp57_;
						_tmp58_ = matching;
						if (_tmp58_ != NULL) {
							GList* _tmp59_ = NULL;
							gconstpointer _tmp60_ = NULL;
							const gchar* _tmp61_ = NULL;
							gboolean _tmp62_ = FALSE;
							GList* _tmp63_ = NULL;
							_tmp59_ = matching;
							_tmp60_ = _tmp59_->data;
							_tmp61_ = name;
							_tmp62_ = prefix_match;
							_tmp63_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp60_, _tmp61_, _tmp62_, FALSE);
							matching_symbols = g_list_concat (matching_symbols, _tmp63_);
						}
						__g_list_free__vala_code_node_unref0_0 (matching);
						_vala_code_node_unref0 (inner_ma);
					} else {
						ValaExpression* _tmp64_ = NULL;
						_tmp64_ = inner;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_METHOD_CALL)) {
							ValaMethodCall* inner_inv = NULL;
							ValaExpression* _tmp65_ = NULL;
							ValaMethodCall* _tmp66_ = NULL;
							ValaMemberAccess* inner_ma = NULL;
							ValaMethodCall* _tmp67_ = NULL;
							ValaExpression* _tmp68_ = NULL;
							ValaExpression* _tmp69_ = NULL;
							ValaMemberAccess* _tmp70_ = NULL;
							ValaMemberAccess* _tmp71_ = NULL;
							_tmp65_ = inner;
							_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
							inner_inv = _tmp66_;
							_tmp67_ = inner_inv;
							_tmp68_ = vala_method_call_get_call (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp69_) : NULL);
							inner_ma = _tmp70_;
							_tmp71_ = inner_ma;
							if (_tmp71_ != NULL) {
								GList* matching = NULL;
								ValaMemberAccess* _tmp72_ = NULL;
								ValaExpression* _tmp73_ = NULL;
								ValaExpression* _tmp74_ = NULL;
								ValaMemberAccess* _tmp75_ = NULL;
								const gchar* _tmp76_ = NULL;
								const gchar* _tmp77_ = NULL;
								ValaBlock* _tmp78_ = NULL;
								GList* _tmp79_ = NULL;
								GList* _tmp80_ = NULL;
								_tmp72_ = inner_ma;
								_tmp73_ = vala_member_access_get_inner (_tmp72_);
								_tmp74_ = _tmp73_;
								_tmp75_ = inner_ma;
								_tmp76_ = vala_member_access_get_member_name (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = block;
								_tmp79_ = vala_plugin_lookup_symbol (self, _tmp74_, _tmp77_, FALSE, _tmp78_);
								matching = _tmp79_;
								_tmp80_ = matching;
								if (_tmp80_ != NULL) {
									GList* _tmp81_ = NULL;
									gconstpointer _tmp82_ = NULL;
									const gchar* _tmp83_ = NULL;
									gboolean _tmp84_ = FALSE;
									GList* _tmp85_ = NULL;
									_tmp81_ = matching;
									_tmp82_ = _tmp81_->data;
									_tmp83_ = name;
									_tmp84_ = prefix_match;
									_tmp85_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp82_, _tmp83_, _tmp84_, TRUE);
									matching_symbols = g_list_concat (matching_symbols, _tmp85_);
								}
								__g_list_free__vala_code_node_unref0_0 (matching);
							}
							_vala_code_node_unref0 (inner_ma);
							_vala_code_node_unref0 (inner_inv);
						}
					}
				}
			}
		}
		__finally7:
		{
			ValaCodeContext* _tmp86_ = NULL;
			_tmp86_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			__g_list_free__vala_code_node_unref0_0 (matching_symbols);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = matching_symbols;
	return result;
}


static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation) {
	GList* result = NULL;
	GList* _result_ = NULL;
	ValaSymbol* _tmp0_ = NULL;
	ValaMap* symbol_table = NULL;
	ValaSymbol* _tmp1_ = NULL;
	ValaScope* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaMap* _tmp4_ = NULL;
	ValaMap* _tmp5_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = sym;
	if (_tmp0_ == NULL) {
		result = _result_;
		return result;
	}
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_scope (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_get_symbol_table (_tmp3_);
	symbol_table = _tmp4_;
	_tmp5_ = symbol_table;
	if (_tmp5_ != NULL) {
		{
			ValaIterator* _key_it = NULL;
			ValaMap* _tmp6_ = NULL;
			ValaSet* _tmp7_ = NULL;
			ValaSet* _tmp8_ = NULL;
			ValaIterator* _tmp9_ = NULL;
			ValaIterator* _tmp10_ = NULL;
			_tmp6_ = symbol_table;
			_tmp7_ = vala_map_get_keys (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_iterable_iterator ((ValaIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_vala_iterable_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				ValaIterator* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gchar* key = NULL;
				ValaIterator* _tmp13_ = NULL;
				gpointer _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				_tmp11_ = _key_it;
				_tmp12_ = vala_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _key_it;
				_tmp14_ = vala_iterator_get (_tmp13_);
				key = (gchar*) _tmp14_;
				_tmp17_ = prefix_match;
				if (_tmp17_) {
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp18_ = key;
					_tmp19_ = name;
					_tmp20_ = g_str_has_prefix (_tmp18_, _tmp19_);
					_tmp16_ = _tmp20_;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = key;
					_tmp22_ = name;
					_tmp15_ = g_strcmp0 (_tmp21_, _tmp22_) == 0;
				}
				if (_tmp15_) {
					ValaMap* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gpointer _tmp25_ = NULL;
					_tmp23_ = symbol_table;
					_tmp24_ = key;
					_tmp25_ = vala_map_get (_tmp23_, _tmp24_);
					_result_ = g_list_append (_result_, (ValaSymbol*) _tmp25_);
				}
				_g_free0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
	}
	_tmp27_ = invocation;
	if (_tmp27_) {
		ValaSymbol* _tmp28_ = NULL;
		_tmp28_ = sym;
		_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_METHOD);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaMethod* func = NULL;
		ValaSymbol* _tmp29_ = NULL;
		ValaMethod* _tmp30_ = NULL;
		ValaMethod* _tmp31_ = NULL;
		ValaDataType* _tmp32_ = NULL;
		ValaDataType* _tmp33_ = NULL;
		ValaTypeSymbol* _tmp34_ = NULL;
		ValaTypeSymbol* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		GList* _tmp38_ = NULL;
		_tmp29_ = sym;
		_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
		func = _tmp30_;
		_tmp31_ = func;
		_tmp32_ = vala_method_get_return_type (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_data_type_get_data_type (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = name;
		_tmp37_ = prefix_match;
		_tmp38_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp35_, _tmp36_, _tmp37_, FALSE);
		_result_ = g_list_concat (_result_, _tmp38_);
		_vala_code_node_unref0 (func);
	} else {
		ValaSymbol* _tmp39_ = NULL;
		_tmp39_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp40_ = NULL;
			ValaClass* _tmp41_ = NULL;
			_tmp40_ = sym;
			_tmp41_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp41_;
			{
				ValaList* _base_type_list = NULL;
				ValaClass* _tmp42_ = NULL;
				ValaList* _tmp43_ = NULL;
				gint _base_type_size = 0;
				ValaList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _base_type_index = 0;
				_tmp42_ = cl;
				_tmp43_ = vala_class_get_base_types (_tmp42_);
				_base_type_list = _tmp43_;
				_tmp44_ = _base_type_list;
				_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				_base_type_size = _tmp46_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					ValaDataType* base_type = NULL;
					ValaList* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gpointer _tmp52_ = NULL;
					ValaDataType* _tmp53_ = NULL;
					ValaTypeSymbol* _tmp54_ = NULL;
					ValaTypeSymbol* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					gboolean _tmp57_ = FALSE;
					GList* _tmp58_ = NULL;
					_tmp47_ = _base_type_index;
					_base_type_index = _tmp47_ + 1;
					_tmp48_ = _base_type_index;
					_tmp49_ = _base_type_size;
					if (!(_tmp48_ < _tmp49_)) {
						break;
					}
					_tmp50_ = _base_type_list;
					_tmp51_ = _base_type_index;
					_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
					base_type = (ValaDataType*) _tmp52_;
					_tmp53_ = base_type;
					_tmp54_ = vala_data_type_get_data_type (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = name;
					_tmp57_ = prefix_match;
					_tmp58_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp55_, _tmp56_, _tmp57_, FALSE);
					_result_ = g_list_concat (_result_, _tmp58_);
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp59_ = NULL;
			_tmp59_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, VALA_TYPE_STRUCT)) {
				ValaStruct* st = NULL;
				ValaSymbol* _tmp60_ = NULL;
				ValaStruct* _tmp61_ = NULL;
				ValaStruct* _tmp62_ = NULL;
				ValaDataType* _tmp63_ = NULL;
				ValaDataType* _tmp64_ = NULL;
				ValaTypeSymbol* _tmp65_ = NULL;
				ValaTypeSymbol* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
				gboolean _tmp68_ = FALSE;
				GList* _tmp69_ = NULL;
				_tmp60_ = sym;
				_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp61_;
				_tmp62_ = st;
				_tmp63_ = vala_struct_get_base_type (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_data_type_get_data_type (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = name;
				_tmp68_ = prefix_match;
				_tmp69_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp66_, _tmp67_, _tmp68_, FALSE);
				_result_ = g_list_concat (_result_, _tmp69_);
				_vala_code_node_unref0 (st);
			} else {
				ValaSymbol* _tmp70_ = NULL;
				_tmp70_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_INTERFACE)) {
					ValaInterface* iface = NULL;
					ValaSymbol* _tmp71_ = NULL;
					ValaInterface* _tmp72_ = NULL;
					_tmp71_ = sym;
					_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp72_;
					{
						ValaList* _prerequisite_list = NULL;
						ValaInterface* _tmp73_ = NULL;
						ValaList* _tmp74_ = NULL;
						gint _prerequisite_size = 0;
						ValaList* _tmp75_ = NULL;
						gint _tmp76_ = 0;
						gint _tmp77_ = 0;
						gint _prerequisite_index = 0;
						_tmp73_ = iface;
						_tmp74_ = vala_interface_get_prerequisites (_tmp73_);
						_prerequisite_list = _tmp74_;
						_tmp75_ = _prerequisite_list;
						_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
						_tmp77_ = _tmp76_;
						_prerequisite_size = _tmp77_;
						_prerequisite_index = -1;
						while (TRUE) {
							gint _tmp78_ = 0;
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							ValaDataType* prerequisite = NULL;
							ValaList* _tmp81_ = NULL;
							gint _tmp82_ = 0;
							gpointer _tmp83_ = NULL;
							ValaDataType* _tmp84_ = NULL;
							ValaTypeSymbol* _tmp85_ = NULL;
							ValaTypeSymbol* _tmp86_ = NULL;
							const gchar* _tmp87_ = NULL;
							gboolean _tmp88_ = FALSE;
							GList* _tmp89_ = NULL;
							_tmp78_ = _prerequisite_index;
							_prerequisite_index = _tmp78_ + 1;
							_tmp79_ = _prerequisite_index;
							_tmp80_ = _prerequisite_size;
							if (!(_tmp79_ < _tmp80_)) {
								break;
							}
							_tmp81_ = _prerequisite_list;
							_tmp82_ = _prerequisite_index;
							_tmp83_ = vala_list_get (_tmp81_, _tmp82_);
							prerequisite = (ValaDataType*) _tmp83_;
							_tmp84_ = prerequisite;
							_tmp85_ = vala_data_type_get_data_type (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = name;
							_tmp88_ = prefix_match;
							_tmp89_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp86_, _tmp87_, _tmp88_, FALSE);
							_result_ = g_list_concat (_result_, _tmp89_);
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_iterable_unref0 (_prerequisite_list);
					}
					_vala_code_node_unref0 (iface);
				} else {
					ValaSymbol* _tmp90_ = NULL;
					_tmp90_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_LOCAL_VARIABLE)) {
						ValaLocalVariable* variable = NULL;
						ValaSymbol* _tmp91_ = NULL;
						ValaLocalVariable* _tmp92_ = NULL;
						ValaLocalVariable* _tmp93_ = NULL;
						ValaDataType* _tmp94_ = NULL;
						ValaDataType* _tmp95_ = NULL;
						ValaTypeSymbol* _tmp96_ = NULL;
						ValaTypeSymbol* _tmp97_ = NULL;
						const gchar* _tmp98_ = NULL;
						gboolean _tmp99_ = FALSE;
						GList* _tmp100_ = NULL;
						_tmp91_ = sym;
						_tmp92_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
						variable = _tmp92_;
						_tmp93_ = variable;
						_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) _tmp93_);
						_tmp95_ = _tmp94_;
						_tmp96_ = vala_data_type_get_data_type (_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = name;
						_tmp99_ = prefix_match;
						_tmp100_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp97_, _tmp98_, _tmp99_, FALSE);
						_result_ = g_list_concat (_result_, _tmp100_);
						_vala_code_node_unref0 (variable);
					} else {
						ValaSymbol* _tmp101_ = NULL;
						_tmp101_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_FIELD)) {
							ValaField* field = NULL;
							ValaSymbol* _tmp102_ = NULL;
							ValaField* _tmp103_ = NULL;
							ValaField* _tmp104_ = NULL;
							ValaDataType* _tmp105_ = NULL;
							ValaDataType* _tmp106_ = NULL;
							ValaTypeSymbol* _tmp107_ = NULL;
							ValaTypeSymbol* _tmp108_ = NULL;
							const gchar* _tmp109_ = NULL;
							gboolean _tmp110_ = FALSE;
							GList* _tmp111_ = NULL;
							_tmp102_ = sym;
							_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_FIELD, ValaField));
							field = _tmp103_;
							_tmp104_ = field;
							_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp104_);
							_tmp106_ = _tmp105_;
							_tmp107_ = vala_data_type_get_data_type (_tmp106_);
							_tmp108_ = _tmp107_;
							_tmp109_ = name;
							_tmp110_ = prefix_match;
							_tmp111_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp108_, _tmp109_, _tmp110_, FALSE);
							_result_ = g_list_concat (_result_, _tmp111_);
							_vala_code_node_unref0 (field);
						} else {
							ValaSymbol* _tmp112_ = NULL;
							_tmp112_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, VALA_TYPE_PROPERTY)) {
								ValaProperty* prop = NULL;
								ValaSymbol* _tmp113_ = NULL;
								ValaProperty* _tmp114_ = NULL;
								ValaProperty* _tmp115_ = NULL;
								ValaDataType* _tmp116_ = NULL;
								ValaDataType* _tmp117_ = NULL;
								ValaTypeSymbol* _tmp118_ = NULL;
								ValaTypeSymbol* _tmp119_ = NULL;
								const gchar* _tmp120_ = NULL;
								gboolean _tmp121_ = FALSE;
								GList* _tmp122_ = NULL;
								_tmp113_ = sym;
								_tmp114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, VALA_TYPE_PROPERTY, ValaProperty));
								prop = _tmp114_;
								_tmp115_ = prop;
								_tmp116_ = vala_property_get_property_type (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp118_ = vala_data_type_get_data_type (_tmp117_);
								_tmp119_ = _tmp118_;
								_tmp120_ = name;
								_tmp121_ = prefix_match;
								_tmp122_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp119_, _tmp120_, _tmp121_, FALSE);
								_result_ = g_list_concat (_result_, _tmp122_);
								_vala_code_node_unref0 (prop);
							} else {
								ValaSymbol* _tmp123_ = NULL;
								_tmp123_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_PARAMETER)) {
									ValaParameter* fp = NULL;
									ValaSymbol* _tmp124_ = NULL;
									ValaParameter* _tmp125_ = NULL;
									ValaParameter* _tmp126_ = NULL;
									ValaDataType* _tmp127_ = NULL;
									ValaDataType* _tmp128_ = NULL;
									ValaTypeSymbol* _tmp129_ = NULL;
									ValaTypeSymbol* _tmp130_ = NULL;
									const gchar* _tmp131_ = NULL;
									gboolean _tmp132_ = FALSE;
									GList* _tmp133_ = NULL;
									_tmp124_ = sym;
									_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_PARAMETER, ValaParameter));
									fp = _tmp125_;
									_tmp126_ = fp;
									_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
									_tmp128_ = _tmp127_;
									_tmp129_ = vala_data_type_get_data_type (_tmp128_);
									_tmp130_ = _tmp129_;
									_tmp131_ = name;
									_tmp132_ = prefix_match;
									_tmp133_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp130_, _tmp131_, _tmp132_, FALSE);
									_result_ = g_list_concat (_result_, _tmp133_);
									_vala_code_node_unref0 (fp);
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	_vala_map_unref0 (symbol_table);
	return result;
}


static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaCodeContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaArrayList* nodes = NULL;
			GEqualFunc _tmp1_ = NULL;
			ValaArrayList* _tmp2_ = NULL;
			ValaSourceFile* _tmp46_ = NULL;
			GEqualFunc _tmp47_ = NULL;
			ValaArrayList* _tmp48_ = NULL;
			ValaArrayList* _tmp49_ = NULL;
			ValaUsingDirective* ns_ref = NULL;
			ValaUnresolvedSymbol* _tmp50_ = NULL;
			ValaUnresolvedSymbol* _tmp51_ = NULL;
			ValaUsingDirective* _tmp52_ = NULL;
			ValaUsingDirective* _tmp53_ = NULL;
			ValaSourceFile* _tmp54_ = NULL;
			ValaCodeContext* _tmp55_ = NULL;
			ValaNamespace* _tmp56_ = NULL;
			ValaNamespace* _tmp57_ = NULL;
			AnjutaReport* _tmp58_ = NULL;
			ValaSourceFile* _tmp59_ = NULL;
			AnjutaReport* _tmp60_ = NULL;
			IAnjutaEditor* _tmp61_ = NULL;
			_tmp1_ = g_direct_equal;
			_tmp2_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp1_);
			nodes = _tmp2_;
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp3_ = NULL;
				ValaList* _tmp4_ = NULL;
				gint _node_size = 0;
				ValaList* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _node_index = 0;
				_tmp3_ = file;
				_tmp4_ = vala_source_file_get_nodes (_tmp3_);
				_node_list = _tmp4_;
				_tmp5_ = _node_list;
				_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				_node_size = _tmp7_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					ValaCodeNode* node = NULL;
					ValaList* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gpointer _tmp13_ = NULL;
					ValaArrayList* _tmp14_ = NULL;
					ValaCodeNode* _tmp15_ = NULL;
					_tmp8_ = _node_index;
					_node_index = _tmp8_ + 1;
					_tmp9_ = _node_index;
					_tmp10_ = _node_size;
					if (!(_tmp9_ < _tmp10_)) {
						break;
					}
					_tmp11_ = _node_list;
					_tmp12_ = _node_index;
					_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
					node = (ValaCodeNode*) _tmp13_;
					_tmp14_ = nodes;
					_tmp15_ = node;
					vala_collection_add ((ValaCollection*) _tmp14_, _tmp15_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp16_ = NULL;
				ValaArrayList* _tmp17_ = NULL;
				gint _node_size = 0;
				ValaArrayList* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _node_index = 0;
				_tmp16_ = nodes;
				_tmp17_ = _vala_iterable_ref0 (_tmp16_);
				_node_list = _tmp17_;
				_tmp18_ = _node_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_node_size = _tmp20_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					ValaCodeNode* node = NULL;
					ValaArrayList* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gpointer _tmp26_ = NULL;
					ValaSourceFile* _tmp27_ = NULL;
					ValaCodeNode* _tmp28_ = NULL;
					ValaCodeNode* _tmp29_ = NULL;
					_tmp21_ = _node_index;
					_node_index = _tmp21_ + 1;
					_tmp22_ = _node_index;
					_tmp23_ = _node_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _node_list;
					_tmp25_ = _node_index;
					_tmp26_ = vala_list_get ((ValaList*) _tmp24_, _tmp25_);
					node = (ValaCodeNode*) _tmp26_;
					_tmp27_ = file;
					_tmp28_ = node;
					vala_source_file_remove_node (_tmp27_, _tmp28_);
					_tmp29_ = node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_SYMBOL)) {
						ValaSymbol* sym = NULL;
						ValaCodeNode* _tmp30_ = NULL;
						ValaSymbol* _tmp31_ = NULL;
						ValaSymbol* _tmp32_ = NULL;
						ValaScope* _tmp33_ = NULL;
						ValaScope* _tmp34_ = NULL;
						ValaCodeContext* _tmp41_ = NULL;
						ValaMethod* _tmp42_ = NULL;
						ValaMethod* _tmp43_ = NULL;
						ValaSymbol* _tmp44_ = NULL;
						_tmp30_ = node;
						_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_SYMBOL, ValaSymbol));
						sym = _tmp31_;
						_tmp32_ = sym;
						_tmp33_ = vala_symbol_get_owner (_tmp32_);
						_tmp34_ = _tmp33_;
						if (_tmp34_ != NULL) {
							ValaSymbol* _tmp35_ = NULL;
							ValaScope* _tmp36_ = NULL;
							ValaScope* _tmp37_ = NULL;
							ValaSymbol* _tmp38_ = NULL;
							const gchar* _tmp39_ = NULL;
							const gchar* _tmp40_ = NULL;
							_tmp35_ = sym;
							_tmp36_ = vala_symbol_get_owner (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = sym;
							_tmp39_ = vala_symbol_get_name (_tmp38_);
							_tmp40_ = _tmp39_;
							vala_scope_remove (_tmp37_, _tmp40_);
						}
						_tmp41_ = self->priv->context;
						_tmp42_ = vala_code_context_get_entry_point (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = sym;
						if (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp44_) {
							ValaCodeContext* _tmp45_ = NULL;
							_tmp45_ = self->priv->context;
							vala_code_context_set_entry_point (_tmp45_, NULL);
						}
						_vala_code_node_unref0 (sym);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp46_ = file;
			_tmp47_ = g_direct_equal;
			_tmp48_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp47_);
			_tmp49_ = _tmp48_;
			vala_source_file_set_current_using_directives (_tmp46_, (ValaList*) _tmp49_);
			_vala_iterable_unref0 (_tmp49_);
			_tmp50_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_using_directive_new ((ValaSymbol*) _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			_vala_code_node_unref0 (_tmp51_);
			ns_ref = _tmp53_;
			_tmp54_ = file;
			vala_source_file_add_using_directive (_tmp54_, ns_ref);
			_tmp55_ = self->priv->context;
			_tmp56_ = vala_code_context_get_root (_tmp55_);
			_tmp57_ = _tmp56_;
			vala_namespace_add_using_directive (_tmp57_, ns_ref);
			_tmp58_ = self->priv->report;
			_tmp59_ = file;
			anjuta_report_clear_error_indicators (_tmp58_, _tmp59_);
			vala_plugin_parse (self);
			_tmp60_ = self->priv->report;
			_tmp61_ = self->current_editor;
			anjuta_report_update_errors (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (ns_ref);
			_vala_iterable_unref0 (nodes);
		}
		__finally8:
		{
			ValaCodeContext* _tmp62_ = NULL;
			_tmp62_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void vala_plugin_on_autocompletion_toggled (ValaPlugin* self, GtkToggleButton* button) {
	gboolean sensitive = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkWidget* widget = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	sensitive = _tmp1_;
	_tmp2_ = vala_plugin_bxml;
	_tmp3_ = gtk_builder_get_object (_tmp2_, VALA_PLUGIN_PREF_WIDGET_SPACE);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp3_) : NULL);
	widget = _tmp4_;
	_tmp5_ = widget;
	gtk_widget_set_sensitive (_tmp5_, sensitive);
	_tmp6_ = vala_plugin_bxml;
	_tmp7_ = gtk_builder_get_object (_tmp6_, VALA_PLUGIN_PREF_WIDGET_BRACE);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
	_g_object_unref0 (widget);
	widget = _tmp8_;
	_tmp9_ = widget;
	gtk_widget_set_sensitive (_tmp9_, sensitive);
	_g_object_unref0 (widget);
}


static void _vala_plugin_on_autocompletion_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	vala_plugin_on_autocompletion_toggled ((ValaPlugin*) self, _sender);
}


static void vala_plugin_real_merge (IAnjutaPreferences* base, AnjutaPreferences* prefs, GError** error) {
	ValaPlugin * self;
	GtkBuilder* _tmp0_ = NULL;
	AnjutaPreferences* _tmp5_ = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkToggleButton* toggle = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkToggleButton* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_return_if_fail (prefs != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (vala_plugin_bxml);
	vala_plugin_bxml = _tmp0_;
	{
		GtkBuilder* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = vala_plugin_bxml;
		_tmp2_ = vala_plugin_PREFS_BUILDER;
		gtk_builder_add_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("plugin.vala:655: Couldn't load builder file: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = prefs;
	_tmp6_ = vala_plugin_bxml;
	_tmp7_ = self->settings;
	_tmp8_ = _ ("Auto-complete");
	anjuta_preferences_add_from_builder (_tmp5_, _tmp6_, _tmp7_, "preferences", _tmp8_, VALA_PLUGIN_ICON_FILE);
	_tmp9_ = vala_plugin_bxml;
	_tmp10_ = gtk_builder_get_object (_tmp9_, VALA_PLUGIN_PREF_WIDGET_AUTO);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp10_) : NULL);
	toggle = _tmp11_;
	g_signal_connect_object (toggle, "toggled", (GCallback) _vala_plugin_on_autocompletion_toggled_gtk_toggle_button_toggled, self, 0);
	vala_plugin_on_autocompletion_toggled (self, toggle);
	_g_object_unref0 (toggle);
}


static void vala_plugin_real_unmerge (IAnjutaPreferences* base, AnjutaPreferences* prefs, GError** error) {
	ValaPlugin * self;
	AnjutaPreferences* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaPlugin*) base;
	g_return_if_fail (prefs != NULL);
	_tmp0_ = prefs;
	_tmp1_ = _ ("Auto-complete");
	anjuta_preferences_remove_page (_tmp0_, _tmp1_);
}


static void vala_plugin_class_init (ValaPluginClass * klass) {
	gchar* _tmp0_ = NULL;
	vala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPluginPrivate));
	((AnjutaPluginClass *) klass)->activate = vala_plugin_real_activate;
	((AnjutaPluginClass *) klass)->deactivate = vala_plugin_real_deactivate;
	G_OBJECT_CLASS (klass)->finalize = vala_plugin_finalize;
	_tmp0_ = g_strdup (PACKAGE_DATA_DIR "/glade/anjuta-vala.ui");
	vala_plugin_PREFS_BUILDER = _tmp0_;
}


static void vala_plugin_ianjuta_preferences_interface_init (IAnjutaPreferencesIface * iface) {
	vala_plugin_ianjuta_preferences_parent_iface = g_type_interface_peek_parent (iface);
	iface->merge = (void (*)(IAnjutaPreferences*, AnjutaPreferences*, GError**)) vala_plugin_real_merge;
	iface->unmerge = (void (*)(IAnjutaPreferences*, AnjutaPreferences*, GError**)) vala_plugin_real_unmerge;
}


static void vala_plugin_instance_init (ValaPlugin * self) {
	GSettings* _tmp0_ = NULL;
	BlockLocator* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	ValaHashSet* _tmp4_ = NULL;
	self->priv = VALA_PLUGIN_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("org.gnome.anjuta.plugins.vala");
	self->settings = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock_context);
	_tmp1_ = block_locator_new ();
	self->priv->locator = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp2_, _tmp3_);
	self->priv->current_sources = (ValaSet*) _tmp4_;
}


static void vala_plugin_finalize (GObject* obj) {
	ValaPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_PLUGIN, ValaPlugin);
	_g_object_unref0 (self->settings);
	g_static_rec_mutex_free (&self->priv->__lock_context);
	_vala_code_context_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->cancel);
	_vala_code_visitor_unref0 (self->priv->locator);
	_g_object_unref0 (self->priv->report);
	_g_object_unref0 (self->priv->provider);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	_vala_iterable_unref0 (self->priv->current_sources);
	G_OBJECT_CLASS (vala_plugin_parent_class)->finalize (obj);
}


GType vala_plugin_get_type (void) {
	return vala_plugin_type_id;
}


GType vala_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPlugin), 0, (GInstanceInitFunc) vala_plugin_instance_init, NULL };
	static const GInterfaceInfo ianjuta_preferences_info = { (GInterfaceInitFunc) vala_plugin_ianjuta_preferences_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vala_plugin_type_id = g_type_module_register_type (module, anjuta_plugin_get_type (), "ValaPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, vala_plugin_type_id, ianjuta_preferences_get_type (), &ianjuta_preferences_info);
	return vala_plugin_type_id;
}


GType anjuta_glue_register_components (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	block_locator_register_type (module);
	vala_plugin_register_type (module);
	vala_provider_register_type (module);
	anjuta_report_register_type (module);
	result = TYPE_VALA_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



