/* This file was written by Bryan Henderson in May 2005 and contributed
   to the public domain.
*/

#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#include "catgets/getline.h"


#define MAX(a,b) ((a) > (b) ? (a) : (b))

static void
enlargeBuffer(char **  const bufferP,
              size_t * const bufferSizeP,
              bool *   const errorP) {
        
    char * newBuffer;
    size_t newBufferSize;
        
    newBufferSize = MAX(128, *bufferSizeP * 2);
    
    newBuffer = realloc(*bufferP, newBufferSize);
    
    if (newBuffer == NULL)
        *errorP = true;
    else {
        *errorP      = false;
        *bufferP     = newBuffer;
        *bufferSizeP = newBufferSize;
    }
}



ssize_t
getline(char **  const bufferP,
        size_t * const bufferSizeP,
        FILE *   const fileP) {
    
    char * buffer;
    size_t bufferSize;
    size_t bytesInBuffer;
    bool error;
    bool gotline;
    
    buffer = *bufferP;
    bufferSize = *bufferSizeP;
    bytesInBuffer = 0;

    error = false;
    gotline = false;
    
    while (!gotline && !error) {
        if (bytesInBuffer == bufferSize)
            enlargeBuffer(&buffer, &bufferSize, &error);
        
        if (!error) {
            int c;
            
            c = getc(fileP);
            if (c == EOF)
                gotline = true;
            else {
                buffer[bytesInBuffer++] = c;
                if (c == '\n')
                    gotline = true;
            }
        }
    }
    if (gotline) {
        if (bytesInBuffer == bufferSize)
            enlargeBuffer(&buffer, &bufferSize, &error);
    
        if (!error)
            buffer[bytesInBuffer++] = '\0';
    }
    
    *bufferP     = buffer;
    *bufferSizeP = bufferSize;

    if (error)
        return -1;
    else
        return bytesInBuffer-1;  // exclude the terminating NUL
}



