
// {{{
const string TD1 = """
{
  "created_at" : "Mon May 05 06:48:32 +0000 2014",
  "id" : 463208606784311296,
  "id_str" : "463208606784311296",
  "text" : "RT @BlackForestTeam: DIESELSTORMERS Kickstarter is live! - Go and check it out right now!... http://t.co/ZVmefc0w5e",
  "source" : "web",
  "truncated" : false,
  "in_reply_to_status_id" : null,
  "in_reply_to_status_id_str" : null,
  "in_reply_to_user_id" : null,
  "in_reply_to_user_id_str" : null,
  "in_reply_to_screen_name" : null,
  "user" : {
    "id" : 62574927,
    "id_str" : "62574927",
    "name" : "Frozenbyte",
    "screen_name" : "Frozenbyte",
    "location" : "Helsinki, Finland",
    "description" : "We're an independent game developer. Follow us on Twitter to get the latest news on our games! For support issues please get in touch via email.",
    "url" : "http://t.co/NlgW9k9ZXj",
    "entities" : {
      "url" : {
        "urls" : [
          {
            "url" : "http://t.co/NlgW9k9ZXj",
            "expanded_url" : "http://www.frozenbyte.com",
            "display_url" : "frozenbyte.com",
            "indices" : [
              0,
              22
            ]
          }
        ]
      },
      "description" : {
        "urls" : [
        ]
      }
    },
    "protected" : false,
    "followers_count" : 5682,
    "friends_count" : 137,
    "listed_count" : 242,
    "created_at" : "Mon Aug 03 17:52:07 +0000 2009",
    "favourites_count" : 233,
    "utc_offset" : 10800,
    "time_zone" : "Helsinki",
    "geo_enabled" : false,
    "verified" : false,
    "statuses_count" : 1042,
    "lang" : "en",
    "contributors_enabled" : false,
    "is_translator" : false,
    "is_translation_enabled" : false,
    "profile_background_color" : "000000",
    "profile_background_image_url" : "http://pbs.twimg.com/profile_background_images/378800000117103508/abe5a14a1f3b0b78e9038e73bf6b812d.jpeg",
    "profile_background_image_url_https" : "https://pbs.twimg.com/profile_background_images/378800000117103508/abe5a14a1f3b0b78e9038e73bf6b812d.jpeg",
    "profile_background_tile" : false,
    "profile_image_url" : "http://pbs.twimg.com/profile_images/1130292729/fb_newlogo_black480_normal.png",
    "profile_image_url_https" : "https://pbs.twimg.com/profile_images/1130292729/fb_newlogo_black480_normal.png",
    "profile_link_color" : "CBA051",
    "profile_sidebar_border_color" : "000000",
    "profile_sidebar_fill_color" : "D4802D",
    "profile_text_color" : "4A2500",
    "profile_use_background_image" : true,
    "default_profile" : false,
    "default_profile_image" : false,
    "following" : true,
    "follow_request_sent" : false,
    "notifications" : false
  },
  "geo" : null,
  "coordinates" : null,
  "place" : null,
  "contributors" : null,
  "retweeted_status" : {
    "created_at" : "Tue Apr 29 11:00:25 +0000 2014",
    "id" : 461097667775725569,
    "id_str" : "461097667775725569",
    "text" : "DIESELSTORMERS Kickstarter is live! - Go and check it out right now!... http://t.co/ZVmefc0w5e",
    "source" : "<a href=\"http://www.tumblr.com/\" rel=\"nofollow\">Tumblr</a>",
    "truncated" : false,
    "in_reply_to_status_id" : null,
    "in_reply_to_status_id_str" : null,
    "in_reply_to_user_id" : null,
    "in_reply_to_user_id_str" : null,
    "in_reply_to_screen_name" : null,
    "user" : {
      "id" : 726763934,
      "id_str" : "726763934",
      "name" : "Black Forest Games",
      "screen_name" : "BlackForestTeam",
      "location" : "Offenburg",
      "description" : "South-german team that brought you Giana Sisters: Twisted Dreams",
      "url" : "http://t.co/BXuCnqlX50",
      "entities" : {
        "url" : {
          "urls" : [
            {
              "url" : "http://t.co/BXuCnqlX50",
              "expanded_url" : "http://gianasisterstwisteddreams.com",
              "display_url" : "gianasisterstwisteddreams.com",
              "indices" : [
                0,
                22
              ]
            }
          ]
        },
        "description" : {
          "urls" : [
          ]
        }
      },
      "protected" : false,
      "followers_count" : 1145,
      "friends_count" : 308,
      "listed_count" : 35,
      "created_at" : "Mon Jul 30 20:11:50 +0000 2012",
      "favourites_count" : 116,
      "utc_offset" : 7200,
      "time_zone" : "Amsterdam",
      "geo_enabled" : false,
      "verified" : false,
      "statuses_count" : 1475,
      "lang" : "en",
      "contributors_enabled" : false,
      "is_translator" : false,
      "is_translation_enabled" : false,
      "profile_background_color" : "C0DEED",
      "profile_background_image_url" : "http://abs.twimg.com/images/themes/theme1/bg.png",
      "profile_background_image_url_https" : "https://abs.twimg.com/images/themes/theme1/bg.png",
      "profile_background_tile" : false,
      "profile_image_url" : "http://pbs.twimg.com/profile_images/3694489354/ed399e59260bf71b10235dcd7eb56fe5_normal.png",
      "profile_image_url_https" : "https://pbs.twimg.com/profile_images/3694489354/ed399e59260bf71b10235dcd7eb56fe5_normal.png",
      "profile_banner_url" : "https://pbs.twimg.com/profile_banners/726763934/1369154494",
      "profile_link_color" : "0084B4",
      "profile_sidebar_border_color" : "C0DEED",
      "profile_sidebar_fill_color" : "DDEEF6",
      "profile_text_color" : "333333",
      "profile_use_background_image" : true,
      "default_profile" : true,
      "default_profile_image" : false,
      "following" : false,
      "follow_request_sent" : false,
      "notifications" : false
    },
    "geo" : null,
    "coordinates" : null,
    "place" : null,
    "contributors" : null,
    "retweet_count" : 6,
    "favorite_count" : 2,
    "entities" : {
      "hashtags" : [
      ],
      "symbols" : [
      ],
      "urls" : [
        {
          "url" : "http://t.co/ZVmefc0w5e",
          "expanded_url" : "http://tmblr.co/ZTqD4s1ERcDZg",
          "display_url" : "tmblr.co/ZTqD4s1ERcDZg",
          "indices" : [
            72,
            94
          ]
        }
      ],
      "user_mentions" : [
      ]
    },
    "favorited" : false,
    "retweeted" : false,
    "possibly_sensitive" : false,
    "lang" : "en"
  },
  "retweet_count" : 6,
  "favorite_count" : 0,
  "entities" : {
    "hashtags" : [
    ],
    "symbols" : [
    ],
    "urls" : [
      {
        "url" : "http://t.co/ZVmefc0w5e",
        "expanded_url" : "http://tmblr.co/ZTqD4s1ERcDZg",
        "display_url" : "tmblr.co/ZTqD4s1ERcDZg",
        "indices" : [
          93,
          115
        ]
      }
    ],
    "user_mentions" : [
      {
        "screen_name" : "BlackForestTeam",
        "name" : "Black Forest Games",
        "id" : 726763934,
        "id_str" : "726763934",
        "indices" : [
          3,
          19
        ]
      }
    ]
  },
  "favorited" : false,
  "retweeted" : false,
  "possibly_sensitive" : false,
  "lang" : "en"
}
""";


const string TD2 = """

{
  "created_at" : "Wed May 07 12:44:02 +0000 2014",
  "id" : 464022846965288960,
  "id_str" : "464022846965288960",
  "text" : "http://t.co/O5uZwJg31k    http://t.co/BsKkxv8UG4    http://t.co/W8qs846ude   http://t.co/x4bKoCusvQ",
  "source" : "web",
  "truncated" : false,
  "in_reply_to_status_id" : null,
  "in_reply_to_status_id_str" : null,
  "in_reply_to_user_id" : null,
  "in_reply_to_user_id_str" : null,
  "in_reply_to_screen_name" : null,
  "user" : {
    "id" : 993713617,
    "id_str" : "993713617",
    "name" : "Core Bird",
    "screen_name" : "corebirdgtk",
    "location" : "",
    "description" : "",
    "url" : null,
    "entities" : {
      "description" : {
        "urls" : [
        ]
      }
    },
    "protected" : true,
    "followers_count" : 1,
    "friends_count" : 5,
    "listed_count" : 0,
    "created_at" : "Thu Dec 06 19:47:16 +0000 2012",
    "favourites_count" : 10,
    "utc_offset" : 7200,
    "time_zone" : "Amsterdam",
    "geo_enabled" : false,
    "verified" : false,
    "statuses_count" : 520,
    "lang" : "en",
    "contributors_enabled" : false,
    "is_translator" : false,
    "is_translation_enabled" : false,
    "profile_background_color" : "C0DEED",
    "profile_background_image_url" : "http://abs.twimg.com/images/themes/theme1/bg.png",
    "profile_background_image_url_https" : "https://abs.twimg.com/images/themes/theme1/bg.png",
    "profile_background_tile" : false,
    "profile_image_url" : "http://abs.twimg.com/sticky/default_profile_images/default_profile_1_normal.png",
    "profile_image_url_https" : "https://abs.twimg.com/sticky/default_profile_images/default_profile_1_normal.png",
    "profile_link_color" : "0084B4",
    "profile_sidebar_border_color" : "C0DEED",
    "profile_sidebar_fill_color" : "DDEEF6",
    "profile_text_color" : "333333",
    "profile_use_background_image" : true,
    "default_profile" : true,
    "default_profile_image" : true,
    "following" : true,
    "follow_request_sent" : false,
    "notifications" : false
  },
  "geo" : null,
  "coordinates" : null,
  "place" : null,
  "contributors" : null,
  "retweet_count" : 0,
  "favorite_count" : 0,
  "entities" : {
    "hashtags" : [
    ],
    "symbols" : [
    ],
    "urls" : [
      {
        "url" : "http://t.co/O5uZwJg31k",
        "expanded_url" : "http://mirgehendirurlsaus.com",
        "display_url" : "mirgehendirurlsaus.com",
        "indices" : [
          0,
          22
        ]
      },
      {
        "url" : "http://t.co/BsKkxv8UG4",
        "expanded_url" : "http://foobar.com",
        "display_url" : "foobar.com",
        "indices" : [
          26,
          48
        ]
      },
      {
        "url" : "http://t.co/W8qs846ude",
        "expanded_url" : "http://hahaaha.com",
        "display_url" : "hahaaha.com",
        "indices" : [
          52,
          74
        ]
      },
      {
        "url" : "http://t.co/x4bKoCusvQ",
        "expanded_url" : "http://huehue.org",
        "display_url" : "huehue.org",
        "indices" : [
          77,
          99
        ]
      }
    ],
    "user_mentions" : [
    ]
  },
  "favorited" : false,
  "retweeted" : false,
  "possibly_sensitive" : false,
  "lang" : "und"
}

""";
// }}}


void real_text () {
  var parser = new Json.Parser ();
  var now  = new GLib.DateTime.now_local ();
  var acc = new Account (12345, "foobar", "foo bar");
  try {
    parser.load_from_data (TD1);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  Tweet t = new Tweet ();
  t.load_from_json (parser.get_root (), now, acc);
  message (t.get_formatted_text ());
  message ("DIESELSTORMERS Kickstarter is live! - Go and check it out right now!... " +
"<span underline='none'><a href=\"http://tmblr.co/ZTqD4s1ERcDZg\" " +
"title=\"http://tmblr.co/ZTqD4s1ERcDZg\">tmblr.co/ZTqD4s1ERcDZg</a></span>");
  assert (t.get_formatted_text () == "DIESELSTORMERS Kickstarter is live! - Go and check it out right now!..."+
" <span underline='none'><a href=\"http://tmblr.co/ZTqD4s1ERcDZg\" " +
"title=\"http://tmblr.co/ZTqD4s1ERcDZg\">tmblr.co/ZTqD4s1ERcDZg</a></span>");

}



void text_consistency () {
  var parser = new Json.Parser ();
  var now  = new GLib.DateTime.now_local ();
  var acc = new Account (12345, "foobar", "foo bar");
  try {
    parser.load_from_data (TD2);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  Tweet t = new Tweet ();
  t.load_from_json (parser.get_root (), now, acc);

  string text_before = t.text;
  t.get_real_text ();
  string text_after = t.text;
  assert (text_before == text_after);

  string formatted = t.get_formatted_text ();
  string spec = """<span underline='none'><a href="http://mirgehendirurlsaus.com" title="http://mirgehendirurlsaus.com">mirgehendirurlsaus.com</a></span>    <span underline='none'><a href="http://foobar.com" title="http://foobar.com">foobar.com</a></span>    <span underline='none'><a href="http://hahaaha.com" title="http://hahaaha.com">hahaaha.com</a></span>   <span underline='none'><a href="http://huehue.org" title="http://huehue.org">huehue.org</a></span>""";
  stdout.printf (formatted + "\n");
  stdout.printf (spec+ "\n");

  assert (formatted == spec);
}



int main (string[] args) {
  GLib.Test.init (ref args);
  Settings.init ();
  Twitter.get ().init ();
  Utils.init_soup_session ();
  GLib.Test.add_func ("/tweet-entities/real-text", real_text);
  GLib.Test.add_func ("/tweet-entities/text-consistency", text_consistency);

  return GLib.Test.run ();
}
