/* ListsPage.c generated by valac 0.26.2, the Vala compiler
 * generated from ListsPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;
typedef struct _ListsPagePrivate ListsPagePrivate;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ListsPageLoadNewestData ListsPageLoadNewestData;

#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
typedef struct _ListsPageGetUserListsData ListsPageGetUserListsData;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _ListsPage {
	ScrollWidget parent_instance;
	ListsPagePrivate * priv;
};

struct _ListsPageClass {
	ScrollWidgetClass parent_class;
};

struct _ListsPagePrivate {
	BadgeRadioToolButton* tool_button;
	Account* _account;
	MainWindow* _main_window;
	gint _unread_count;
	DeltaUpdater* _delta_updater;
	gint _id;
	gboolean inited;
	gint64 user_id;
	UserListsWidget* user_lists_widget;
};

struct _ListsPageLoadNewestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListsPage* self;
	UserListsWidget* _tmp0_;
	gint64 _tmp1_;
};

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
};

struct _ListsPageGetUserListsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListsPage* self;
	TwitterList* result;
	gint result_length1;
	gboolean _tmp0_;
	UserListsWidget* _tmp1_;
	gint64 _tmp2_;
	UserListsWidget* _tmp3_;
	gint _tmp4_;
	TwitterList* _tmp5_;
	TwitterList* _tmp6_;
	gint _tmp6__length1;
};


static gpointer lists_page_parent_class = NULL;
static IPageIface* lists_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* lists_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType lists_page_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType user_lists_widget_get_type (void) G_GNUC_CONST;
#define LISTS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LISTS_PAGE, ListsPagePrivate))
enum  {
	LISTS_PAGE_DUMMY_PROPERTY,
	LISTS_PAGE_UNREAD_COUNT,
	LISTS_PAGE_MAIN_WINDOW,
	LISTS_PAGE_ACCOUNT,
	LISTS_PAGE_DELTA_UPDATER,
	LISTS_PAGE_ID
};
#define LISTS_PAGE_MODE_DELETE 1
ListsPage* lists_page_new (gint id);
ListsPage* lists_page_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
static void lists_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint bundle_get_int (Bundle* self, const gchar* key);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
static void lists_page_load_newest (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void lists_page_load_newest_finish (ListsPage* self, GAsyncResult* _res_);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id);
static void lists_page_real_on_leave (IPage* base);
void user_lists_widget_unreveal (UserListsWidget* self);
static void lists_page_load_newest_data_free (gpointer _data);
static gboolean lists_page_load_newest_co (ListsPageLoadNewestData* _data_);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static void lists_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void lists_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
GType list_list_entry_get_type (void) G_GNUC_CONST;
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry);
static void lists_page_update_list (ListsPage* self, gint64 list_id, JsonObject* obj);
void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase);
static void _vala_TwitterList_array_free (TwitterList* array, gint array_length);
static void lists_page_get_user_lists_data_free (gpointer _data);
GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1);
static gboolean lists_page_get_user_lists_co (ListsPageGetUserListsData* _data_);
static void lists_page_get_user_lists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1);
void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode);
static void lists_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static gchar* lists_page_real_get_title (IPage* base);
static GtkRadioButton* lists_page_real_get_tool_button (IPage* base);
gint lists_page_get_unread_count (ListsPage* self);
void lists_page_set_unread_count (ListsPage* self, gint value);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
DeltaUpdater* lists_page_get_delta_updater (ListsPage* self);
void lists_page_set_delta_updater (ListsPage* self, DeltaUpdater* value);
static void lists_page_finalize (GObject* obj);
MainWindow* ipage_get_main_window (IPage* self);
gint ipage_get_id (IPage* self);
static void _vala_lists_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_lists_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ListsPage* lists_page_construct (GType object_type, gint id) {
	ListsPage * self = NULL;
	gint _tmp0_ = 0;
	self = (ListsPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	return self;
}


ListsPage* lists_page_new (gint id) {
	return lists_page_construct (TYPE_LISTS_PAGE, id);
}


static void lists_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	ListsPage * self;
	gint mode = 0;
	GNetworkMonitor* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Bundle* _tmp2_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	mode = 0;
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_network_available (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = args;
	if (_tmp2_ != NULL) {
		Bundle* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = args;
		_tmp4_ = bundle_get_int (_tmp3_, "mode");
		mode = _tmp4_;
	}
	_tmp6_ = mode;
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->inited;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Account* _tmp8_ = NULL;
		Account* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		gint64 _tmp11_ = 0LL;
		self->priv->inited = TRUE;
		_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp9_ = _tmp8_;
		_tmp10_ = account_get_id (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->user_id = _tmp11_;
		lists_page_load_newest (self, NULL, NULL);
	} else {
		gint _tmp12_ = 0;
		_tmp12_ = mode;
		if (_tmp12_ == LISTS_PAGE_MODE_DELETE) {
			gint64 list_id = 0LL;
			Bundle* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			UserListsWidget* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			_tmp13_ = args;
			_tmp14_ = bundle_get_int64 (_tmp13_, "list_id");
			list_id = _tmp14_;
			_tmp15_ = list_id;
			_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat ("Deleting list with id ", _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			g_message ("ListsPage.vala:71: %s", _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_tmp20_ = self->priv->user_lists_widget;
			_tmp21_ = list_id;
			user_lists_widget_remove_list (_tmp20_, _tmp21_);
		}
	}
}


static void lists_page_real_on_leave (IPage* base) {
	ListsPage * self;
	UserListsWidget* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->user_lists_widget;
	user_lists_widget_unreveal (_tmp0_);
}


static void lists_page_load_newest_data_free (gpointer _data) {
	ListsPageLoadNewestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListsPageLoadNewestData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void lists_page_load_newest (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListsPageLoadNewestData* _data_;
	ListsPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListsPageLoadNewestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lists_page_load_newest);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lists_page_load_newest_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lists_page_load_newest_co (_data_);
}


static void lists_page_load_newest_finish (ListsPage* self, GAsyncResult* _res_) {
	ListsPageLoadNewestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void lists_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListsPageLoadNewestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lists_page_load_newest_co (_data_);
}


static gboolean lists_page_load_newest_co (ListsPageLoadNewestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->user_lists_widget;
	_data_->_tmp1_ = 0LL;
	_data_->_tmp1_ = _data_->self->priv->user_id;
	_data_->_state_ = 1;
	user_lists_widget_load_lists (_data_->_tmp0_, _data_->_tmp1_, lists_page_load_newest_ready, _data_);
	return FALSE;
	_state_1:
	user_lists_widget_load_lists_finish (_data_->_tmp0_, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void lists_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	ListsPage * self;
	gboolean _tmp0_ = FALSE;
	StreamMessageType _tmp1_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail (root != NULL);
	_tmp1_ = type;
	if (_tmp1_ == STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED) {
		_tmp0_ = TRUE;
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		_tmp0_ = _tmp2_ == STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED;
	}
	if (_tmp0_) {
		JsonObject* obj = NULL;
		JsonNode* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		JsonObject* _tmp6_ = NULL;
		ListListEntry* entry = NULL;
		JsonObject* _tmp7_ = NULL;
		Account* _tmp8_ = NULL;
		Account* _tmp9_ = NULL;
		ListListEntry* _tmp10_ = NULL;
		UserListsWidget* _tmp11_ = NULL;
		ListListEntry* _tmp12_ = NULL;
		_tmp3_ = root;
		_tmp4_ = json_node_get_object (_tmp3_);
		_tmp5_ = json_object_get_object_member (_tmp4_, "target_object");
		_tmp6_ = _json_object_ref0 (_tmp5_);
		obj = _tmp6_;
		_tmp7_ = obj;
		_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp9_ = _tmp8_;
		_tmp10_ = list_list_entry_new_from_json_data (_tmp7_, _tmp9_);
		g_object_ref_sink (_tmp10_);
		entry = _tmp10_;
		_tmp11_ = self->priv->user_lists_widget;
		_tmp12_ = entry;
		user_lists_widget_add_list (_tmp11_, _tmp12_);
		_g_object_unref0 (entry);
		_json_object_unref0 (obj);
	} else {
		gboolean _tmp13_ = FALSE;
		StreamMessageType _tmp14_ = 0;
		_tmp14_ = type;
		if (_tmp14_ == STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED) {
			_tmp13_ = TRUE;
		} else {
			StreamMessageType _tmp15_ = 0;
			_tmp15_ = type;
			_tmp13_ = _tmp15_ == STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED;
		}
		if (_tmp13_) {
			JsonObject* obj = NULL;
			JsonNode* _tmp16_ = NULL;
			JsonObject* _tmp17_ = NULL;
			JsonObject* _tmp18_ = NULL;
			JsonObject* _tmp19_ = NULL;
			gint64 list_id = 0LL;
			JsonObject* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			UserListsWidget* _tmp22_ = NULL;
			gint64 _tmp23_ = 0LL;
			_tmp16_ = root;
			_tmp17_ = json_node_get_object (_tmp16_);
			_tmp18_ = json_object_get_object_member (_tmp17_, "target_object");
			_tmp19_ = _json_object_ref0 (_tmp18_);
			obj = _tmp19_;
			_tmp20_ = obj;
			_tmp21_ = json_object_get_int_member (_tmp20_, "id");
			list_id = _tmp21_;
			_tmp22_ = self->priv->user_lists_widget;
			_tmp23_ = list_id;
			user_lists_widget_remove_list (_tmp22_, _tmp23_);
			_json_object_unref0 (obj);
		} else {
			StreamMessageType _tmp24_ = 0;
			_tmp24_ = type;
			if (_tmp24_ == STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED) {
				JsonObject* obj = NULL;
				JsonNode* _tmp25_ = NULL;
				JsonObject* _tmp26_ = NULL;
				JsonObject* _tmp27_ = NULL;
				JsonObject* _tmp28_ = NULL;
				gint64 list_id = 0LL;
				JsonObject* _tmp29_ = NULL;
				gint64 _tmp30_ = 0LL;
				gint64 _tmp31_ = 0LL;
				JsonObject* _tmp32_ = NULL;
				_tmp25_ = root;
				_tmp26_ = json_node_get_object (_tmp25_);
				_tmp27_ = json_object_get_object_member (_tmp26_, "target_object");
				_tmp28_ = _json_object_ref0 (_tmp27_);
				obj = _tmp28_;
				_tmp29_ = obj;
				_tmp30_ = json_object_get_int_member (_tmp29_, "id");
				list_id = _tmp30_;
				_tmp31_ = list_id;
				_tmp32_ = obj;
				lists_page_update_list (self, _tmp31_, _tmp32_);
				_json_object_unref0 (obj);
			} else {
				StreamMessageType _tmp33_ = 0;
				_tmp33_ = type;
				if (_tmp33_ == STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED) {
					JsonObject* obj = NULL;
					JsonNode* _tmp34_ = NULL;
					JsonObject* _tmp35_ = NULL;
					JsonObject* _tmp36_ = NULL;
					JsonObject* _tmp37_ = NULL;
					gint64 list_id = 0LL;
					JsonObject* _tmp38_ = NULL;
					gint64 _tmp39_ = 0LL;
					UserListsWidget* _tmp40_ = NULL;
					gint64 _tmp41_ = 0LL;
					_tmp34_ = root;
					_tmp35_ = json_node_get_object (_tmp34_);
					_tmp36_ = json_object_get_object_member (_tmp35_, "target_object");
					_tmp37_ = _json_object_ref0 (_tmp36_);
					obj = _tmp37_;
					_tmp38_ = obj;
					_tmp39_ = json_object_get_int_member (_tmp38_, "id");
					list_id = _tmp39_;
					_tmp40_ = self->priv->user_lists_widget;
					_tmp41_ = list_id;
					user_lists_widget_update_member_count (_tmp40_, _tmp41_, 1);
					_json_object_unref0 (obj);
				} else {
					StreamMessageType _tmp42_ = 0;
					_tmp42_ = type;
					if (_tmp42_ == STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED) {
						JsonObject* obj = NULL;
						JsonNode* _tmp43_ = NULL;
						JsonObject* _tmp44_ = NULL;
						JsonObject* _tmp45_ = NULL;
						JsonObject* _tmp46_ = NULL;
						gint64 list_id = 0LL;
						JsonObject* _tmp47_ = NULL;
						gint64 _tmp48_ = 0LL;
						UserListsWidget* _tmp49_ = NULL;
						gint64 _tmp50_ = 0LL;
						_tmp43_ = root;
						_tmp44_ = json_node_get_object (_tmp43_);
						_tmp45_ = json_object_get_object_member (_tmp44_, "target_object");
						_tmp46_ = _json_object_ref0 (_tmp45_);
						obj = _tmp46_;
						_tmp47_ = obj;
						_tmp48_ = json_object_get_int_member (_tmp47_, "id");
						list_id = _tmp48_;
						_tmp49_ = self->priv->user_lists_widget;
						_tmp50_ = list_id;
						user_lists_widget_update_member_count (_tmp49_, _tmp50_, -1);
						_json_object_unref0 (obj);
					}
				}
			}
		}
	}
}


static void _vala_TwitterList_array_free (TwitterList* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void lists_page_get_user_lists_data_free (gpointer _data) {
	ListsPageGetUserListsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_TwitterList_array_free (_data_->result, _data_->result_length1), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ListsPageGetUserListsData, _data_);
}


void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListsPageGetUserListsData* _data_;
	ListsPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListsPageGetUserListsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lists_page_get_user_lists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lists_page_get_user_lists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lists_page_get_user_lists_co (_data_);
}


TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1) {
	TwitterList* result;
	ListsPageGetUserListsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void lists_page_get_user_lists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListsPageGetUserListsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lists_page_get_user_lists_co (_data_);
}


static gboolean lists_page_get_user_lists_co (ListsPageGetUserListsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->inited;
	if (!_data_->_tmp0_) {
		_data_->self->priv->inited = TRUE;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->user_lists_widget;
		_data_->_tmp2_ = 0LL;
		_data_->_tmp2_ = _data_->self->priv->user_id;
		_data_->_state_ = 1;
		user_lists_widget_load_lists (_data_->_tmp1_, _data_->_tmp2_, lists_page_get_user_lists_ready, _data_);
		return FALSE;
		_state_1:
		user_lists_widget_load_lists_finish (_data_->_tmp1_, _data_->_res_);
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->user_lists_widget;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = user_lists_widget_get_user_lists (_data_->_tmp3_, &_data_->_tmp4_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6__length1 = 0;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp4_;
	_data_->result_length1 = _data_->_tmp6__length1;
	_data_->result = _data_->_tmp6_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void lists_page_update_list (ListsPage* self, gint64 list_id, JsonObject* obj) {
	gchar* name = NULL;
	JsonObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* description = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* mode = NULL;
	JsonObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	UserListsWidget* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	g_return_if_fail (IS_LISTS_PAGE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = json_object_get_string_member (_tmp0_, "full_name");
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "description");
	_tmp5_ = g_strdup (_tmp4_);
	description = _tmp5_;
	_tmp6_ = obj;
	_tmp7_ = json_object_get_string_member (_tmp6_, "mode");
	_tmp8_ = g_strdup (_tmp7_);
	mode = _tmp8_;
	_tmp9_ = self->priv->user_lists_widget;
	_tmp10_ = list_id;
	user_lists_widget_update_list (_tmp9_, _tmp10_, name, description, mode);
	_g_free0 (mode);
	_g_free0 (description);
	_g_free0 (name);
}


static void lists_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	ListsPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Lists");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "view-list-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tool_button);
	self->priv->tool_button = _tmp2_;
}


static gchar* lists_page_real_get_title (IPage* base) {
	ListsPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = _ ("Lists");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static GtkRadioButton* lists_page_real_get_tool_button (IPage* base) {
	ListsPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioToolButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


gint lists_page_get_unread_count (ListsPage* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_LISTS_PAGE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void lists_page_set_unread_count (ListsPage* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_LISTS_PAGE (self));
	_tmp0_ = value;
	self->priv->_unread_count = _tmp0_;
	g_object_notify ((GObject *) self, "unread-count");
}


static MainWindow* lists_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	ListsPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void lists_page_real_set_main_window (IPage* base, MainWindow* value) {
	ListsPage* self;
	UserListsWidget* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->user_lists_widget;
	_tmp1_ = value;
	user_lists_widget_set_main_window (_tmp0_, _tmp1_);
	_tmp2_ = value;
	self->priv->_main_window = _tmp2_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* lists_page_real_get_account (IPage* base) {
	Account* result;
	ListsPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void lists_page_real_set_account (IPage* base, Account* value) {
	ListsPage* self;
	UserListsWidget* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->user_lists_widget;
	_tmp1_ = value;
	user_lists_widget_set_account (_tmp0_, _tmp1_);
	_tmp2_ = value;
	self->priv->_account = _tmp2_;
	g_object_notify ((GObject *) self, "account");
}


DeltaUpdater* lists_page_get_delta_updater (ListsPage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_LISTS_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void lists_page_set_delta_updater (ListsPage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_LISTS_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static gint lists_page_real_get_id (IPage* base) {
	gint result;
	ListsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void lists_page_real_set_id (IPage* base, gint value) {
	ListsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void lists_page_class_init (ListsPageClass * klass) {
	gint ListsPage_private_offset;
	lists_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_lists_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_lists_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = lists_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ListsPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/lists-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_lists_widget", FALSE, ListsPage_private_offset + G_STRUCT_OFFSET (ListsPagePrivate, user_lists_widget));
}


static void lists_page_ipage_interface_init (IPageIface * iface) {
	lists_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) lists_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) lists_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) lists_page_real_create_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) lists_page_real_get_title;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) lists_page_real_get_tool_button;
	iface->get_main_window = lists_page_real_get_main_window;
	iface->set_main_window = lists_page_real_set_main_window;
	iface->get_account = lists_page_real_get_account;
	iface->set_account = lists_page_real_set_account;
	iface->get_id = lists_page_real_get_id;
	iface->set_id = lists_page_real_set_id;
}


static void lists_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	lists_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) lists_page_real_stream_message_received;
}


static void lists_page_instance_init (ListsPage * self) {
	self->priv = LISTS_PAGE_GET_PRIVATE (self);
	self->priv->inited = FALSE;
	g_type_ensure (TYPE_USER_LISTS_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void lists_page_finalize (GObject* obj) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LISTS_PAGE, ListsPage);
	_g_object_unref0 (self->priv->tool_button);
	_g_object_unref0 (self->priv->user_lists_widget);
	G_OBJECT_CLASS (lists_page_parent_class)->finalize (obj);
}


GType lists_page_get_type (void) {
	static volatile gsize lists_page_type_id__volatile = 0;
	if (g_once_init_enter (&lists_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lists_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListsPage), 0, (GInstanceInitFunc) lists_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) lists_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) lists_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType lists_page_type_id;
		lists_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ListsPage", &g_define_type_info, 0);
		g_type_add_interface_static (lists_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (lists_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&lists_page_type_id__volatile, lists_page_type_id);
	}
	return lists_page_type_id__volatile;
}


static void _vala_lists_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LISTS_PAGE, ListsPage);
	switch (property_id) {
		case LISTS_PAGE_UNREAD_COUNT:
		g_value_set_int (value, lists_page_get_unread_count (self));
		break;
		case LISTS_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case LISTS_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case LISTS_PAGE_DELTA_UPDATER:
		g_value_set_object (value, lists_page_get_delta_updater (self));
		break;
		case LISTS_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_lists_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LISTS_PAGE, ListsPage);
	switch (property_id) {
		case LISTS_PAGE_UNREAD_COUNT:
		lists_page_set_unread_count (self, g_value_get_int (value));
		break;
		case LISTS_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case LISTS_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case LISTS_PAGE_DELTA_UPDATER:
		lists_page_set_delta_updater (self, g_value_get_object (value));
		break;
		case LISTS_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



