/* TweetInfoPage.c generated by valac 0.26.2, the Vala compiler
 * generated from TweetInfoPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;
typedef struct _TweetInfoPagePrivate TweetInfoPagePrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;

#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block30Data Block30Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block31Data Block31Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block32Data Block32Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _TweetInfoPage {
	ScrollWidget parent_instance;
	TweetInfoPagePrivate * priv;
};

struct _TweetInfoPageClass {
	ScrollWidgetClass parent_class;
};

struct _TweetInfoPagePrivate {
	gint _id;
	MainWindow* _main_window;
	Account* _account;
	gint64 tweet_id;
	gchar* screen_name;
	gboolean values_set;
	Tweet* tweet;
	MultiMediaWidget* mm_widget;
	GtkLabel* text_label;
	TextButton* name_button;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkLabel* rt_label;
	GtkLabel* fav_label;
	GtkListBox* bottom_list_box;
	GtkListBox* top_list_box;
	GtkToggleButton* favorite_button;
	GtkToggleButton* retweet_button;
	GtkLabel* time_label;
	GtkLabel* source_label;
	MaxSizeContainer* max_size_container;
	ReplyIndicator* reply_indicator;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block30Data {
	int _ref_count_;
	TweetInfoPage* self;
	GDateTime* now;
};

struct _Block31Data {
	int _ref_count_;
	Block30Data * _data30_;
	gint n_replies;
};

struct _Block32Data {
	int _ref_count_;
	TweetInfoPage* self;
	RestProxyCall* call;
};


static gpointer tweet_info_page_parent_class = NULL;
static IPageIface* tweet_info_page_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_info_page_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
GType reply_indicator_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_INFO_PAGE, TweetInfoPagePrivate))
enum  {
	TWEET_INFO_PAGE_DUMMY_PROPERTY,
	TWEET_INFO_PAGE_UNREAD_COUNT,
	TWEET_INFO_PAGE_ID,
	TWEET_INFO_PAGE_MAIN_WINDOW,
	TWEET_INFO_PAGE_ACCOUNT
};
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_BY_ID 2
static void tweet_info_page_quote_activated (TweetInfoPage* self);
static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetInfoPage* tweet_info_page_new (gint id);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
GType media_get_type (void) G_GNUC_CONST;
static void __lambda74_ (TweetInfoPage* self, Media* m, gint i);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
MainWindow* ipage_get_main_window (IPage* self);
static void ___lambda74__multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self);
static gboolean __lambda75_ (TweetInfoPage* self, GdkEventScroll* evt);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static gboolean ___lambda75__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
gint itwitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void __lambda76_ (TweetInfoPage* self, GtkListBoxRow* row);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda76__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda77_ (TweetInfoPage* self, GtkListBoxRow* row);
static void ___lambda77__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint bundle_get_int (Bundle* self, const gchar* key);
GObject* bundle_get_object (Bundle* self, const gchar* key);
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, Tweet* tweet, const gchar* with);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void __lambda78_ (TweetInfoPage* self, GtkWidget* w);
static void ___lambda78__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda79_ (TweetInfoPage* self, GtkWidget* w);
static void ___lambda79__gtk_callback (GtkWidget* widget, gpointer self);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
static void tweet_info_page_query_tweet_info (TweetInfoPage* self);
static void tweet_info_page_real_on_leave (IPage* base);
static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
Account* ipage_get_account (IPage* self);
static void __lambda84_ (TweetInfoPage* self);
static void ___lambda84__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static void __lambda85_ (TweetInfoPage* self);
static void ___lambda85__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void __lambda80_ (Block30Data* _data30_, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str);
static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id);
static void ___lambda80__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda82_ (Block30Data* _data30_, GObject* _, GAsyncResult* res);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda83_ (Block31Data* _data31_, JsonArray* arr, guint index, JsonNode* node);
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
static void ___lambda83__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda82__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda81_ (Block32Data* _data32_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
gchar* tweet_get_formatted_text (Tweet* self);
GdkPixbuf* tweet_get_avatar (Tweet* self);
gboolean tweet_get_retweeted (Tweet* self);
gboolean tweet_get_favorited (Tweet* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name);
gboolean tweet_get_has_inline_media (Tweet* self);
void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1);
gint64 account_get_id (Account* self);
static gchar* tweet_info_page_real_get_title (IPage* base);
static void tweet_info_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* tweet_info_page_real_get_tool_button (IPage* base);
gint tweet_info_page_get_unread_count (TweetInfoPage* self);
void tweet_info_page_set_unread_count (TweetInfoPage* self, gint value);
static void tweet_info_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
void ipage_set_account (IPage* self, Account* value);
static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_INFO_PAGE_action_entries[1] = {{"quote", _tweet_info_page_quote_activated_gsimple_action_activate_callback}};

static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_quote_activated ((TweetInfoPage*) self);
}


static void __lambda74_ (TweetInfoPage* self, Media* m, gint i) {
	Tweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (IS_MEDIA (m));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = i;
	tweet_utils_handle_media_click (_tmp0_, _tmp2_, _tmp3_);
}


static void ___lambda74__multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self) {
	__lambda74_ ((TweetInfoPage*) self, m, index);
}


static gboolean __lambda75_ (TweetInfoPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventScroll* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->delta_y;
	if (_tmp3_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ReplyIndicator* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = self->priv->reply_indicator;
		_tmp9_ = reply_indicator_get_replies_available (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp11_ = NULL;
		GtkAdjustment* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		GdkEventScroll* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		MaxSizeContainer* _tmp17_ = NULL;
		MaxSizeContainer* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		MaxSizeContainer* _tmp22_ = NULL;
		_tmp11_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_step_increment (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = evt;
		_tmp16_ = _tmp15_->delta_y;
		inc = (gint) (_tmp14_ * (-_tmp16_));
		_tmp17_ = self->priv->max_size_container;
		_tmp18_ = self->priv->max_size_container;
		_tmp19_ = max_size_container_get_max_size (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = inc;
		max_size_container_set_max_size (_tmp18_, _tmp20_ + _tmp21_);
		_tmp22_ = self->priv->max_size_container;
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda75__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = __lambda75_ ((TweetInfoPage*) self, event);
	return result;
}


static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func_inv (row1, row2);
	return result;
}


static void __lambda76_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	_tmp3_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda76__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda76_ ((TweetInfoPage*) self, row);
}


static void __lambda77_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	_tmp3_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda77__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda77_ ((TweetInfoPage*) self, row);
}


TweetInfoPage* tweet_info_page_construct (GType object_type, gint id) {
	TweetInfoPage * self = NULL;
	gint _tmp0_ = 0;
	MultiMediaWidget* _tmp1_ = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp5_ = NULL;
	self = (TweetInfoPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = self->priv->mm_widget;
	g_signal_connect_object (_tmp1_, "media-clicked", (GCallback) ___lambda74__multi_media_widget_media_clicked, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) ___lambda75__gtk_widget_scroll_event, self, 0);
	_tmp2_ = self->priv->top_list_box;
	gtk_list_box_set_sort_func (_tmp2_, _itwitter_item_sort_func_inv_gtk_list_box_sort_func, NULL, NULL);
	_tmp3_ = self->priv->bottom_list_box;
	g_signal_connect_object (_tmp3_, "row-activated", (GCallback) ___lambda76__gtk_list_box_row_activated, self, 0);
	_tmp4_ = self->priv->top_list_box;
	g_signal_connect_object (_tmp4_, "row-activated", (GCallback) ___lambda77__gtk_list_box_row_activated, self, 0);
	_tmp5_ = g_simple_action_group_new ();
	actions = _tmp5_;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (actions, g_action_map_get_type (), GActionMap), TWEET_INFO_PAGE_action_entries, G_N_ELEMENTS (TWEET_INFO_PAGE_action_entries), self);
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (actions, g_action_group_get_type (), GActionGroup));
	_g_object_unref0 (actions);
	return self;
}


TweetInfoPage* tweet_info_page_new (gint id) {
	return tweet_info_page_construct (TYPE_TWEET_INFO_PAGE, id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda78_ (TweetInfoPage* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->bottom_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda78__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda78_ ((TweetInfoPage*) self, widget);
}


static void __lambda79_ (TweetInfoPage* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->top_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda79__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda79_ ((TweetInfoPage*) self, widget);
}


static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	TweetInfoPage * self;
	gint mode = 0;
	Bundle* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkListBox* _tmp23_ = NULL;
	GtkListBox* _tmp24_ = NULL;
	GtkListBox* _tmp25_ = NULL;
	GtkListBox* _tmp26_ = NULL;
	ReplyIndicator* _tmp27_ = NULL;
	MaxSizeContainer* _tmp28_ = NULL;
	MaxSizeContainer* _tmp29_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int (_tmp0_, "mode");
	mode = _tmp1_;
	_tmp2_ = mode;
	if (_tmp2_ == 0) {
		return;
	}
	self->priv->values_set = FALSE;
	_tmp3_ = mode;
	if (_tmp3_ == TWEET_INFO_PAGE_BY_INSTANCE) {
		Tweet* tweet = NULL;
		Bundle* _tmp4_ = NULL;
		GObject* _tmp5_ = NULL;
		Tweet* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		Tweet* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		Tweet* _tmp15_ = NULL;
		Tweet* _tmp16_ = NULL;
		Tweet* _tmp17_ = NULL;
		_tmp4_ = args;
		_tmp5_ = bundle_get_object (_tmp4_, "tweet");
		tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TWEET, Tweet);
		_tmp6_ = tweet;
		_tmp7_ = _tmp6_->is_retweet;
		if (_tmp7_) {
			Tweet* _tmp8_ = NULL;
			gint64 _tmp9_ = 0LL;
			_tmp8_ = tweet;
			_tmp9_ = _tmp8_->rt_id;
			self->priv->tweet_id = _tmp9_;
		} else {
			Tweet* _tmp10_ = NULL;
			gint64 _tmp11_ = 0LL;
			_tmp10_ = tweet;
			_tmp11_ = _tmp10_->id;
			self->priv->tweet_id = _tmp11_;
		}
		_tmp12_ = tweet;
		_tmp13_ = _tmp12_->screen_name;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp14_;
		_tmp15_ = tweet;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp16_;
		_tmp17_ = tweet;
		tweet_info_page_set_tweet_data (self, _tmp17_, NULL);
		_g_object_unref0 (tweet);
	} else {
		gint _tmp18_ = 0;
		_tmp18_ = mode;
		if (_tmp18_ == TWEET_INFO_PAGE_BY_ID) {
			Bundle* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Bundle* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			_tmp19_ = args;
			_tmp20_ = bundle_get_int64 (_tmp19_, "tweet_id");
			self->priv->tweet_id = _tmp20_;
			_tmp21_ = args;
			_tmp22_ = bundle_get_string (_tmp21_, "screen_name");
			_g_free0 (self->priv->screen_name);
			self->priv->screen_name = _tmp22_;
		}
	}
	_tmp23_ = self->priv->bottom_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), ___lambda78__gtk_callback, self);
	_tmp24_ = self->priv->bottom_list_box;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	_tmp25_ = self->priv->top_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_container_get_type (), GtkContainer), ___lambda79__gtk_callback, self);
	_tmp26_ = self->priv->top_list_box;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
	_tmp27_ = self->priv->reply_indicator;
	reply_indicator_set_replies_available (_tmp27_, FALSE);
	_tmp28_ = self->priv->max_size_container;
	max_size_container_set_max_size (_tmp28_, 0);
	_tmp29_ = self->priv->max_size_container;
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	tweet_info_page_query_tweet_info (self);
}


static void tweet_info_page_real_on_leave (IPage* base) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
}


static void __lambda84_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda84__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda84_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	GtkToggleButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = self->priv->favorite_button;
	_tmp6_ = gtk_toggle_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	tweet_utils_toggle_favorite_tweet (_tmp3_, _tmp4_, !_tmp7_, ___lambda84__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_favorite_button_toggled_cb ((TweetInfoPage*) self);
}


static void __lambda85_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda85__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda85_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	GtkToggleButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = self->priv->retweet_button;
	_tmp6_ = gtk_toggle_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	tweet_utils_toggle_retweet_tweet (_tmp3_, _tmp4_, !_tmp7_, ___lambda85__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_retweet_button_toggled_cb ((TweetInfoPage*) self);
}


static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp3_, _tmp4_, COMPOSE_TWEET_WINDOW_MODE_REPLY, NULL);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_reply_button_clicked_cb ((TweetInfoPage*) self);
}


static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = tweet_utils_activate_link (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_info_page_link_activated_cb ((TweetInfoPage*) self, uri);
	return result;
}


static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Tweet* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	MainWindow* _tmp6_ = NULL;
	MainWidget* _tmp7_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->priv->tweet;
	_tmp2_ = _tmp1_->user_id;
	bundle_put_int64 (bundle, "user_id", _tmp2_);
	_tmp3_ = self->priv->tweet;
	_tmp4_ = _tmp3_->screen_name;
	bundle_put_string (bundle, "screen_name", _tmp4_);
	_tmp5_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->main_widget;
	main_widget_switch_page (_tmp7_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_name_button_clicked_cb ((TweetInfoPage*) self);
}


/**
   * Loads the data of the tweet with the id tweet_id from the Twitter server.
   */
static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data30_->self;
		_g_date_time_unref0 (_data30_->now);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda80_ (Block30Data* _data30_, GObject* _, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	JsonObject* root_object = NULL;
	JsonNode* _tmp8_ = NULL;
	JsonObject* _tmp9_ = NULL;
	JsonObject* _tmp10_ = NULL;
	gchar* with = NULL;
	JsonObject* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	Tweet* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	Tweet* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	self = _data30_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp3_ = tweet_new ();
	_g_object_unref0 (self->priv->tweet);
	self->priv->tweet = _tmp3_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = root;
	_tmp6_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp7_ = _tmp6_;
	tweet_load_from_json (_tmp4_, _tmp5_, _data30_->now, _tmp7_);
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = _json_object_ref0 (_tmp9_);
	root_object = _tmp10_;
	_tmp11_ = root_object;
	_tmp12_ = json_object_get_string_member (_tmp11_, "source");
	_tmp13_ = g_strdup (_tmp12_);
	with = _tmp13_;
	_tmp14_ = with;
	_tmp15_ = tweet_info_page_extract_source (self, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("<span underline='none'>", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "</span>", NULL);
	_g_free0 (with);
	with = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp20_ = self->priv->tweet;
	_tmp21_ = with;
	tweet_info_page_set_tweet_data (self, _tmp20_, _tmp21_);
	_tmp22_ = self->priv->tweet;
	_tmp23_ = _tmp22_->reply_id;
	tweet_info_page_load_replied_to_tweet (self, _tmp23_);
	self->priv->values_set = TRUE;
	_g_free0 (with);
	_json_object_unref0 (root_object);
	__vala_JsonNode_free0 (root);
}


static void ___lambda80__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda80_ (self, source_object, res);
	block30_data_unref (self);
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data31_->_data30_->self;
		block30_data_unref (_data31_->_data30_);
		_data31_->_data30_ = NULL;
		g_slice_free (Block31Data, _data31_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda83_ (Block31Data* _data31_, JsonArray* arr, guint index, JsonNode* node) {
	Block30Data* _data30_;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	JsonObject* obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	JsonObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint64 reply_id = 0LL;
	JsonObject* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	Tweet* t = NULL;
	Tweet* _tmp13_ = NULL;
	Tweet* _tmp14_ = NULL;
	JsonNode* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	Account* _tmp17_ = NULL;
	TweetListEntry* tle = NULL;
	Tweet* _tmp18_ = NULL;
	Tweet* _tmp19_ = NULL;
	MainWindow* _tmp20_ = NULL;
	MainWindow* _tmp21_ = NULL;
	Account* _tmp22_ = NULL;
	Account* _tmp23_ = NULL;
	TweetListEntry* _tmp24_ = NULL;
	GtkListBox* _tmp25_ = NULL;
	TweetListEntry* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	_data30_ = _data31_->_data30_;
	self = _data30_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data31_->n_replies;
	if (_tmp0_ >= 5) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	obj = _tmp3_;
	_tmp5_ = obj;
	_tmp6_ = json_object_has_member (_tmp5_, "in_reply_to_status_id");
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		JsonObject* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = obj;
		_tmp8_ = json_object_get_null_member (_tmp7_, "in_reply_to_status_id");
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp9_ = obj;
	_tmp10_ = json_object_get_int_member (_tmp9_, "in_reply_to_status_id");
	reply_id = _tmp10_;
	_tmp11_ = reply_id;
	_tmp12_ = self->priv->tweet_id;
	if (_tmp11_ != _tmp12_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp13_ = tweet_new ();
	t = _tmp13_;
	_tmp14_ = t;
	_tmp15_ = node;
	_tmp16_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp17_ = _tmp16_;
	tweet_load_from_json (_tmp14_, _tmp15_, _data30_->now, _tmp17_);
	_tmp18_ = t;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_tmp20_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp21_ = _tmp20_;
	_tmp22_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp23_ = _tmp22_;
	_tmp24_ = tweet_list_entry_new (_tmp19_, _tmp21_, _tmp23_);
	g_object_ref_sink (_tmp24_);
	tle = _tmp24_;
	_tmp25_ = self->priv->top_list_box;
	_tmp26_ = tle;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
	_tmp27_ = _data31_->n_replies;
	_data31_->n_replies = _tmp27_ + 1;
	_g_object_unref0 (tle);
	_g_object_unref0 (t);
	_json_object_unref0 (obj);
}


static void ___lambda83__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda83_ (self, array, index_, element_node);
}


static void __lambda82_ (Block30Data* _data30_, GObject* _, GAsyncResult* res) {
	TweetInfoPage* self;
	Block31Data* _data31_;
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonArray* statuses_node = NULL;
	JsonNode* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	JsonArray* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	self = _data30_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->_data30_ = block30_data_ref (_data30_);
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		__vala_JsonNode_free0 (root);
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return;
	}
	_tmp3_ = root;
	_tmp4_ = json_node_get_object (_tmp3_);
	_tmp5_ = json_object_get_array_member (_tmp4_, "statuses");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	statuses_node = _tmp6_;
	_data31_->n_replies = 0;
	_tmp7_ = statuses_node;
	json_array_foreach_element (_tmp7_, ___lambda83__json_array_foreach, _data31_);
	_tmp8_ = _data31_->n_replies;
	if (_tmp8_ > 0) {
		GtkListBox* _tmp9_ = NULL;
		ReplyIndicator* _tmp10_ = NULL;
		_tmp9_ = self->priv->top_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = self->priv->reply_indicator;
		reply_indicator_set_replies_available (_tmp10_, TRUE);
	} else {
		GtkListBox* _tmp11_ = NULL;
		ReplyIndicator* _tmp12_ = NULL;
		_tmp11_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = self->priv->reply_indicator;
		reply_indicator_set_replies_available (_tmp12_, FALSE);
	}
	_json_array_unref0 (statuses_node);
	__vala_JsonNode_free0 (root);
	block31_data_unref (_data31_);
	_data31_ = NULL;
}


static void ___lambda82__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda82_ (self, source_object, res);
	block30_data_unref (self);
}


static void tweet_info_page_query_tweet_info (TweetInfoPage* self) {
	Block30Data* _data30_;
	GDateTime* _tmp0_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RestProxyCall* reply_call = NULL;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	OAuthProxy* _tmp11_ = NULL;
	OAuthProxy* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = g_date_time_new_now_local ();
	_data30_->now = _tmp0_;
	_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = account_get_proxy (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	call = _tmp5_;
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_set_function (call, "1.1/statuses/show.json");
	_tmp6_ = self->priv->tweet_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (call, "id", _tmp8_);
	_g_free0 (_tmp8_);
	tweet_utils_load_threaded (call, ___lambda80__gasync_ready_callback, block30_data_ref (_data30_));
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = account_get_proxy (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, rest_proxy_get_type (), RestProxy));
	reply_call = _tmp13_;
	rest_proxy_call_set_method (reply_call, "GET");
	rest_proxy_call_set_function (reply_call, "1.1/search/tweets.json");
	_tmp14_ = self->priv->screen_name;
	_tmp15_ = g_strconcat ("to:", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	rest_proxy_call_add_param (reply_call, "q", _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = self->priv->tweet_id;
	_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
	_tmp19_ = _tmp18_;
	rest_proxy_call_add_param (reply_call, "since_id", _tmp19_);
	_g_free0 (_tmp19_);
	rest_proxy_call_add_param (reply_call, "count", "200");
	tweet_utils_load_threaded (reply_call, ___lambda82__gasync_ready_callback, block30_data_ref (_data30_));
	_g_object_unref0 (reply_call);
	_g_object_unref0 (call);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}


/**
   * Loads the tweet this tweet is a reply to.
   * This will recursively call itself until the end of the chain is reached.
   *
   * @param reply_id The id of the tweet the previous tweet was a reply to.
   */
static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->call);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void __lambda81_ (Block32Data* _data32_, GObject* obj, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp13_ = NULL;
	Tweet* tweet = NULL;
	Tweet* _tmp19_ = NULL;
	Tweet* _tmp20_ = NULL;
	JsonParser* _tmp21_ = NULL;
	JsonNode* _tmp22_ = NULL;
	GDateTime* _tmp23_ = NULL;
	GDateTime* _tmp24_ = NULL;
	Account* _tmp25_ = NULL;
	Account* _tmp26_ = NULL;
	GtkListBox* _tmp27_ = NULL;
	Tweet* _tmp28_ = NULL;
	Tweet* _tmp29_ = NULL;
	MainWindow* _tmp30_ = NULL;
	MainWindow* _tmp31_ = NULL;
	Account* _tmp32_ = NULL;
	Account* _tmp33_ = NULL;
	TweetListEntry* _tmp34_ = NULL;
	TweetListEntry* _tmp35_ = NULL;
	Tweet* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	GError * _inner_error_ = NULL;
	self = _data32_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data32_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RestProxyCall* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GtkListBox* _tmp8_ = NULL;
		GtkListBox* _tmp9_ = NULL;
		GList* _tmp10_ = NULL;
		GList* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("TweetInfoPage.vala:275: %s", _tmp3_);
		_tmp4_ = _data32_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		utils_show_error_object (_tmp5_, _tmp7_, 277, "TweetInfoPage.vala");
		_tmp8_ = self->priv->bottom_list_box;
		_tmp9_ = self->priv->bottom_list_box;
		_tmp10_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer));
		_tmp11_ = _tmp10_;
		_tmp12_ = g_list_length (_tmp11_);
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), _tmp12_ > ((guint) 0));
		_g_list_free0 (_tmp11_);
		_g_error_free0 (e);
		return;
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = json_parser_new ();
	parser = _tmp13_;
	{
		JsonParser* _tmp14_ = NULL;
		RestProxyCall* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp14_ = parser;
		_tmp15_ = _data32_->call;
		_tmp16_ = rest_proxy_call_get_payload (_tmp15_);
		json_parser_load_from_data (_tmp14_, _tmp16_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("TweetInfoPage.vala:286: %s", _tmp18_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = tweet_new ();
	tweet = _tmp19_;
	_tmp20_ = tweet;
	_tmp21_ = parser;
	_tmp22_ = json_parser_get_root (_tmp21_);
	_tmp23_ = g_date_time_new_now_local ();
	_tmp24_ = _tmp23_;
	_tmp25_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp26_ = _tmp25_;
	tweet_load_from_json (_tmp20_, _tmp22_, _tmp24_, _tmp26_);
	_g_date_time_unref0 (_tmp24_);
	_tmp27_ = self->priv->bottom_list_box;
	_tmp28_ = tweet;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_tmp30_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp31_ = _tmp30_;
	_tmp32_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp33_ = _tmp32_;
	_tmp34_ = tweet_list_entry_new (_tmp29_, _tmp31_, _tmp33_);
	g_object_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp35_);
	_tmp36_ = tweet;
	_tmp37_ = _tmp36_->reply_id;
	tweet_info_page_load_replied_to_tweet (self, _tmp37_);
	_g_object_unref0 (tweet);
	_g_object_unref0 (parser);
}


static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda81_ (self, source_object, res);
	block32_data_unref (self);
}


static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id) {
	Block32Data* _data32_;
	gint64 _tmp0_ = 0LL;
	GtkListBox* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	OAuthProxy* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = reply_id;
	if (_tmp0_ == ((gint64) 0)) {
		block32_data_unref (_data32_);
		_data32_ = NULL;
		return;
	}
	_tmp1_ = self->priv->bottom_list_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = account_get_proxy (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, rest_proxy_get_type (), RestProxy));
	_data32_->call = _tmp6_;
	_tmp7_ = _data32_->call;
	rest_proxy_call_set_function (_tmp7_, "1.1/statuses/show.json");
	_tmp8_ = _data32_->call;
	rest_proxy_call_set_method (_tmp8_, "GET");
	_tmp9_ = _data32_->call;
	_tmp10_ = reply_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
	_tmp12_ = _tmp11_;
	rest_proxy_call_add_param (_tmp9_, "id", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = _data32_->call;
	rest_proxy_call_invoke_async (_tmp13_, NULL, ___lambda81__gasync_ready_callback, block32_data_ref (_data32_));
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


/**
   *
   */
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, Tweet* tweet, const gchar* with) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	UserCounter* _tmp2_ = NULL;
	UserCounter* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	Tweet* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	Tweet* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GDateTime* created_at = NULL;
	Tweet* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	GDateTime* _tmp12_ = NULL;
	gchar* time_format = NULL;
	GDateTime* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	Tweet* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	TextButton* _tmp25_ = NULL;
	Tweet* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	Tweet* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	AvatarWidget* _tmp33_ = NULL;
	Tweet* _tmp34_ = NULL;
	GdkPixbuf* _tmp35_ = NULL;
	GdkPixbuf* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	Tweet* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GtkLabel* _tmp43_ = NULL;
	Tweet* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	GtkLabel* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkToggleButton* _tmp51_ = NULL;
	Tweet* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	GtkToggleButton* _tmp55_ = NULL;
	Tweet* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	AvatarWidget* _tmp59_ = NULL;
	Tweet* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	Tweet* _tmp62_ = NULL;
	gint64 _tmp63_ = 0LL;
	Tweet* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	Tweet* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp74_ = FALSE;
	Tweet* _tmp75_ = NULL;
	gint64 _tmp76_ = 0LL;
	Account* _tmp77_ = NULL;
	Account* _tmp78_ = NULL;
	gint64 _tmp79_ = 0LL;
	gint64 _tmp80_ = 0LL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (IS_TWEET (tweet));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_user_counter (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = tweet;
	_tmp5_ = _tmp4_->user_id;
	_tmp6_ = tweet;
	_tmp7_ = _tmp6_->screen_name;
	_tmp8_ = tweet;
	_tmp9_ = _tmp8_->user_name;
	user_counter_user_seen (_tmp3_, _tmp5_, _tmp7_, _tmp9_);
	_tmp10_ = tweet;
	_tmp11_ = _tmp10_->created_at;
	_tmp12_ = g_date_time_new_from_unix_local (_tmp11_);
	created_at = _tmp12_;
	_tmp13_ = created_at;
	_tmp14_ = g_date_time_format (_tmp13_, "%x, %X");
	time_format = _tmp14_;
	_tmp15_ = with;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp16_ = time_format;
		_tmp17_ = with;
		_tmp18_ = g_strconcat (" via ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
		_g_free0 (time_format);
		time_format = _tmp20_;
		_g_free0 (_tmp19_);
	}
	_tmp21_ = self->priv->text_label;
	_tmp22_ = tweet;
	_tmp23_ = tweet_get_formatted_text (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_label_set_label (_tmp21_, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->name_button;
	_tmp26_ = tweet;
	_tmp27_ = _tmp26_->user_name;
	gtk_button_set_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_button_get_type (), GtkButton), _tmp27_);
	_tmp28_ = self->priv->screen_name_label;
	_tmp29_ = tweet;
	_tmp30_ = _tmp29_->screen_name;
	_tmp31_ = g_strconcat ("@", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	gtk_label_set_label (_tmp28_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->avatar_image;
	_tmp34_ = tweet;
	_tmp35_ = tweet_get_avatar (_tmp34_);
	_tmp36_ = _tmp35_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp36_, NULL);
	_tmp37_ = self->priv->rt_label;
	_tmp38_ = tweet;
	_tmp39_ = _tmp38_->retweet_count;
	_tmp40_ = _ ("Retweets");
	_tmp41_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp39_, _tmp40_);
	_tmp42_ = _tmp41_;
	gtk_label_set_label (_tmp37_, _tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = self->priv->fav_label;
	_tmp44_ = tweet;
	_tmp45_ = _tmp44_->favorite_count;
	_tmp46_ = _ ("Favorites");
	_tmp47_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp45_, _tmp46_);
	_tmp48_ = _tmp47_;
	gtk_label_set_label (_tmp43_, _tmp48_);
	_g_free0 (_tmp48_);
	_tmp49_ = self->priv->time_label;
	_tmp50_ = time_format;
	gtk_label_set_label (_tmp49_, _tmp50_);
	_tmp51_ = self->priv->retweet_button;
	_tmp52_ = tweet;
	_tmp53_ = tweet_get_retweeted (_tmp52_);
	_tmp54_ = _tmp53_;
	gtk_toggle_button_set_active (_tmp51_, _tmp54_);
	_tmp55_ = self->priv->favorite_button;
	_tmp56_ = tweet;
	_tmp57_ = tweet_get_favorited (_tmp56_);
	_tmp58_ = _tmp57_;
	gtk_toggle_button_set_active (_tmp55_, _tmp58_);
	_tmp59_ = self->priv->avatar_image;
	_tmp60_ = tweet;
	_tmp61_ = _tmp60_->verified;
	avatar_widget_set_verified (_tmp59_, _tmp61_);
	_tmp62_ = tweet;
	_tmp63_ = _tmp62_->id;
	_tmp64_ = tweet;
	_tmp65_ = _tmp64_->screen_name;
	tweet_info_page_set_source_link (self, _tmp63_, _tmp65_);
	_tmp66_ = tweet;
	_tmp67_ = tweet_get_has_inline_media (_tmp66_);
	_tmp68_ = _tmp67_;
	if (_tmp68_) {
		MultiMediaWidget* _tmp69_ = NULL;
		Tweet* _tmp70_ = NULL;
		Media** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		MultiMediaWidget* _tmp72_ = NULL;
		_tmp69_ = self->priv->mm_widget;
		_tmp70_ = tweet;
		_tmp71_ = _tmp70_->medias;
		_tmp71__length1 = _tmp70_->medias_length1;
		multi_media_widget_set_all_media (_tmp69_, _tmp71_, _tmp71__length1);
		_tmp72_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp73_ = NULL;
		_tmp73_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp75_ = tweet;
	_tmp76_ = _tmp75_->user_id;
	_tmp77_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp78_ = _tmp77_;
	_tmp79_ = account_get_id (_tmp78_);
	_tmp80_ = _tmp79_;
	if (_tmp76_ == _tmp80_) {
		_tmp74_ = TRUE;
	} else {
		Tweet* _tmp81_ = NULL;
		gboolean _tmp82_ = FALSE;
		_tmp81_ = tweet;
		_tmp82_ = _tmp81_->protected;
		_tmp74_ = _tmp82_;
	}
	if (_tmp74_) {
		GtkToggleButton* _tmp83_ = NULL;
		_tmp83_ = self->priv->retweet_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkToggleButton* _tmp84_ = NULL;
		_tmp84_ = self->priv->retweet_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_widget_get_type (), GtkWidget));
	}
	_g_free0 (time_format);
	_g_date_time_unref0 (created_at);
}


static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name) {
	gchar* link = NULL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("https://twitter.com/%s/status/%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	link = _tmp5_;
	_tmp6_ = self->priv->source_label;
	_tmp7_ = _ ("Open in Browser");
	_tmp8_ = _ ("Source");
	_tmp9_ = g_strdup_printf ("<span underline='none'><a href='%s' title='%s'>%s</a></span>", link, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_label_set_label (_tmp6_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (link);
}


static void tweet_info_page_quote_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->tweet;
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp3_, _tmp4_, COMPOSE_TWEET_WINDOW_MODE_QUOTE, NULL);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static gchar* tweet_info_page_real_get_title (IPage* base) {
	TweetInfoPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = _ ("Tweet Details");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Twitter's source parameter of tweets includes a 'rel' parameter
   * that doesn't work as pango markup, so we just remove it here.
   *
   * Example string:
   *   <a href=\"http://www.tweetdeck.com\" rel=\"nofollow\">TweetDeck</a>
   *
   * @param source_str The source string from twitter
   *
   * @return The #source_string without the rel parameter
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str) {
	gchar* result = NULL;
	gint from = 0;
	gint to = 0;
	gint tmp = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), NULL);
	g_return_val_if_fail (source_str != NULL, NULL);
	tmp = 0;
	_tmp0_ = source_str;
	_tmp1_ = string_index_of_char (_tmp0_, (gunichar) '"', 0);
	tmp = _tmp1_;
	_tmp2_ = source_str;
	_tmp3_ = tmp;
	_tmp4_ = string_index_of_char (_tmp2_, (gunichar) '"', _tmp3_ + 1);
	tmp = _tmp4_;
	_tmp5_ = source_str;
	_tmp6_ = tmp;
	_tmp7_ = string_index_of_char (_tmp5_, (gunichar) '"', _tmp6_ + 1);
	from = _tmp7_;
	_tmp8_ = source_str;
	_tmp9_ = from;
	_tmp10_ = string_index_of_char (_tmp8_, (gunichar) '"', _tmp9_ + 1);
	to = _tmp10_;
	_tmp12_ = to;
	if (_tmp12_ == (-1)) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp13_ = 0;
		_tmp13_ = from;
		_tmp11_ = _tmp13_ == (-1);
	}
	if (_tmp11_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = source_str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = source_str;
	_tmp17_ = from;
	_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp17_ - 5));
	_tmp19_ = _tmp18_;
	_tmp20_ = source_str;
	_tmp21_ = to;
	_tmp22_ = string_substring (_tmp20_, (glong) (_tmp21_ + 1), (glong) (-1));
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	result = _tmp25_;
	return result;
}


static void tweet_info_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* tweet_info_page_real_get_tool_button (IPage* base) {
	TweetInfoPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	result = NULL;
	return result;
}


gint tweet_info_page_get_unread_count (TweetInfoPage* self) {
	gint result;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), 0);
	result = 0;
	return result;
}


void tweet_info_page_set_unread_count (TweetInfoPage* self, gint value) {
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_object_notify ((GObject *) self, "unread-count");
}


static gint tweet_info_page_real_get_id (IPage* base) {
	gint result;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_id (IPage* base, gint value) {
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static MainWindow* tweet_info_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	TweetInfoPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_main_window (IPage* base, MainWindow* value) {
	TweetInfoPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* tweet_info_page_real_get_account (IPage* base) {
	Account* result;
	TweetInfoPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_account (IPage* base, Account* value) {
	TweetInfoPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


static void tweet_info_page_class_init (TweetInfoPageClass * klass) {
	gint TweetInfoPage_private_offset;
	tweet_info_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetInfoPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_info_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_info_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_info_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	TweetInfoPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-info-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, fav_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bottom_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, bottom_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, top_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, source_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_indicator", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_indicator));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_info_page_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_info_page_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_info_page_name_button_clicked_cb_gtk_button_clicked));
}


static void tweet_info_page_ipage_interface_init (IPageIface * iface) {
	tweet_info_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) tweet_info_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) tweet_info_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) tweet_info_page_real_get_title;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) tweet_info_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) tweet_info_page_real_get_tool_button;
	iface->get_id = tweet_info_page_real_get_id;
	iface->set_id = tweet_info_page_real_set_id;
	iface->get_main_window = tweet_info_page_real_get_main_window;
	iface->set_main_window = tweet_info_page_real_set_main_window;
	iface->get_account = tweet_info_page_real_get_account;
	iface->set_account = tweet_info_page_real_set_account;
}


static void tweet_info_page_instance_init (TweetInfoPage * self) {
	self->priv = TWEET_INFO_PAGE_GET_PRIVATE (self);
	self->priv->values_set = FALSE;
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	g_type_ensure (TYPE_REPLY_INDICATOR);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_info_page_finalize (GObject* obj) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_g_free0 (self->priv->screen_name);
	_g_object_unref0 (self->priv->tweet);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->fav_label);
	_g_object_unref0 (self->priv->bottom_list_box);
	_g_object_unref0 (self->priv->top_list_box);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->source_label);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->reply_indicator);
	G_OBJECT_CLASS (tweet_info_page_parent_class)->finalize (obj);
}


GType tweet_info_page_get_type (void) {
	static volatile gsize tweet_info_page_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_info_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetInfoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_info_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetInfoPage), 0, (GInstanceInitFunc) tweet_info_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) tweet_info_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_info_page_type_id;
		tweet_info_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "TweetInfoPage", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&tweet_info_page_type_id__volatile, tweet_info_page_type_id);
	}
	return tweet_info_page_type_id__volatile;
}


static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_UNREAD_COUNT:
		g_value_set_int (value, tweet_info_page_get_unread_count (self));
		break;
		case TWEET_INFO_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case TWEET_INFO_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case TWEET_INFO_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_UNREAD_COUNT:
		tweet_info_page_set_unread_count (self, g_value_get_int (value));
		break;
		case TWEET_INFO_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case TWEET_INFO_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case TWEET_INFO_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



