/* TweetListEntry.c generated by valac 0.26.2, the Vala compiler
 * generated from TweetListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_DOUBLE_TAP_BUTTON (double_tap_button_get_type ())
#define DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButton))
#define DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))
#define IS_DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOUBLE_TAP_BUTTON))
#define IS_DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOUBLE_TAP_BUTTON))
#define DOUBLE_TAP_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))

typedef struct _DoubleTapButton DoubleTapButton;
typedef struct _DoubleTapButtonClass DoubleTapButtonClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _TweetListEntryPrivate {
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* rt_label;
	GtkImage* rt_image;
	GtkImage* conversation_image;
	GtkImage* rt_status_image;
	GtkImage* fav_status_image;
	DoubleTapButton* retweet_button;
	GtkToggleButton* favorite_button;
	GtkGrid* grid;
	MultiMediaWidget* mm_widget;
	GtkStack* stack;
	GtkBox* action_box;
	gboolean _read_only;
	gboolean _seen;
	Account* account;
	MainWindow* window;
	gboolean values_set;
	gboolean delete_first_activated;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;


static gpointer tweet_list_entry_parent_class = NULL;
static ITwitterItemIface* tweet_list_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType double_tap_button_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_ENTRY, TweetListEntryPrivate))
enum  {
	TWEET_LIST_ENTRY_DUMMY_PROPERTY,
	TWEET_LIST_ENTRY_READ_ONLY,
	TWEET_LIST_ENTRY_SORT_FACTOR,
	TWEET_LIST_ENTRY_SEEN,
	TWEET_LIST_ENTRY_SHOWS_ACTIONS
};
static void tweet_list_entry_quote_activated (TweetListEntry* self);
static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_list_entry_delete_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
void text_button_set_markup (TextButton* self, const gchar* text);
GType media_get_type (void) G_GNUC_CONST;
GdkPixbuf* tweet_get_avatar (Tweet* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
gchar* tweet_get_trimmed_text (Tweet* self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
gboolean tweet_get_retweeted (Tweet* self);
gint64 account_get_id (Account* self);
static void tweet_list_entry_retweeted_cb (TweetListEntry* self);
static void _tweet_list_entry_retweeted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean tweet_get_favorited (Tweet* self);
static void tweet_list_entry_favorited_cb (TweetListEntry* self);
static void _tweet_list_entry_favorited_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tweet_list_entry_avatar_changed (TweetListEntry* self);
static void _tweet_list_entry_avatar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean tweet_get_has_inline_media (Tweet* self);
void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1);
static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, Media* m, gint index);
static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self);
static void tweet_list_entry_media_invalid_cb (TweetListEntry* self);
static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self);
static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self);
static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda68_ (TweetListEntry* self);
static void ___lambda68__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda69_ (TweetListEntry* self);
void double_tap_button_tap (DoubleTapButton* self);
static void ___lambda69__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void ___lambda67_ (TweetListEntry* self);
static void ____lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt);
void double_tap_button_reset (DoubleTapButton* self);
static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt);
static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static void __lambda71_ (TweetListEntry* self);
static void ___lambda71__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
static void __lambda73_ (TweetListEntry* self);
static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode, GtkApplication* app);
static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
gchar* tweet_get_formatted_text (Tweet* self);
static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
void text_button_set_read_only (TextButton* self, gboolean value);
void notification_manager_withdraw (const gchar* notification_id);
static void tweet_list_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
gboolean itwitter_item_get_seen (ITwitterItem* self);
static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void itwitter_item_set_seen (ITwitterItem* self, gboolean value);
static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_LIST_ENTRY_action_entries[2] = {{"quote", _tweet_list_entry_quote_activated_gsimple_action_activate_callback}, {"delete", _tweet_list_entry_delete_activated_gsimple_action_activate_callback}};

static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_delete_activated ((TweetListEntry*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _tweet_list_entry_retweeted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_retweeted_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_favorited_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_favorited_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_avatar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_avatar_changed ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self) {
	tweet_list_entry_media_clicked_cb ((TweetListEntry*) self, m, index);
}


static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self) {
	tweet_list_entry_media_invalid_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_reply_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_delete_tweet_activated ((TweetListEntry*) self);
}


static void __lambda68_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GtkToggleButton* _tmp3_ = NULL;
		GtkToggleButton* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = self->priv->favorite_button;
		_tmp4_ = self->priv->favorite_button;
		_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_toggle_button_set_active (_tmp3_, !_tmp6_);
	}
}


static void ___lambda68__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda68_ ((TweetListEntry*) self);
}


static void __lambda69_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_tap (_tmp0_);
}


static void ___lambda69__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda69_ ((TweetListEntry*) self);
}


TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account) {
	TweetListEntry * self = NULL;
	Account* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	TextButton* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	Tweet* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	AvatarWidget* _tmp12_ = NULL;
	Tweet* _tmp13_ = NULL;
	GdkPixbuf* _tmp14_ = NULL;
	GdkPixbuf* _tmp15_ = NULL;
	AvatarWidget* _tmp16_ = NULL;
	Tweet* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkLabel* _tmp19_ = NULL;
	Tweet* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	Tweet* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	DoubleTapButton* _tmp47_ = NULL;
	Tweet* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	Tweet* _tmp52_ = NULL;
	gint64 _tmp53_ = 0LL;
	Account* _tmp54_ = NULL;
	gint64 _tmp55_ = 0LL;
	gint64 _tmp56_ = 0LL;
	DoubleTapButton* _tmp59_ = NULL;
	Tweet* _tmp60_ = NULL;
	GtkToggleButton* _tmp61_ = NULL;
	Tweet* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	Tweet* _tmp65_ = NULL;
	Tweet* _tmp66_ = NULL;
	gint64 _tmp67_ = 0LL;
	Tweet* _tmp70_ = NULL;
	Tweet* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp83_ = NULL;
	GSimpleActionGroup* _tmp84_ = NULL;
	GSimpleActionGroup* _tmp85_ = NULL;
	Tweet* _tmp86_ = NULL;
	gint64 _tmp87_ = 0LL;
	Account* _tmp88_ = NULL;
	gint64 _tmp89_ = 0LL;
	gint64 _tmp90_ = 0LL;
	Tweet* _tmp93_ = NULL;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	Tweet* _tmp97_ = NULL;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp99_ = FALSE;
	g_return_val_if_fail (IS_TWEET (tweet), NULL);
	g_return_val_if_fail ((window == NULL) || IS_MAIN_WINDOW (window), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->tweet);
	self->tweet = _tmp2_;
	_tmp3_ = window;
	self->priv->window = _tmp3_;
	_tmp4_ = self->priv->name_button;
	_tmp5_ = tweet;
	_tmp6_ = _tmp5_->user_name;
	text_button_set_markup (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->screen_name_label;
	_tmp8_ = tweet;
	_tmp9_ = _tmp8_->screen_name;
	_tmp10_ = g_strconcat ("@", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->avatar_image;
	_tmp13_ = tweet;
	_tmp14_ = tweet_get_avatar (_tmp13_);
	_tmp15_ = _tmp14_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp15_, NULL);
	_tmp16_ = self->priv->avatar_image;
	_tmp17_ = tweet;
	_tmp18_ = _tmp17_->verified;
	avatar_widget_set_verified (_tmp16_, _tmp18_);
	_tmp19_ = self->priv->text_label;
	_tmp20_ = tweet;
	_tmp21_ = tweet_get_trimmed_text (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_label_set_label (_tmp19_, _tmp22_);
	_g_free0 (_tmp22_);
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
	_tmp23_ = tweet;
	_tmp24_ = _tmp23_->is_retweet;
	if (_tmp24_) {
		GtkLabel* _tmp25_ = NULL;
		GtkImage* _tmp26_ = NULL;
		GtkLabel* _tmp27_ = NULL;
		Tweet* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		Tweet* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		Tweet* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		Tweet* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp25_ = self->priv->rt_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_tmp26_ = self->priv->rt_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = self->priv->rt_label;
		_tmp28_ = tweet;
		_tmp29_ = _tmp28_->rt_by_id;
		_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = tweet;
		_tmp33_ = _tmp32_->rt_by_screen_name;
		_tmp34_ = string_to_string (_tmp33_);
		_tmp35_ = tweet;
		_tmp36_ = _tmp35_->rt_by_screen_name;
		_tmp37_ = string_to_string (_tmp36_);
		_tmp38_ = tweet;
		_tmp39_ = _tmp38_->retweeted_by;
		_tmp40_ = string_to_string (_tmp39_);
		_tmp41_ = g_strconcat ("<span underline='none'><a href=\"@", _tmp31_, "/", _tmp34_, "\"\n                         title=\"@", _tmp37_, "\">", _tmp40_, "</a></span>", NULL);
		_tmp42_ = _tmp41_;
		gtk_label_set_label (_tmp27_, _tmp42_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp31_);
	} else {
		GtkGrid* _tmp43_ = NULL;
		GtkImage* _tmp44_ = NULL;
		GtkGrid* _tmp45_ = NULL;
		GtkLabel* _tmp46_ = NULL;
		_tmp43_ = self->priv->grid;
		_tmp44_ = self->priv->rt_image;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget));
		_tmp45_ = self->priv->grid;
		_tmp46_ = self->priv->rt_label;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp47_ = self->priv->retweet_button;
	_tmp48_ = tweet;
	_tmp49_ = tweet_get_retweeted (_tmp48_);
	_tmp50_ = _tmp49_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp50_);
	_tmp52_ = tweet;
	_tmp53_ = _tmp52_->user_id;
	_tmp54_ = account;
	_tmp55_ = account_get_id (_tmp54_);
	_tmp56_ = _tmp55_;
	if (_tmp53_ != _tmp56_) {
		Tweet* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		_tmp57_ = tweet;
		_tmp58_ = _tmp57_->protected;
		_tmp51_ = !_tmp58_;
	} else {
		_tmp51_ = FALSE;
	}
	_tmp59_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget), _tmp51_);
	_tmp60_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, G_TYPE_OBJECT, GObject), "notify::retweeted", (GCallback) _tweet_list_entry_retweeted_cb_g_object_notify, self, 0);
	_tmp61_ = self->priv->favorite_button;
	_tmp62_ = tweet;
	_tmp63_ = tweet_get_favorited (_tmp62_);
	_tmp64_ = _tmp63_;
	gtk_toggle_button_set_active (_tmp61_, _tmp64_);
	_tmp65_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, G_TYPE_OBJECT, GObject), "notify::favorited", (GCallback) _tweet_list_entry_favorited_cb_g_object_notify, self, 0);
	_tmp66_ = tweet;
	_tmp67_ = _tmp66_->reply_id;
	if (_tmp67_ == ((gint64) 0)) {
		GtkImage* _tmp68_ = NULL;
		_tmp68_ = self->priv->conversation_image;
		gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkImage* _tmp69_ = NULL;
		_tmp69_ = self->priv->conversation_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp70_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) _tweet_list_entry_avatar_changed_g_object_notify, self, 0);
	_tmp71_ = tweet;
	_tmp72_ = tweet_get_has_inline_media (_tmp71_);
	_tmp73_ = _tmp72_;
	if (_tmp73_) {
		MultiMediaWidget* _tmp74_ = NULL;
		Tweet* _tmp75_ = NULL;
		Media** _tmp76_ = NULL;
		gint _tmp76__length1 = 0;
		MultiMediaWidget* _tmp77_ = NULL;
		MultiMediaWidget* _tmp78_ = NULL;
		MultiMediaWidget* _tmp79_ = NULL;
		MainWindow* _tmp80_ = NULL;
		_tmp74_ = self->priv->mm_widget;
		_tmp75_ = tweet;
		_tmp76_ = _tmp75_->medias;
		_tmp76__length1 = _tmp75_->medias_length1;
		multi_media_widget_set_all_media (_tmp74_, _tmp76_, _tmp76__length1);
		_tmp77_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp77_, "media-clicked", (GCallback) _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked, self, 0);
		_tmp78_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp78_, "media-invalid", (GCallback) _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid, self, 0);
		_tmp79_ = self->priv->mm_widget;
		_tmp80_ = window;
		_tmp79_->window = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_window_get_type (), GtkWindow);
	} else {
		GtkGrid* _tmp81_ = NULL;
		MultiMediaWidget* _tmp82_ = NULL;
		_tmp81_ = self->priv->grid;
		_tmp82_ = self->priv->mm_widget;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp83_ = g_simple_action_group_new ();
	actions = _tmp83_;
	_tmp84_ = actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, g_action_map_get_type (), GActionMap), TWEET_LIST_ENTRY_action_entries, G_N_ELEMENTS (TWEET_LIST_ENTRY_action_entries), self);
	_tmp85_ = actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, g_action_group_get_type (), GActionGroup));
	_tmp86_ = tweet;
	_tmp87_ = _tmp86_->user_id;
	_tmp88_ = account;
	_tmp89_ = account_get_id (_tmp88_);
	_tmp90_ = _tmp89_;
	if (_tmp87_ != _tmp90_) {
		GSimpleActionGroup* _tmp91_ = NULL;
		GAction* _tmp92_ = NULL;
		_tmp91_ = actions;
		_tmp92_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, g_action_map_get_type (), GActionMap), "delete");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	g_signal_connect_object (self, "reply-tweet", (GCallback) _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet, self, 0);
	g_signal_connect_object (self, "delete-tweet", (GCallback) _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet, self, 0);
	g_signal_connect_object (self, "favorite-tweet", (GCallback) ___lambda68__tweet_list_entry_favorite_tweet, self, 0);
	g_signal_connect_object (self, "retweet-tweet", (GCallback) ___lambda69__tweet_list_entry_retweet_tweet, self, 0);
	_tmp93_ = tweet;
	_tmp94_ = tweet_get_favorited (_tmp93_);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		GtkImage* _tmp96_ = NULL;
		_tmp96_ = self->priv->fav_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp97_ = tweet;
	_tmp98_ = tweet_get_retweeted (_tmp97_);
	_tmp99_ = _tmp98_;
	if (_tmp99_) {
		GtkImage* _tmp100_ = NULL;
		_tmp100_ = self->priv->rt_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
	_g_object_unref0 (actions);
	_g_object_unref0 (tweet);
	return self;
}


TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account) {
	return tweet_list_entry_construct (TYPE_TWEET_LIST_ENTRY, tweet, window, account);
}


static void tweet_list_entry_favorited_cb (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkImage* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_favorited (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->fav_status_image;
	_tmp5_ = self->tweet;
	_tmp6_ = tweet_get_favorited (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp7_);
	self->priv->values_set = TRUE;
}


static void tweet_list_entry_retweeted_cb (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkImage* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->retweet_button;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_retweeted (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp3_);
	_tmp4_ = self->priv->rt_status_image;
	_tmp5_ = self->tweet;
	_tmp6_ = tweet_get_retweeted (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp7_);
	self->priv->values_set = TRUE;
}


static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, Media* m, gint index) {
	Tweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (IS_MEDIA (m));
	_tmp0_ = self->tweet;
	_tmp1_ = self->priv->window;
	_tmp2_ = index;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda67_ (TweetListEntry* self) {
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
}


static void ____lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda67_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self) {
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	Account* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->user_id;
	_tmp2_ = self->priv->account;
	_tmp3_ = account_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp1_ != _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->delete_first_activated;
	if (_tmp5_) {
		Account* _tmp6_ = NULL;
		Tweet* _tmp7_ = NULL;
		_tmp6_ = self->priv->account;
		_tmp7_ = self->tweet;
		tweet_utils_delete_tweet (_tmp6_, _tmp7_, ____lambda67__gasync_ready_callback, g_object_ref (self));
	} else {
		self->priv->delete_first_activated = TRUE;
	}
}


static void tweet_list_entry_avatar_changed (TweetListEntry* self) {
	AvatarWidget* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	AvatarWidget* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_avatar (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_image_get_type (), GtkImage), "pixbuf", _tmp3_, NULL);
	_tmp4_ = self->priv->avatar_image;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
}


static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt) {
	gboolean result = FALSE;
	DoubleTapButton* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	self->priv->delete_first_activated = FALSE;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_reset (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_focus_out_cb ((TweetListEntry*) self, event);
	return result;
}


static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_key_released_cb ((TweetListEntry*) self, event);
	return result;
}


/**
   * Retweets or un-retweets the tweet.
   */
static void __lambda71_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda71__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda71_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	Tweet* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	DoubleTapButton* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	Tweet* _tmp10_ = NULL;
	DoubleTapButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->tweet;
	_tmp5_ = _tmp4_->user_id;
	if (_tmp3_ == _tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->values_set;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		DoubleTapButton* _tmp7_ = NULL;
		_tmp7_ = self->priv->retweet_button;
		gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_toggle_button_get_type (), GtkToggleButton), FALSE);
		return;
	}
	_tmp8_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp9_ = self->priv->account;
	_tmp10_ = self->tweet;
	_tmp11_ = self->priv->retweet_button;
	_tmp12_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp13_ = _tmp12_;
	tweet_utils_toggle_retweet_tweet (_tmp9_, _tmp10_, !_tmp13_, ___lambda71__gasync_ready_callback, g_object_ref (self));
	_tmp14_ = tweet_list_entry_get_shows_actions (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_retweet_button_toggled_cb ((TweetListEntry*) self);
}


static void __lambda73_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda73_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->account;
	_tmp3_ = self->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_toggle_favorite_tweet (_tmp2_, _tmp3_, !_tmp6_, ___lambda73__gasync_ready_callback, g_object_ref (self));
	_tmp7_ = tweet_list_entry_get_shows_actions (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_favorite_button_toggled_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Tweet* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	MainWindow* _tmp5_ = NULL;
	MainWidget* _tmp6_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->tweet;
	_tmp2_ = _tmp1_->user_id;
	bundle_put_int64 (bundle, "user_id", _tmp2_);
	_tmp3_ = self->tweet;
	_tmp4_ = _tmp3_->screen_name;
	bundle_put_string (bundle, "screen_name", _tmp4_);
	_tmp5_ = self->priv->window;
	_tmp6_ = _tmp5_->main_widget;
	main_widget_switch_page (_tmp6_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_name_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	ComposeTweetWindow* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = self->priv->window;
	_tmp4_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY, _tmp4_);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	_tmp6_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = tweet_list_entry_get_shows_actions (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_reply_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_quote_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = self->priv->window;
	_tmp4_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE, _tmp4_);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	tweet_list_entry_toggle_mode (self);
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = self->priv->window;
	_tmp4_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY, _tmp4_);
	g_object_ref_sink (_tmp5_);
	ctw = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_delete_activated (TweetListEntry* self) {
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->delete_first_activated = TRUE;
	g_signal_emit_by_name (self, "delete-tweet");
	tweet_list_entry_toggle_mode (self);
}


static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = self->priv->window;
	_tmp2_ = tweet_utils_activate_link (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static void tweet_list_entry_media_invalid_cb (TweetListEntry* self) {
	GtkLabel* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_formatted_text (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


/**
   * Updates the time delta label in the upper right
   *
   * @return The seconds between the current time and
   *         the time the tweet was created
   */
static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	TweetListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_ = NULL;
	gint64 _tmp4_ = 0LL;
	Tweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GDateTime* then = NULL;
	GDateTime* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GDateTime* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GDateTime* _tmp16_ = NULL;
	GTimeSpan _tmp17_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_ = NULL;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_ = NULL;
		GDateTime* _tmp3_ = NULL;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->is_retweet;
	if (_tmp6_) {
		Tweet* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		_tmp7_ = self->tweet;
		_tmp8_ = _tmp7_->rt_created_at;
		_tmp4_ = _tmp8_;
	} else {
		Tweet* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp9_ = self->tweet;
		_tmp10_ = _tmp9_->created_at;
		_tmp4_ = _tmp10_;
	}
	_tmp11_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp11_;
	_tmp12_ = self->priv->time_delta_label;
	_tmp13_ = cur_time;
	_tmp14_ = utils_get_time_delta (then, _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = cur_time;
	_tmp17_ = g_date_time_difference (_tmp16_, then);
	result = (gint) ((_tmp17_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


void tweet_list_entry_toggle_mode (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->action_box;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		GtkStack* _tmp5_ = NULL;
		GtkGrid* _tmp6_ = NULL;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
	} else {
		GtkStack* _tmp7_ = NULL;
		GtkBox* _tmp8_ = NULL;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->action_box;
		gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	}
}


void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value) {
	MultiMediaWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TextButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->mm_widget;
	_tmp1_ = value;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !_tmp1_);
	_tmp2_ = self->priv->name_button;
	_tmp3_ = value;
	text_button_set_read_only (_tmp2_, _tmp3_);
	g_object_notify ((GObject *) self, "read-only");
}


static gint64 tweet_list_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	TweetListEntry* self;
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->created_at;
	result = _tmp1_;
	return result;
}


static gboolean tweet_list_entry_real_get_seen (ITwitterItem* base) {
	gboolean result;
	TweetListEntry* self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->priv->_seen;
	result = _tmp0_;
	return result;
}


static void tweet_list_entry_real_set_seen (ITwitterItem* base, gboolean value) {
	TweetListEntry* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = value;
	self->priv->_seen = _tmp0_;
	_tmp2_ = value;
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = self->notification_id;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = self->notification_id;
		notification_manager_withdraw (_tmp4_);
		_g_free0 (self->notification_id);
		self->notification_id = NULL;
	}
	g_object_notify ((GObject *) self, "seen");
}


gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self) {
	gboolean result;
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->action_box;
	result = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	return result;
}


static void tweet_list_entry_class_init (TweetListEntryClass * klass) {
	gint TweetListEntry_private_offset;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	GtkBindingSet* _tmp2_ = NULL;
	GtkBindingSet* _tmp3_ = NULL;
	GtkBindingSet* _tmp4_ = NULL;
	GtkBindingSet* _tmp5_ = NULL;
	GtkBindingSet* _tmp6_ = NULL;
	GtkBindingSet* _tmp7_ = NULL;
	tweet_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SHOWS_ACTIONS, g_param_spec_boolean ("shows-actions", "shows-actions", "shows-actions", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	TweetListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-list-entry.ui");
	g_signal_new ("reply_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("favorite_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("retweet_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("delete_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_delta_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, time_delta_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, conversation_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, fav_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_box", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, action_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "focus_out_cb", G_CALLBACK(_tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_released_cb", G_CALLBACK(_tweet_list_entry_key_released_cb_gtk_widget_key_release_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_list_entry_name_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_list_entry_link_activated_cb_gtk_label_activate_link));
	_tmp0_ = g_type_class_ref (TYPE_TWEET_LIST_ENTRY);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	binding_set = _tmp3_;
	_tmp4_ = binding_set;
	gtk_binding_entry_add_signal (_tmp4_, (guint) GDK_KEY_r, 0, "reply-tweet", (guint) 0, NULL, NULL);
	_tmp5_ = binding_set;
	gtk_binding_entry_add_signal (_tmp5_, (guint) GDK_KEY_d, 0, "delete-tweet", (guint) 0, NULL, NULL);
	_tmp6_ = binding_set;
	gtk_binding_entry_add_signal (_tmp6_, (guint) GDK_KEY_t, 0, "retweet-tweet", (guint) 0, NULL, NULL);
	_tmp7_ = binding_set;
	gtk_binding_entry_add_signal (_tmp7_, (guint) GDK_KEY_f, 0, "favorite-tweet", (guint) 0, NULL, NULL);
}


static void tweet_list_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	tweet_list_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) tweet_list_entry_real_update_time_delta;
	iface->get_sort_factor = tweet_list_entry_real_get_sort_factor;
	iface->get_seen = tweet_list_entry_real_get_seen;
	iface->set_seen = tweet_list_entry_real_set_seen;
}


static void tweet_list_entry_instance_init (TweetListEntry * self) {
	self->priv = TWEET_LIST_ENTRY_GET_PRIVATE (self);
	self->priv->_read_only = FALSE;
	self->priv->_seen = TRUE;
	self->notification_id = NULL;
	self->priv->values_set = FALSE;
	self->priv->delete_first_activated = FALSE;
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_DOUBLE_TAP_BUTTON);
	g_type_ensure (TYPE_TEXT_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_list_entry_finalize (GObject* obj) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->rt_image);
	_g_object_unref0 (self->priv->conversation_image);
	_g_object_unref0 (self->priv->rt_status_image);
	_g_object_unref0 (self->priv->fav_status_image);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->action_box);
	_g_free0 (self->notification_id);
	_g_object_unref0 (self->tweet);
	G_OBJECT_CLASS (tweet_list_entry_parent_class)->finalize (obj);
}


GType tweet_list_entry_get_type (void) {
	static volatile gsize tweet_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListEntry), 0, (GInstanceInitFunc) tweet_list_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) tweet_list_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_list_entry_type_id;
		tweet_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TweetListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_list_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&tweet_list_entry_type_id__volatile, tweet_list_entry_type_id);
	}
	return tweet_list_entry_type_id__volatile;
}


static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case TWEET_LIST_ENTRY_SEEN:
		g_value_set_boolean (value, itwitter_item_get_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case TWEET_LIST_ENTRY_SHOWS_ACTIONS:
		g_value_set_boolean (value, tweet_list_entry_get_shows_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_READ_ONLY:
		tweet_list_entry_set_read_only (self, g_value_get_boolean (value));
		break;
		case TWEET_LIST_ENTRY_SEEN:
		itwitter_item_set_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



