/* AccountCreateWidget.c generated by valac 0.26.2, the Vala compiler
 * generated from AccountCreateWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <rest/oauth-proxy.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <gdk/gdk.h>


#define TYPE_ACCOUNT_CREATE_WIDGET (account_create_widget_get_type ())
#define ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget))
#define ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))
#define IS_ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_CREATE_WIDGET))
#define IS_ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_CREATE_WIDGET))
#define ACCOUNT_CREATE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))

typedef struct _AccountCreateWidget AccountCreateWidget;
typedef struct _AccountCreateWidgetClass AccountCreateWidgetClass;
typedef struct _AccountCreateWidgetPrivate AccountCreateWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block41Data Block41Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

struct _AccountCreateWidget {
	GtkBox parent_instance;
	AccountCreateWidgetPrivate * priv;
};

struct _AccountCreateWidgetClass {
	GtkBoxClass parent_class;
};

struct _AccountCreateWidgetPrivate {
	GtkEntry* pin_entry;
	GtkLabel* error_label;
	GtkButton* confirm_button;
	GtkButton* request_pin_button;
	GtkLabel* info_label;
	Account* acc;
	Corebird* corebird;
};

struct _Block41Data {
	int _ref_count_;
	AccountCreateWidget* self;
	RestProxyCall* call;
};


static gpointer account_create_widget_parent_class = NULL;

GType account_create_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType corebird_get_type (void) G_GNUC_CONST;
#define ACCOUNT_CREATE_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetPrivate))
enum  {
	ACCOUNT_CREATE_WIDGET_DUMMY_PROPERTY
};
AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird);
AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird);
static void account_create_widget_pin_changed_cb (AccountCreateWidget* self);
static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self);
void account_create_widget_open_pin_request_site (AccountCreateWidget* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
OAuthProxy* account_get_proxy (Account* self);
void utils_show_error_dialog (const gchar* message);
static void account_create_widget_request_pin_clicked_cb (AccountCreateWidget* self);
static void _account_create_widget_request_pin_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_create_widget_confirm_button_clicked_cb (AccountCreateWidget* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void account_create_widget_show_error (AccountCreateWidget* self, const gchar* err);
static void __lambda169_ (Block41Data* _data41_, GObject* obj, GAsyncResult* res);
GSList* account_list_accounts (void);
const gchar* account_get_screen_name (Account* self);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static void __lambda170_ (AccountCreateWidget* self, GObject* obj, GAsyncResult* res);
void account_init_database (Account* self);
void account_save_info (Account* self);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
SqlDatabase* account_get_db (Account* self);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
static void ___lambda170__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda169__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _account_create_widget_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean account_create_widget_delete_event_cb (AccountCreateWidget* self);
void account_remove_account (const gchar* screen_name);
#define ACCOUNT_DUMMY "screen_name"
static gboolean _account_create_widget_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void account_create_widget_finalize (GObject* obj);


static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
	account_create_widget_pin_changed_cb ((AccountCreateWidget*) self);
}


static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self) {
	account_create_widget_pin_changed_cb ((AccountCreateWidget*) self);
}


AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird) {
	AccountCreateWidget * self = NULL;
	Account* _tmp0_ = NULL;
	Corebird* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkEntry* _tmp7_ = NULL;
	GtkEntryBuffer* _tmp8_ = NULL;
	GtkEntryBuffer* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	GtkEntryBuffer* _tmp11_ = NULL;
	GtkEntryBuffer* _tmp12_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	g_return_val_if_fail (IS_COREBIRD (corebird), NULL);
	self = (AccountCreateWidget*) g_object_new (object_type, NULL);
	_tmp0_ = acc;
	self->priv->acc = _tmp0_;
	_tmp1_ = corebird;
	self->priv->corebird = _tmp1_;
	_tmp2_ = self->priv->info_label;
	_tmp3_ = _ ("Don't have an account yet?");
	_tmp4_ = _ ("Create one");
	_tmp5_ = g_strdup_printf ("%s <a href=\"http://twitter.com/signup\">%s</a>", _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->pin_entry;
	_tmp8_ = gtk_entry_get_buffer (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "deleted-text", (GCallback) _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text, self, 0);
	_tmp10_ = self->priv->pin_entry;
	_tmp11_ = gtk_entry_get_buffer (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "inserted-text", (GCallback) _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text, self, 0);
	return self;
}


AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird) {
	return account_create_widget_construct (TYPE_ACCOUNT_CREATE_WIDGET, acc, corebird);
}


void account_create_widget_open_pin_request_site (AccountCreateWidget* self) {
	Account* _tmp0_ = NULL;
	gchar* uri = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	_tmp0_ = self->priv->acc;
	account_init_proxy (_tmp0_, FALSE, TRUE);
	uri = NULL;
	{
		Account* _tmp1_ = NULL;
		OAuthProxy* _tmp2_ = NULL;
		OAuthProxy* _tmp3_ = NULL;
		Account* _tmp4_ = NULL;
		OAuthProxy* _tmp5_ = NULL;
		OAuthProxy* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp1_ = self->priv->acc;
		_tmp2_ = account_get_proxy (_tmp1_);
		_tmp3_ = _tmp2_;
		oauth_proxy_request_token (_tmp3_, "oauth/request_token", "oob", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch44_g_error;
		}
		_tmp4_ = self->priv->acc;
		_tmp5_ = account_get_proxy (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = oauth_proxy_get_token (_tmp6_);
		_tmp8_ = g_strconcat ("http://twitter.com/oauth/authorize?oauth_token=", _tmp7_, NULL);
		_g_free0 (uri);
		uri = _tmp8_;
		_tmp9_ = uri;
		g_debug ("AccountCreateWidget.vala:51: Trying to open %s", _tmp9_);
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strcmp0 (_tmp13_, "unauthorized") == 0;
		_g_free0 (_tmp13_);
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = _ ("Unauthorized. Most of the time, this means that there's something wron" \
"g with the Twitter servers and you should try again later");
			utils_show_error_dialog (_tmp15_);
		} else {
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			utils_show_error_dialog (_tmp17_);
		}
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("AccountCreateWidget.vala:58: %s", _tmp19_);
		_g_error_free0 (e);
		_g_free0 (uri);
		return;
	}
	__finally44:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = uri;
		_tmp22_ = g_app_info_launch_default_for_uri (_tmp21_, NULL, &_inner_error_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
		if (!_tmp20_) {
			GtkLabel* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GtkLabel* _tmp37_ = NULL;
			_tmp23_ = self->priv->error_label;
			_tmp24_ = _ ("Could not open %s");
			_tmp25_ = uri;
			_tmp26_ = g_strconcat ("<a href=\"", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp27_, "\">", NULL);
			_tmp29_ = _tmp28_;
			_tmp30_ = uri;
			_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, "</a>", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strdup_printf (_tmp24_, _tmp34_);
			_tmp36_ = _tmp35_;
			gtk_label_set_label (_tmp23_, _tmp36_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
			_tmp37_ = self->priv->error_label;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
		}
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		utils_show_error_dialog (_tmp39_);
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_critical ("AccountCreateWidget.vala:70: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


static void account_create_widget_request_pin_clicked_cb (AccountCreateWidget* self) {
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	account_create_widget_open_pin_request_site (self);
}


static void _account_create_widget_request_pin_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_create_widget_request_pin_clicked_cb ((AccountCreateWidget*) self);
}


static Block41Data* block41_data_ref (Block41Data* _data41_) {
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}


static void block41_data_unref (void * _userdata_) {
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		AccountCreateWidget* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->call);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda170_ (AccountCreateWidget* self, GObject* obj, GAsyncResult* res) {
	Account* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	SqlDatabase* _tmp5_ = NULL;
	SqlDatabase* _tmp6_ = NULL;
	SqlInsertStatement* _tmp7_ = NULL;
	SqlInsertStatement* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	OAuthProxy* _tmp10_ = NULL;
	OAuthProxy* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	SqlInsertStatement* _tmp14_ = NULL;
	SqlInsertStatement* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	OAuthProxy* _tmp17_ = NULL;
	OAuthProxy* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	SqlInsertStatement* _tmp21_ = NULL;
	SqlInsertStatement* _tmp22_ = NULL;
	Account* _tmp23_ = NULL;
	Corebird* _tmp24_ = NULL;
	Account* _tmp25_ = NULL;
	Account* _tmp26_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = self->priv->acc;
	_tmp1_ = res;
	account_query_user_info_by_screen_name_finish (_tmp0_, _tmp1_);
	g_debug ("AccountCreateWidget.vala:126: user info call");
	_tmp2_ = self->priv->acc;
	account_init_database (_tmp2_);
	_tmp3_ = self->priv->acc;
	account_save_info (_tmp3_);
	_tmp4_ = self->priv->acc;
	_tmp5_ = account_get_db (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sql_database_insert (_tmp6_, "common");
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->acc;
	_tmp10_ = account_get_proxy (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = oauth_proxy_get_token (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = sql_insert_statement_val (_tmp8_, "token", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->acc;
	_tmp17_ = account_get_proxy (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = oauth_proxy_get_token_secret (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sql_insert_statement_val (_tmp15_, "token_secret", _tmp20_);
	_tmp22_ = _tmp21_;
	sql_insert_statement_run (_tmp22_);
	_sql_insert_statement_unref0 (_tmp22_);
	_sql_insert_statement_unref0 (_tmp15_);
	_sql_insert_statement_unref0 (_tmp8_);
	_tmp23_ = self->priv->acc;
	account_init_proxy (_tmp23_, TRUE, TRUE);
	_tmp24_ = self->priv->corebird;
	_tmp25_ = self->priv->acc;
	g_signal_emit_by_name (_tmp24_, "account-added", _tmp25_);
	_tmp26_ = self->priv->acc;
	g_signal_emit_by_name (self, "result-received", TRUE, _tmp26_);
}


static void ___lambda170__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda170_ ((AccountCreateWidget*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda169_ (Block41Data* _data41_, GObject* obj, GAsyncResult* res) {
	AccountCreateWidget* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	JsonObject* root = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonObject* _tmp8_ = NULL;
	JsonObject* _tmp9_ = NULL;
	gchar* screen_name = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GSList* current_accounts = NULL;
	GSList* _tmp14_ = NULL;
	GSList* _tmp15_ = NULL;
	Account* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data41_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		RestProxyCall* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = _data41_->call;
		_tmp2_ = rest_proxy_call_get_payload (_tmp1_);
		json_parser_load_from_data (parser, _tmp2_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch47_g_error;
		}
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RestProxyCall* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = _data41_->call;
		_tmp6_ = rest_proxy_call_get_payload (_tmp5_);
		g_critical ("AccountCreateWidget.vala:106: Problem with JSON Data: %s\n%s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally47:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = json_parser_get_root (parser);
	_tmp8_ = json_node_get_object (_tmp7_);
	_tmp9_ = _json_object_ref0 (_tmp8_);
	root = _tmp9_;
	_tmp10_ = root;
	_tmp11_ = json_object_get_string_member (_tmp10_, "screen_name");
	_tmp12_ = g_strdup (_tmp11_);
	screen_name = _tmp12_;
	_tmp13_ = screen_name;
	g_debug ("AccountCreateWidget.vala:110: Checking for %s", _tmp13_);
	_tmp14_ = account_list_accounts ();
	current_accounts = _tmp14_;
	_tmp15_ = current_accounts;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp15_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			Account* _tmp16_ = NULL;
			Account* a = NULL;
			_tmp16_ = _g_object_ref0 ((Account*) a_it->data);
			a = _tmp16_;
			{
				Account* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				_tmp17_ = a;
				_tmp18_ = account_get_screen_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = screen_name;
				if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
					Account* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					GtkEntry* _tmp23_ = NULL;
					GtkEntry* _tmp24_ = NULL;
					GtkButton* _tmp25_ = NULL;
					_tmp21_ = a;
					g_signal_emit_by_name (self, "result-received", FALSE, _tmp21_);
					g_critical ("AccountCreateWidget.vala:115: Account is already in use");
					_tmp22_ = _ ("Account already in use");
					account_create_widget_show_error (self, _tmp22_);
					_tmp23_ = self->priv->pin_entry;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), TRUE);
					_tmp24_ = self->priv->pin_entry;
					gtk_entry_set_text (_tmp24_, "");
					_tmp25_ = self->priv->request_pin_button;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), TRUE);
					_g_object_unref0 (a);
					_g_free0 (screen_name);
					_json_object_unref0 (root);
					_g_object_unref0 (parser);
					return;
				}
				_g_object_unref0 (a);
			}
		}
	}
	_tmp26_ = self->priv->acc;
	_tmp27_ = screen_name;
	account_query_user_info_by_screen_name (_tmp26_, _tmp27_, ___lambda170__gasync_ready_callback, g_object_ref (self));
	_g_free0 (screen_name);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


static void ___lambda169__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda169_ (self, source_object, res);
	block41_data_unref (self);
}


static void account_create_widget_confirm_button_clicked_cb (AccountCreateWidget* self) {
	Block41Data* _data41_;
	GtkEntry* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	Account* _tmp14_ = NULL;
	OAuthProxy* _tmp15_ = NULL;
	OAuthProxy* _tmp16_ = NULL;
	RestProxyCall* _tmp17_ = NULL;
	RestProxyCall* _tmp18_ = NULL;
	RestProxyCall* _tmp19_ = NULL;
	RestProxyCall* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = self->priv->pin_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->confirm_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->request_pin_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
	{
		Account* _tmp3_ = NULL;
		OAuthProxy* _tmp4_ = NULL;
		OAuthProxy* _tmp5_ = NULL;
		GtkEntry* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp3_ = self->priv->acc;
		_tmp4_ = account_get_proxy (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->pin_entry;
		_tmp7_ = gtk_entry_get_text (_tmp6_);
		oauth_proxy_access_token (_tmp5_, "oauth/access_token", _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch46_g_error;
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GtkEntry* _tmp11_ = NULL;
		GtkButton* _tmp12_ = NULL;
		GtkButton* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("AccountCreateWidget.vala:87: %s", _tmp9_);
		_tmp10_ = _ ("Wrong PIN");
		account_create_widget_show_error (self, _tmp10_);
		_tmp11_ = self->priv->pin_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp12_ = self->priv->confirm_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp13_ = self->priv->request_pin_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (e);
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return;
	}
	__finally46:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		block41_data_unref (_data41_);
		_data41_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = self->priv->acc;
	_tmp15_ = account_get_proxy (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, rest_proxy_get_type (), RestProxy));
	_data41_->call = _tmp17_;
	_tmp18_ = _data41_->call;
	rest_proxy_call_set_function (_tmp18_, "1.1/account/settings.json");
	_tmp19_ = _data41_->call;
	rest_proxy_call_set_method (_tmp19_, "GET");
	_tmp20_ = _data41_->call;
	rest_proxy_call_invoke_async (_tmp20_, NULL, ___lambda169__gasync_ready_callback, block41_data_ref (_data41_));
	block41_data_unref (_data41_);
	_data41_ = NULL;
}


static void _account_create_widget_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_create_widget_confirm_button_clicked_cb ((AccountCreateWidget*) self);
}


static void account_create_widget_show_error (AccountCreateWidget* self, const gchar* err) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	g_return_if_fail (err != NULL);
	_tmp0_ = self->priv->info_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->error_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp2_ = self->priv->error_label;
	_tmp3_ = err;
	gtk_label_set_label (_tmp2_, _tmp3_);
}


static void account_create_widget_pin_changed_cb (AccountCreateWidget* self) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean confirm_possible = FALSE;
	GtkButton* _tmp10_ = NULL;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	_tmp0_ = self->priv->pin_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp4_ = text;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		Account* _tmp7_ = NULL;
		OAuthProxy* _tmp8_ = NULL;
		OAuthProxy* _tmp9_ = NULL;
		_tmp7_ = self->priv->acc;
		_tmp8_ = account_get_proxy (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	confirm_possible = _tmp3_;
	_tmp10_ = self->priv->confirm_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), confirm_possible);
	_g_free0 (text);
}


static gboolean account_create_widget_delete_event_cb (AccountCreateWidget* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_ACCOUNT_CREATE_WIDGET (self), FALSE);
	account_remove_account (ACCOUNT_DUMMY);
	result = FALSE;
	return result;
}


static gboolean _account_create_widget_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = account_create_widget_delete_event_cb ((AccountCreateWidget*) self);
	return result;
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_OBJECT) (gpointer data1, gboolean arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void account_create_widget_class_init (AccountCreateWidgetClass * klass) {
	gint AccountCreateWidget_private_offset;
	account_create_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountCreateWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = account_create_widget_finalize;
	AccountCreateWidget_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/account-create-widget.ui");
	g_signal_new ("result_received", TYPE_ACCOUNT_CREATE_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, TYPE_ACCOUNT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pin_entry", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, pin_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "confirm_button", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, confirm_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "request_pin_button", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, request_pin_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_label", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, info_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_pin_clicked_cb", G_CALLBACK(_account_create_widget_request_pin_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "confirm_button_clicked_cb", G_CALLBACK(_account_create_widget_confirm_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_event_cb", G_CALLBACK(_account_create_widget_delete_event_cb_gtk_widget_delete_event));
}


static void account_create_widget_instance_init (AccountCreateWidget * self) {
	self->priv = ACCOUNT_CREATE_WIDGET_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void account_create_widget_finalize (GObject* obj) {
	AccountCreateWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget);
	_g_object_unref0 (self->priv->pin_entry);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->confirm_button);
	_g_object_unref0 (self->priv->request_pin_button);
	_g_object_unref0 (self->priv->info_label);
	G_OBJECT_CLASS (account_create_widget_parent_class)->finalize (obj);
}


GType account_create_widget_get_type (void) {
	static volatile gsize account_create_widget_type_id__volatile = 0;
	if (g_once_init_enter (&account_create_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountCreateWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_create_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountCreateWidget), 0, (GInstanceInitFunc) account_create_widget_instance_init, NULL };
		GType account_create_widget_type_id;
		account_create_widget_type_id = g_type_register_static (gtk_box_get_type (), "AccountCreateWidget", &g_define_type_info, 0);
		g_once_init_leave (&account_create_widget_type_id__volatile, account_create_widget_type_id);
	}
	return account_create_widget_type_id__volatile;
}



