/* AvatarWidget.c generated by valac 0.26.2, the Vala compiler
 * generated from AvatarWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;
typedef struct _AvatarWidgetPrivate AvatarWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AvatarWidget {
	GtkImage parent_instance;
	AvatarWidgetPrivate * priv;
};

struct _AvatarWidgetClass {
	GtkImageClass parent_class;
};

struct _AvatarWidgetPrivate {
	gboolean _round;
	gboolean _verified;
};


static gpointer avatar_widget_parent_class = NULL;
static cairo_surface_t** avatar_widget_verified_icons;
static gint avatar_widget_verified_icons_length1;
static cairo_surface_t** avatar_widget_verified_icons = NULL;
static gint avatar_widget_verified_icons_length1 = 0;
static gint _avatar_widget_verified_icons_size_ = 0;

GType avatar_widget_get_type (void) G_GNUC_CONST;
#define AVATAR_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_WIDGET, AvatarWidgetPrivate))
enum  {
	AVATAR_WIDGET_DUMMY_PROPERTY,
	AVATAR_WIDGET_MAKE_ROUND,
	AVATAR_WIDGET_VERIFIED
};
#define AVATAR_WIDGET_SMALL 0
#define AVATAR_WIDGET_LARGE 1
static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx);
gboolean avatar_widget_get_verified (AvatarWidget* self);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
gboolean avatar_widget_get_make_round (AvatarWidget* self);
void avatar_widget_set_make_round (AvatarWidget* self, gboolean value);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GSettings* settings_get (void);
static void avatar_widget_finalize (GObject* obj);
static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gint AVATAR_WIDGET_VERIFIED_SIZES[2] = {12, 18};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx) {
	AvatarWidget * self;
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp10_ = NULL;
	cairo_surface_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	cairo_surface_t* _tmp14_ = NULL;
	cairo_t* ct = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_t* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	GdkPixbuf* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	cairo_t* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	cairo_t* _tmp56_ = NULL;
	cairo_surface_t* _tmp57_ = NULL;
	cairo_t* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	height = _tmp1_;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_image_get_type (), GtkImage), "pixbuf", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = width;
	_tmp7_ = height;
	if (_tmp6_ != _tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = width;
		_tmp9_ = height;
		g_warning ("AvatarWidget.vala:73: Avatar with mapped with width %d and height %d", _tmp8_, _tmp9_);
	}
	_tmp10_ = ctx;
	_tmp11_ = cairo_get_target (_tmp10_);
	_tmp12_ = width;
	_tmp13_ = height;
	_tmp14_ = cairo_surface_create_similar (_tmp11_, CAIRO_CONTENT_COLOR_ALPHA, _tmp12_, _tmp13_);
	surface = _tmp14_;
	_tmp15_ = surface;
	_tmp16_ = cairo_create (_tmp15_);
	ct = _tmp16_;
	_tmp17_ = ct;
	_tmp18_ = width;
	_tmp19_ = height;
	cairo_rectangle (_tmp17_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp18_, (gdouble) _tmp19_);
	_tmp20_ = ct;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_image_get_type (), GtkImage), "pixbuf", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	gdk_cairo_set_source_pixbuf (_tmp20_, _tmp23_, (gdouble) 0, (gdouble) 0);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = ct;
	cairo_fill (_tmp24_);
	_tmp25_ = self->priv->_round;
	if (_tmp25_) {
		GtkStyleContext* sc = NULL;
		GtkStyleContext* _tmp26_ = NULL;
		GtkStyleContext* _tmp27_ = NULL;
		cairo_t* _tmp28_ = NULL;
		cairo_t* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		cairo_t* _tmp33_ = NULL;
		cairo_t* _tmp34_ = NULL;
		GdkRGBA border_color = {0};
		GtkStyleContext* _tmp35_ = NULL;
		GtkStateFlags _tmp36_ = 0;
		GdkRGBA _tmp37_ = {0};
		cairo_t* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		cairo_t* _tmp42_ = NULL;
		cairo_t* _tmp43_ = NULL;
		GdkRGBA _tmp44_ = {0};
		gdouble _tmp45_ = 0.0;
		GdkRGBA _tmp46_ = {0};
		gdouble _tmp47_ = 0.0;
		GdkRGBA _tmp48_ = {0};
		gdouble _tmp49_ = 0.0;
		GdkRGBA _tmp50_ = {0};
		gdouble _tmp51_ = 0.0;
		cairo_t* _tmp52_ = NULL;
		_tmp26_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = _g_object_ref0 (_tmp26_);
		sc = _tmp27_;
		_tmp28_ = ct;
		cairo_set_operator (_tmp28_, CAIRO_OPERATOR_DEST_IN);
		_tmp29_ = ct;
		_tmp30_ = width;
		_tmp31_ = height;
		_tmp32_ = width;
		cairo_arc (_tmp29_, _tmp30_ / 2.0, _tmp31_ / 2.0, (_tmp32_ / 2.0) - 0.5, (gdouble) 0, 2 * G_PI);
		_tmp33_ = ct;
		cairo_fill (_tmp33_);
		_tmp34_ = ct;
		cairo_set_operator (_tmp34_, CAIRO_OPERATOR_OVER);
		_tmp35_ = sc;
		_tmp36_ = gtk_widget_get_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_get_border_color (_tmp35_, _tmp36_, &_tmp37_);
		border_color = _tmp37_;
		_tmp38_ = ct;
		_tmp39_ = width;
		_tmp40_ = height;
		_tmp41_ = width;
		cairo_arc (_tmp38_, _tmp39_ / 2.0, _tmp40_ / 2.0, (_tmp41_ / 2.0) - 0.5, (gdouble) 0, 2 * G_PI);
		_tmp42_ = ct;
		cairo_set_line_width (_tmp42_, 1.0);
		_tmp43_ = ct;
		_tmp44_ = border_color;
		_tmp45_ = _tmp44_.red;
		_tmp46_ = border_color;
		_tmp47_ = _tmp46_.green;
		_tmp48_ = border_color;
		_tmp49_ = _tmp48_.blue;
		_tmp50_ = border_color;
		_tmp51_ = _tmp50_.alpha;
		cairo_set_source_rgba (_tmp43_, _tmp45_, _tmp47_, _tmp49_, _tmp51_);
		_tmp52_ = ct;
		cairo_stroke (_tmp52_);
		_g_object_unref0 (sc);
	}
	_tmp53_ = ctx;
	_tmp54_ = width;
	_tmp55_ = height;
	cairo_rectangle (_tmp53_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp54_, (gdouble) _tmp55_);
	_tmp56_ = ctx;
	_tmp57_ = surface;
	cairo_set_source_surface (_tmp56_, _tmp57_, (gdouble) 0, (gdouble) 0);
	_tmp58_ = ctx;
	cairo_fill (_tmp58_);
	_tmp59_ = self->priv->_verified;
	if (_tmp59_) {
		gint index = 0;
		gint _tmp60_ = 0;
		gint scale_factor = 0;
		gint _tmp61_ = 0;
		cairo_surface_t* verified_img = NULL;
		cairo_surface_t** _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		cairo_surface_t* _tmp65_ = NULL;
		cairo_surface_t* _tmp66_ = NULL;
		cairo_t* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		cairo_t* _tmp70_ = NULL;
		cairo_surface_t* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		cairo_t* _tmp75_ = NULL;
		index = AVATAR_WIDGET_SMALL;
		_tmp60_ = width;
		if (_tmp60_ > 48) {
			index = AVATAR_WIDGET_LARGE;
		}
		_tmp61_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		scale_factor = _tmp61_ - 1;
		_tmp62_ = avatar_widget_verified_icons;
		_tmp62__length1 = avatar_widget_verified_icons_length1;
		_tmp63_ = scale_factor;
		_tmp64_ = index;
		_tmp65_ = _tmp62_[(_tmp63_ * 2) + _tmp64_];
		_tmp66_ = _cairo_surface_reference0 (_tmp65_);
		verified_img = _tmp66_;
		_tmp67_ = ctx;
		_tmp68_ = width;
		_tmp69_ = height;
		cairo_rectangle (_tmp67_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp68_, (gdouble) _tmp69_);
		_tmp70_ = ctx;
		_tmp71_ = verified_img;
		_tmp72_ = width;
		_tmp73_ = index;
		_tmp74_ = AVATAR_WIDGET_VERIFIED_SIZES[_tmp73_];
		cairo_set_source_surface (_tmp70_, _tmp71_, (gdouble) (_tmp72_ - _tmp74_), (gdouble) 0);
		_tmp75_ = ctx;
		cairo_fill (_tmp75_);
		_cairo_surface_destroy0 (verified_img);
	}
	result = FALSE;
	_cairo_destroy0 (ct);
	_cairo_surface_destroy0 (surface);
	return result;
}


AvatarWidget* avatar_widget_construct (GType object_type) {
	AvatarWidget * self = NULL;
	self = (AvatarWidget*) g_object_new (object_type, NULL);
	return self;
}


AvatarWidget* avatar_widget_new (void) {
	return avatar_widget_construct (TYPE_AVATAR_WIDGET);
}


gboolean avatar_widget_get_make_round (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_make_round (AvatarWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = value;
	self->priv->_round = _tmp0_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "make-round");
}


gboolean avatar_widget_get_verified (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_verified;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_verified (AvatarWidget* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = value;
	self->priv->_verified = _tmp0_;
	g_object_notify ((GObject *) self, "verified");
}


static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarWidget * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (avatar_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_settings_bind (_tmp1_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "make_round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "avatar");
	return obj;
}


static void avatar_widget_class_init (AvatarWidgetClass * klass) {
	GError * _inner_error_ = NULL;
	avatar_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = avatar_widget_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_avatar_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avatar_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = avatar_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_MAKE_ROUND, g_param_spec_boolean ("make-round", "make-round", "make-round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_VERIFIED, g_param_spec_boolean ("verified", "verified", "verified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		cairo_surface_t* _tmp9_ = NULL;
		cairo_surface_t* _tmp10_ = NULL;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_surface_t** _tmp12_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-small.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch53_g_error;
		}
		_tmp3_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-large.png", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch53_g_error;
		}
		_tmp5_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-small@2.png", &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch53_g_error;
		}
		_tmp7_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/verified-large@2.png", &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch53_g_error;
		}
		_tmp8_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_tmp9_ = gdk_cairo_surface_create_from_pixbuf (_tmp2_, 1, NULL);
		_tmp10_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 2, NULL);
		_tmp11_ = gdk_cairo_surface_create_from_pixbuf (_tmp6_, 2, NULL);
		_tmp12_ = g_new0 (cairo_surface_t*, 4 + 1);
		_tmp12_[0] = _tmp8_;
		_tmp12_[1] = _tmp9_;
		_tmp12_[2] = _tmp10_;
		_tmp12_[3] = _tmp11_;
		avatar_widget_verified_icons = (_vala_array_free (avatar_widget_verified_icons, avatar_widget_verified_icons_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		avatar_widget_verified_icons = _tmp12_;
		avatar_widget_verified_icons_length1 = 4;
		_avatar_widget_verified_icons_size_ = avatar_widget_verified_icons_length1;
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("AvatarWidget.vala:53: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void avatar_widget_instance_init (AvatarWidget * self) {
	self->priv = AVATAR_WIDGET_GET_PRIVATE (self);
	self->priv->_round = TRUE;
	self->priv->_verified = FALSE;
}


static void avatar_widget_finalize (GObject* obj) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	G_OBJECT_CLASS (avatar_widget_parent_class)->finalize (obj);
}


GType avatar_widget_get_type (void) {
	static volatile gsize avatar_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarWidget), 0, (GInstanceInitFunc) avatar_widget_instance_init, NULL };
		GType avatar_widget_type_id;
		avatar_widget_type_id = g_type_register_static (gtk_image_get_type (), "AvatarWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_widget_type_id__volatile, avatar_widget_type_id);
	}
	return avatar_widget_type_id__volatile;
}


static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND:
		g_value_set_boolean (value, avatar_widget_get_make_round (self));
		break;
		case AVATAR_WIDGET_VERIFIED:
		g_value_set_boolean (value, avatar_widget_get_verified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND:
		avatar_widget_set_make_round (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_VERIFIED:
		avatar_widget_set_verified (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



